/*
 * Decompiled with CFR 0.152.
 */
package com.tombrus.javaParser;

import com.tombrus.javaParser.ParserException;
import com.tombrus.javaParser.Token;
import com.tombrus.util.DB;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleStreamTokenizer
implements Token.Iterator {
    public static boolean DEBUG = DB.MORE("SimpleStreamTokenizer");
    private static int SLICELEN = 10240;
    private static char EOF = (char)65535;
    int tabSize;
    char[] buffer = new char[0];
    char currChar;
    char peekChar;
    Token currToken;
    int line;
    int column;
    int index;
    private static Pattern unicodeEOLPattern = Pattern.compile("(\\\\+)u+000(D(\\\\u+000A)?|A)");
    private static Pattern unicodeEOLAtEndPattern = Pattern.compile("(\\\\+)u+000(D(\\\\u+000A)?|A)$");

    SimpleStreamTokenizer(int n, Reader reader) {
        this.tabSize = n;
        this.line = 1;
        this.column = 1;
        this.index = 0;
        this.fillBuffer(reader);
    }

    private void fillBuffer(Reader reader) {
        try {
            int n;
            ArrayList<char[]> arrayList = new ArrayList<char[]>();
            char[] cArray = new char[SLICELEN];
            while ((n = reader.read(cArray)) != -1) {
                if (n == SLICELEN) {
                    arrayList.add(cArray);
                    cArray = new char[SLICELEN];
                    continue;
                }
                this.buffer = new char[arrayList.size() * SLICELEN + n];
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    System.arraycopy((char[])arrayList.get(n2), 0, this.buffer, n2 * SLICELEN, SLICELEN);
                    arrayList.set(n2, null);
                    ++n2;
                }
                System.arraycopy(cArray, 0, this.buffer, arrayList.size() * SLICELEN, n);
            }
        }
        catch (IOException iOException) {
            throw new ParserException("Unexpected Exception: " + iOException.getMessage());
        }
    }

    public Token getCurrentToken() {
        return this.currToken;
    }

    public Token getNextRelevantToken() {
        do {
            this.getNextToken();
        } while (this.currToken.type == 750 || this.currToken.type == 751);
        return this.currToken;
    }

    public Token getNextToken() {
        StringBuffer stringBuffer = new StringBuffer();
        this.currToken = this.currToken != null ? (this.currToken.next = new Token()) : new Token();
        this.currToken.fromIndex = this.index;
        this.currToken.from.line = this.line;
        this.currToken.from.column = this.column;
        this.moveOneChar();
        if (this.currChar != EOF) {
            if (Character.isWhitespace(this.currChar)) {
                this.currToken.type = 750;
                stringBuffer.append(this.currChar);
            } else if (Character.isJavaIdentifierPart(this.currChar)) {
                this.currToken.type = 754;
                stringBuffer.append(this.currChar);
                while (this.currChar != EOF && Character.isJavaIdentifierPart(this.peekChar)) {
                    this.moveOneChar();
                    stringBuffer.append(this.currChar);
                }
            } else if (this.currChar == '/' && this.peekChar == '*') {
                this.currToken.type = 751;
                stringBuffer.append(this.currChar);
                this.moveOneChar();
                stringBuffer.append(this.currChar);
                this.moveOneChar();
                while (this.currChar != EOF && (this.currChar != '*' || this.peekChar != '/')) {
                    stringBuffer.append(this.currChar);
                    this.moveOneChar();
                }
                stringBuffer.append(this.currChar);
                this.moveOneChar();
                stringBuffer.append(this.currChar);
                this.correctForUnicodeEOL(stringBuffer);
            } else if (this.currChar == '/' && this.peekChar == '/') {
                this.currToken.type = 751;
                stringBuffer.append(this.currChar);
                this.moveOneChar();
                stringBuffer.append(this.currChar);
                this.moveOneChar();
                while (true) {
                    stringBuffer.append(this.currChar);
                    if (this.currChar != EOF && this.currChar != '\n' && this.currChar != '\r' && !this.endsWithUnicodeEOL(stringBuffer)) {
                        this.moveOneChar();
                        continue;
                    }
                    break;
                }
            } else if (this.currChar == '\"') {
                this.currToken.type = 752;
                stringBuffer.append(this.currChar);
                this.moveOneChar();
                while (this.currChar != EOF && this.currChar != '\"') {
                    stringBuffer.append(this.currChar);
                    if (this.currChar == '\\') {
                        this.moveOneChar();
                        stringBuffer.append(this.currChar);
                    }
                    this.moveOneChar();
                }
                stringBuffer.append(this.currChar);
            } else if (this.currChar == '\'') {
                this.currToken.type = 753;
                stringBuffer.append(this.currChar);
                this.moveOneChar();
                while (this.currChar != EOF && this.currChar != '\'') {
                    stringBuffer.append(this.currChar);
                    if (this.currChar == '\\') {
                        this.moveOneChar();
                        stringBuffer.append(this.currChar);
                    }
                    this.moveOneChar();
                }
                stringBuffer.append(this.currChar);
            } else {
                this.currToken.type = 755;
                stringBuffer.append(this.currChar);
            }
        } else {
            this.currToken.type = 799;
            this.currToken.value = "";
            this.currToken.next = this.currToken;
        }
        this.currToken.value = stringBuffer.toString();
        this.currToken.toIndex = this.index;
        this.currToken.to.line = this.line;
        this.currToken.to.column = this.column;
        if (DEBUG) {
            System.err.println(" - " + this.currToken);
        }
        return this.currToken;
    }

    void moveOneChar() {
        char c;
        this.currChar = this.nextChar();
        this.peekChar = c = this.index >= this.buffer.length ? EOF : this.buffer[this.index];
    }

    char nextChar() {
        char c;
        char c2 = c = this.index >= this.buffer.length ? EOF : this.buffer[this.index++];
        if (c != EOF) {
            if (c == '\t') {
                this.column = (this.column - 1) / this.tabSize * this.tabSize + this.tabSize;
            }
            ++this.column;
            if (c == '\r' || c == '\n') {
                char c3;
                char c4 = c3 = this.index >= this.buffer.length ? EOF : this.buffer[this.index];
                if (c == '\r' && c3 == '\n') {
                    c = this.index >= this.buffer.length ? EOF : this.buffer[this.index++];
                }
                ++this.line;
                this.column = 1;
            }
        }
        return c;
    }

    private void correctForUnicodeEOL(StringBuffer stringBuffer) {
        Matcher matcher = unicodeEOLPattern.matcher(stringBuffer.toString());
        int n = 0;
        while (matcher.find()) {
            ++this.line;
            n = matcher.end(0);
        }
        if (n != 0) {
            this.column = stringBuffer.length() - n + 1;
        }
    }

    private boolean endsWithUnicodeEOL(StringBuffer stringBuffer) {
        boolean bl;
        Matcher matcher = unicodeEOLAtEndPattern.matcher(stringBuffer.toString());
        boolean bl2 = bl = matcher.find() && (matcher.group(1).length() & 1) == 1;
        if (bl) {
            ++this.line;
            this.column = 1;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        try {
            File file = new File("<non existent>");
            file = file.exists() ? file : new File("D:/Projects/Optidev-tomWerk3/Optidev/Pasta/testenv/source/NorthPole.java");
            file = file.exists() ? file : new File("D:/Projects/Optidev-tomWerk3/Optidev/Pasta/source/");
            file = file.exists() ? file : new File("D:/Projects/Optidev-tomWerk3/Optidev/Pasta/testenv/source2");
            file = file.exists() ? file : new File("D:/Projects/Optidev-tomWerk3/Optidev/Pasta/testenv/source/DepTest.java");
            file = file.exists() ? file : new File("D:/java/j2sdk1.4.0_03/Src/java/nio/channels/Channels.java");
            SimpleStreamTokenizer simpleStreamTokenizer = new SimpleStreamTokenizer(4, new BufferedReader(new FileReader(file)));
            while (simpleStreamTokenizer.getNextToken().type != 799) {
                System.err.println("+ " + simpleStreamTokenizer.getCurrentToken());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

