/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.framework.acl;

import com.highesthelp.framework.acl.IUserDetails;
import com.highesthelp.framework.acl.UserDetailsImpl;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.acegisecurity.userdetails.jdbc.JdbcDaoImpl;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.object.MappingSqlQuery;

public class AcegiJdbcDaoImpl
extends JdbcDaoImpl {
    public static final String DEF_USERS_BY_USERNAME_QUERY = "SELECT u.user_pk, u.department_pk, user_name, password, enabled,real_name from role r, user_role ur, operator_user u where r.role_pk = ur.role_pk and ur.user_pk = u.user_pk and user_name = ? limit 1";
    public static final String DEF_AUTHORITIES_BY_USERNAME_QUERY = "SELECT username,authority FROM authorities WHERE username = ?";
    protected MappingSqlQuery rolesByUsernameMapping;
    protected MappingSqlQuery usersByNameMapping;
    private String authoritiesByUsernameQuery = "SELECT username,authority FROM authorities WHERE username = ?";
    private String rolePrefix = "";
    private String usersByUsernameQuery = "SELECT u.user_pk, u.department_pk, user_name, password, enabled,real_name from role r, user_role ur, operator_user u where r.role_pk = ur.role_pk and ur.user_pk = u.user_pk and user_name = ? limit 1";
    private boolean usernameBasedPrimaryKey = true;

    public String getAuthoritiesByUsernameQuery() {
        return this.authoritiesByUsernameQuery;
    }

    public String getRolePrefix() {
        return this.rolePrefix;
    }

    public String getUsersByUsernameQuery() {
        return this.usersByUsernameQuery;
    }

    protected void initMappingSqlQueries() {
        this.usersByNameMapping = new UsersByUsernameMapping(this.getDataSource());
        this.rolesByUsernameMapping = new AuthoritiesByUsernameMapping(this.getDataSource());
    }

    public void setAuthoritiesByUsernameQuery(String queryString) {
        this.authoritiesByUsernameQuery = queryString;
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
    }

    public void setUsernameBasedPrimaryKey(boolean usernameBasedPrimaryKey) {
        this.usernameBasedPrimaryKey = usernameBasedPrimaryKey;
    }

    public void setUsersByUsernameQuery(String usersByUsernameQueryString) {
        this.usersByUsernameQuery = usersByUsernameQueryString;
    }

    public IUserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        List users = this.usersByNameMapping.execute(username);
        if (users.size() == 0) {
            throw new UsernameNotFoundException("User not found");
        }
        IUserDetails user = (IUserDetails)users.get(0);
        List dbAuths = this.rolesByUsernameMapping.execute(user.getUsername());
        this.addCustomAuthorities(user.getUsername(), dbAuths);
        if (dbAuths.size() == 0) {
            throw new UsernameNotFoundException("User has no GrantedAuthority");
        }
        GrantedAuthority[] arrayAuths = dbAuths.toArray(new GrantedAuthority[dbAuths.size()]);
        user.setAuthorities(arrayAuths);
        if (!this.usernameBasedPrimaryKey) {
            user.setUserName(username);
        }
        return user;
    }

    protected class AuthoritiesByUsernameMapping
    extends MappingSqlQuery {
        protected AuthoritiesByUsernameMapping(DataSource ds) {
            super(ds, AcegiJdbcDaoImpl.this.authoritiesByUsernameQuery);
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }

        protected Object mapRow(ResultSet rs, int rownum) throws SQLException {
            String roleName = String.valueOf(AcegiJdbcDaoImpl.this.rolePrefix) + rs.getString(2);
            GrantedAuthorityImpl authority = new GrantedAuthorityImpl(roleName);
            return authority;
        }
    }

    protected class UsersByUsernameMapping
    extends MappingSqlQuery {
        protected UsersByUsernameMapping(DataSource ds) {
            super(ds, AcegiJdbcDaoImpl.this.usersByUsernameQuery);
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }

        protected Object mapRow(ResultSet rs, int rownum) throws SQLException {
            int userPk = rs.getInt(1);
            int departmentPk = rs.getInt(2);
            String userName = rs.getString(3);
            String password = rs.getString(4);
            boolean enabled = rs.getBoolean(5);
            String realName = rs.getString(6);
            UserDetailsImpl user = new UserDetailsImpl(userName, password, enabled, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("HOLDER")});
            user.setUserPk(userPk);
            user.setDepartmentPk(departmentPk);
            user.setRealName(realName);
            return user;
        }
    }
}

