/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.framework.acl;

import com.highesthelp.framework.acl.IPermissionListener;
import com.highesthelp.framework.acl.IResourceRole;
import com.highesthelp.framework.acl.PermissionEventPublisher;
import com.highesthelp.framework.acl.ResourceRoleImpl;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.SecurityConfig;
import org.acegisecurity.intercept.web.FilterInvocationDefinitionMap;
import org.acegisecurity.intercept.web.FilterInvocationDefinitionSource;
import org.acegisecurity.intercept.web.PathBasedFilterInvocationDefinitionMap;
import org.acegisecurity.intercept.web.RegExpBasedFilterInvocationDefinitionMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.jdbc.object.MappingSqlQuery;

public class AcegiJdbcDefinitionSourceImpl
extends JdbcDaoSupport
implements InitializingBean,
FilterInvocationDefinitionSource,
IPermissionListener {
    private Log logger = LogFactory.getLog(this.getClass());
    public static final String DEF_PERMISSIONS_QUERY = "SELECT resource, role FROM role_permission";
    String PERL5_KEY = "PATTERN_TYPE_PERL5";
    String ANT_PATH_KEY;
    private String resourceExpression = this.ANT_PATH_KEY = "PATTERN_TYPE_APACHE_ANT";
    private boolean convertUrlToLowercaseBeforeComparison = false;
    private FilterInvocationDefinitionMap definitionSource = null;
    private String permissionsQuery = "SELECT resource, role FROM role_permission";
    private String rolePrefix = "";

    public AcegiJdbcDefinitionSourceImpl() {
        PermissionEventPublisher.attach(this);
    }

    public String getAuthoritiesByUsernameQuery() {
        return this.permissionsQuery;
    }

    public String getRolePrefix() {
        return this.rolePrefix;
    }

    public void setPermissionsQuery(String queryString) {
        this.permissionsQuery = queryString;
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
    }

    protected void initMap() {
        if (this.definitionSource != null) {
            return;
        }
        this.logger.debug((Object)"getting permissions from db");
        if (this.PERL5_KEY.equals(this.getResourceExpression())) {
            this.definitionSource = new RegExpBasedFilterInvocationDefinitionMap();
        } else if (this.ANT_PATH_KEY.equals(this.getResourceExpression())) {
            this.definitionSource = new PathBasedFilterInvocationDefinitionMap();
        } else {
            throw new IllegalArgumentException("wrong resourceExpression value");
        }
        this.definitionSource.setConvertUrlToLowercaseBeforeComparison(this.isConvertUrlToLowercaseBeforeComparison());
        PermissionsMapping permissionsMapping = new PermissionsMapping(this.getDataSource());
        List resources = permissionsMapping.execute();
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < resources.size()) {
            ConfigAttributeDefinition defn = new ConfigAttributeDefinition();
            String resource = ((IResourceRole)resources.get(i)).getResource();
            if (!map.containsKey(resource)) {
                map.put(resource, resource);
                int j = i;
                while (j < resources.size()) {
                    IResourceRole resourceRole = (IResourceRole)resources.get(j);
                    if (resource.equals(resourceRole.getResource())) {
                        defn.addConfigAttribute((ConfigAttribute)new SecurityConfig(resourceRole.getRole()));
                    }
                    ++j;
                }
                this.definitionSource.addSecureUrl(((IResourceRole)resources.get(i)).getResource(), defn);
            }
            ++i;
        }
    }

    public ConfigAttributeDefinition getAttributes(Object object) throws IllegalArgumentException {
        this.initMap();
        if (this.definitionSource instanceof RegExpBasedFilterInvocationDefinitionMap) {
            return ((RegExpBasedFilterInvocationDefinitionMap)this.definitionSource).getAttributes(object);
        }
        if (this.definitionSource instanceof PathBasedFilterInvocationDefinitionMap) {
            return ((PathBasedFilterInvocationDefinitionMap)this.definitionSource).getAttributes(object);
        }
        throw new IllegalStateException("wrong type of " + this.definitionSource + ", it should be " + RegExpBasedFilterInvocationDefinitionMap.class + " or " + PathBasedFilterInvocationDefinitionMap.class);
    }

    public Iterator getConfigAttributeDefinitions() {
        this.initMap();
        if (this.definitionSource instanceof RegExpBasedFilterInvocationDefinitionMap) {
            return ((RegExpBasedFilterInvocationDefinitionMap)this.definitionSource).getConfigAttributeDefinitions();
        }
        if (this.definitionSource instanceof PathBasedFilterInvocationDefinitionMap) {
            return ((PathBasedFilterInvocationDefinitionMap)this.definitionSource).getConfigAttributeDefinitions();
        }
        throw new IllegalStateException("wrong type of " + this.definitionSource + ", it should be " + RegExpBasedFilterInvocationDefinitionMap.class + " or " + PathBasedFilterInvocationDefinitionMap.class);
    }

    public boolean supports(Class clazz) {
        this.initMap();
        if (this.definitionSource instanceof RegExpBasedFilterInvocationDefinitionMap) {
            return ((RegExpBasedFilterInvocationDefinitionMap)this.definitionSource).supports(clazz);
        }
        if (this.definitionSource instanceof PathBasedFilterInvocationDefinitionMap) {
            return ((PathBasedFilterInvocationDefinitionMap)this.definitionSource).supports(clazz);
        }
        throw new IllegalStateException("wrong type of " + this.definitionSource + ", it should be " + RegExpBasedFilterInvocationDefinitionMap.class + " or " + PathBasedFilterInvocationDefinitionMap.class);
    }

    public void updatePermission(Class eventSource) {
        this.definitionSource = null;
    }

    public String getResourceExpression() {
        return this.resourceExpression;
    }

    public void setResourceExpression(String resourceExpression) {
        this.resourceExpression = resourceExpression;
    }

    public boolean isConvertUrlToLowercaseBeforeComparison() {
        return this.convertUrlToLowercaseBeforeComparison;
    }

    public void setConvertUrlToLowercaseBeforeComparison(boolean convertUrlToLowercaseBeforeComparison) {
        this.convertUrlToLowercaseBeforeComparison = convertUrlToLowercaseBeforeComparison;
    }

    protected class PermissionsMapping
    extends MappingSqlQuery {
        protected PermissionsMapping(DataSource ds) {
            super(ds, AcegiJdbcDefinitionSourceImpl.this.permissionsQuery);
            this.compile();
        }

        protected IResourceRole mapRow(ResultSet rs, int rownum) throws SQLException {
            String resource = rs.getString(1);
            String role = String.valueOf(AcegiJdbcDefinitionSourceImpl.this.rolePrefix) + rs.getString(2);
            ResourceRoleImpl resourceRole = new ResourceRoleImpl(resource, role);
            return resourceRole;
        }
    }
}

