/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.framework.acl;

import com.highesthelp.framework.acl.IPermissionListener;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PermissionEventPublisher {
    private static Log logger = LogFactory.getLog(PermissionEventPublisher.class);
    private static Map<IPermissionListener, IPermissionListener> observerList = new HashMap<IPermissionListener, IPermissionListener>();

    public static void attach(IPermissionListener listener) {
        observerList.put(listener, listener);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added listener: " + listener.getClass().getName()));
        }
    }

    public static void detatch(IPermissionListener listener) {
        observerList.remove(listener);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removeded listener: " + listener.getClass().getName()));
        }
    }

    public static void update(Class eventSource) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("permission changed from " + eventSource.getName()));
        }
        for (IPermissionListener permissionListener : observerList.keySet()) {
            permissionListener.updatePermission(eventSource);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("call update for listener=" + permissionListener.getClass().getName()));
        }
    }
}

