/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.framework.action;

import com.highesthelp.framework.HighestHelpProduct;
import com.highesthelp.framework.acl.Decryptor;
import com.highesthelp.framework.cache.SelectorCache;
import com.highesthelp.framework.common.Node;
import com.highesthelp.framework.common.Page;
import com.highesthelp.framework.common.Selector;
import com.highesthelp.framework.common.Tree;
import com.highesthelp.framework.common.WebContext;
import com.highesthelp.framework.exception.NoRegException;
import com.highesthelp.framework.exception.SessionTimeOutException;
import com.highesthelp.framework.exception.UploadFileException;
import com.highesthelp.framework.upload.FileDownLoad;
import com.highesthelp.framework.upload.FileUpload;
import com.highesthelp.framework.util.FileTools;
import com.highesthelp.framework.util.StringTools;
import com.highesthelp.framework.util.SystemTools;
import com.highesthelp.pdcajob.pojo.Department;
import com.highesthelp.pdcajob.pojo.Operator;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.apache.struts.upload.FormFile;

public class BaseAction
extends DispatchAction {
    public Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    public SelectorCache selectorCache;

    public String saveUploadFile(FormFile upFile, String path) throws UploadFileException {
        if (upFile == null || StringTools.isEmpty(upFile.getFileName())) {
            return "";
        }
        if (StringTools.isEmpty(path)) {
            path = HighestHelpProduct.getDataPath();
        }
        try {
            FileUpload upload = new FileUpload(upFile);
            upload.setFileNameRenderPlot(FileUpload.PLOT_yyyyMMddHHmmss);
            upload.setSavePath(path);
            String retValue = upload.saveFileToServer();
            return retValue.replaceFirst(HighestHelpProduct.getRootPath(), "");
        }
        catch (Exception e) {
            throw new UploadFileException(e.getMessage());
        }
    }

    public String saveUploadFile(FormFile upFile, String path, Integer plot) throws UploadFileException {
        if (upFile == null || StringTools.isEmpty(upFile.getFileName())) {
            return "";
        }
        if (StringTools.isEmpty(path)) {
            path = HighestHelpProduct.getDataPath();
        }
        try {
            FileUpload upload = new FileUpload(upFile);
            upload.setFileNameRenderPlot(plot);
            upload.setSavePath(path);
            String retValue = upload.saveFileToServer();
            return FileTools.removePath(retValue);
        }
        catch (Exception e) {
            throw new UploadFileException(e.getMessage());
        }
    }

    public ActionForward downloadFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String filePath = request.getParameter("filePath");
        if (StringTools.isNotEmpty(filePath)) {
            FileDownLoad download = new FileDownLoad();
            download.DownLoad(response, filePath);
        }
        return null;
    }

    public List addEmptyRows(Object obj, Page page, HttpServletRequest request) {
        List resultList = page.getResult();
        int pageSize = page.getPageSize();
        int totalCount = page.getTotalCount();
        if (totalCount == 0) {
            pageSize = this.getPageSize(request);
        }
        request.setAttribute("real_Total_Count", (Object)new Integer(totalCount));
        request.setAttribute("totalRows", (Object)new Integer(totalCount < pageSize ? pageSize : totalCount));
        if (resultList.size() < pageSize) {
            int emptySize = pageSize - resultList.size();
            int i = 0;
            while (i < emptySize) {
                resultList.add(obj);
                ++i;
            }
        }
        request.setAttribute("ReturnList", (Object)page.getResult());
        return resultList;
    }

    public List addEmptyRows(Object obj, Page page, HttpServletRequest request, boolean addBlankRow) {
        List resultList = page.getResult();
        int pageSize = page.getPageSize();
        int totalCount = page.getTotalCount();
        if (addBlankRow) {
            if (totalCount == 0) {
                pageSize = this.getPageSize(request);
            }
            request.setAttribute("real_Total_Count", (Object)new Integer(totalCount));
            request.setAttribute("totalRows", (Object)new Integer(totalCount < pageSize ? pageSize : totalCount));
            if (resultList.size() < pageSize) {
                int emptySize = pageSize - resultList.size();
                int i = 0;
                while (i < emptySize) {
                    resultList.add(obj);
                    ++i;
                }
            }
        } else {
            request.setAttribute("real_Total_Count", (Object)new Integer(totalCount));
            request.setAttribute("totalRows", (Object)new Integer(totalCount));
        }
        request.setAttribute("ReturnList", (Object)page.getResult());
        return resultList;
    }

    public int getPageSize(HttpServletRequest request) {
        String pageSizeParam = request.getParameter("ec_crd");
        if (StringTools.isEmpty(pageSizeParam)) {
            pageSizeParam = String.valueOf(Page.getDefaultPageSize());
        }
        int nPageSize = Integer.parseInt(pageSizeParam);
        return nPageSize;
    }

    public Operator getLoginUser() throws SessionTimeOutException {
        Operator user = WebContext.getLoginUser();
        return user;
    }

    public String getUrlPara(HttpServletRequest request) {
        StringBuffer sBuffer = new StringBuffer();
        Enumeration enumName = request.getParameterNames();
        while (enumName.hasMoreElements()) {
            String key = enumName.nextElement().toString();
            if (StringTools.equals(key, "act") || StringTools.equals(key, "page")) continue;
            String value = request.getParameter(key);
            sBuffer.append(String.valueOf(key) + "=" + value + "&");
        }
        String relValue = sBuffer.toString();
        if (relValue.endsWith("&")) {
            relValue = relValue.substring(0, relValue.length() - 1);
        }
        System.out.println(relValue);
        return relValue;
    }

    public void setDepartmentTreeInRequest(HttpServletRequest request, List dList, String attributeName) {
        Tree tree = new Tree();
        int i = 0;
        while (i < dList.size()) {
            Department department = (Department)dList.get(i);
            String parentPk = "";
            parentPk = department.getParentPk() == null ? Tree.ROOT_ID : department.getParentPk().toString();
            Node node = new Node(department.getPk().toString(), department.getName(), parentPk);
            tree.addNode(node);
            ++i;
        }
        List<Selector> sList = tree.toSelected();
        request.setAttribute(attributeName, sList);
    }

    public boolean checkRegSystem() throws NoRegException {
        Decryptor decryptor = new Decryptor();
        String key = Decryptor.getKey();
        if (StringTools.isNotEmpty(key)) {
            String dekey = decryptor.restoreKey(key);
            if (dekey == null) {
                throw new NoRegException();
            }
            String initkey = SystemTools.getMAC();
            if (StringTools.equals(dekey, initkey)) {
                return true;
            }
        }
        throw new NoRegException();
    }

    public SelectorCache getSelectorCache() {
        return this.selectorCache;
    }

    public void setSelectorCache(SelectorCache selectorCache) {
        this.selectorCache = selectorCache;
    }
}

