/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.framework.action;

import com.highesthelp.framework.HighestHelpProduct;
import com.highesthelp.framework.action.BaseAction;
import com.highesthelp.framework.cache.SelectorCache;
import com.highesthelp.framework.common.WebContext;
import com.highesthelp.framework.form.ReportForm;
import com.highesthelp.framework.util.ReportTools;
import com.highesthelp.framework.util.StringTools;
import com.highesthelp.pdcajob.pojo.ListValue;
import com.highesthelp.pdcajob.pojo.Operator;
import java.io.ByteArrayOutputStream;
import java.security.InvalidParameterException;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ReportAction
extends BaseAction {
    public ActionForward reportView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReportForm rf = (ReportForm)form;
        HashMap<String, String> params = new HashMap<String, String>();
        Operator user = WebContext.getLoginUser();
        params.put("MAKE_MAN", user.getRealName());
        JRBeanCollectionDataSource jrdata = this.getDataSource(rf);
        JasperPrint jp = ReportTools.getJasperPrint(rf.getReportName(), params, (JRDataSource)jrdata);
        StringBuffer sBuffer = new StringBuffer();
        Enumeration enumName = request.getParameterNames();
        while (enumName.hasMoreElements()) {
            String key = enumName.nextElement().toString();
            if (StringTools.equals(key, "act") || StringTools.equals(key, "page")) continue;
            String value = request.getParameter(key);
            sBuffer.append(String.valueOf(key) + "=" + value + "&");
        }
        String relValue = sBuffer.toString();
        if (relValue.endsWith("&")) {
            relValue = relValue.substring(0, relValue.length() - 1);
        }
        System.out.println(relValue);
        request.setAttribute("queryString", (Object)relValue);
        request.setAttribute("jasperPrint", (Object)jp);
        return mapping.findForward("reportview");
    }

    public ActionForward reportToFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReportForm rf = (ReportForm)form;
        HashMap<String, String> params = new HashMap<String, String>();
        Operator user = WebContext.getLoginUser();
        ListValue lv = SelectorCache.getValueByAliasCode("status_over");
        params.put("MAKE_MAN", user.getRealName());
        JRBeanCollectionDataSource jrdata = this.getDataSource(rf);
        JasperPrint jasperPrint = ReportTools.getJasperPrint(rf.getReportName(), params, (JRDataSource)jrdata);
        try {
            JRPdfExporter exporter;
            String renderType = request.getParameter("renderType");
            String fileName = StringTools.Date2String(new Date(), "yyyyMMddHHmmss");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if ("pdf".equals(renderType)) {
                response.setContentType("application/pdf");
                response.setHeader("Content-Disposition", "attachment; filename=" + fileName + ".pdf");
                exporter = new JRPdfExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_TITLE, (Object)rf.getReportName());
                exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_AUTHOR, (Object)user.getRealName());
                exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_KEYWORDS, (Object)HighestHelpProduct.Copy_right);
                exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_CREATOR, (Object)HighestHelpProduct.Product_name);
                exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_SUBJECT, (Object)HighestHelpProduct.Product_name);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)baos);
                exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)(String.valueOf(fileName) + ".pdf"));
                exporter.exportReport();
            } else if ("csv".equals(renderType)) {
                response.setContentType("application/csv");
                response.setHeader("Content-Disposition", "attachment; filename=" + fileName + ".csv");
                exporter = new JRCsvExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)baos);
                exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)(String.valueOf(fileName) + ".csv"));
                exporter.exportReport();
            } else {
                response.setContentType("application/vnd.ms-excel");
                response.setHeader("Content-Disposition", "attachment; filename=" + fileName + ".xls");
                exporter = new JRXlsExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)baos);
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.TRUE);
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, (Object)Boolean.TRUE);
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
                exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)(String.valueOf(fileName) + ".xls"));
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
                exporter.exportReport();
            }
            byte[] bytes = baos.toByteArray();
            response.setContentLength(bytes.length);
            ServletOutputStream ouputStream = response.getOutputStream();
            ouputStream.write(bytes, 0, bytes.length);
            ouputStream.flush();
            ouputStream.close();
        }
        catch (Exception e) {
            throw new InvalidParameterException("\u62a5\u8868\u751f\u6210\u6587\u4ef6\u65f6\u51fa\u9519\uff1a" + e.getMessage());
        }
        return null;
    }

    public JRBeanCollectionDataSource getDataSource(ReportForm rf) throws Exception {
        Connection conn = this.selectorCache.getBaseDao().getConnection();
        Statement sm = conn.createStatement();
        Object rs = null;
        ArrayList list = new ArrayList();
        JRBeanCollectionDataSource jrdata = new JRBeanCollectionDataSource(list);
        return jrdata;
    }
}

