/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.framework.cache;

import com.highesthelp.framework.cache.SelectorComparator;
import com.highesthelp.framework.dao.BaseDao;
import com.highesthelp.framework.exception.DataAccessException;
import com.highesthelp.pdcajob.pojo.ListClass;
import com.highesthelp.pdcajob.pojo.ListValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorCache {
    private BaseDao baseDao;
    private static List<ListValue> listValues = new ArrayList<ListValue>();
    private static List<ListClass> listClasss = new ArrayList<ListClass>();
    private static SelectorCache sc;

    public static SelectorCache getInstance() {
        if (sc == null) {
            sc = new SelectorCache();
        }
        return sc;
    }

    public List<ListValue> getListValuesByListClassType(String type) throws DataAccessException {
        List<ListValue> returnList = this.getListValuesByListClassType(type, true);
        return returnList;
    }

    public List<ListValue> getListValuesByListClassType(String type, boolean hasDefault) throws DataAccessException {
        if (listClasss.size() == 0 || listValues.size() == 0) {
            this.initListValues();
        }
        Integer pk = null;
        int j = 0;
        while (j < listClasss.size()) {
            ListClass lc = listClasss.get(j);
            if (lc.getName().equals(type)) {
                pk = lc.getPk();
                break;
            }
            ++j;
        }
        ArrayList<ListValue> returnList = new ArrayList<ListValue>();
        if (hasDefault) {
            ListValue defaultLV = new ListValue();
            defaultLV.setPk(0);
            defaultLV.setName("--\u8bf7\u9009\u62e9--");
        }
        if (pk != null) {
            int i = 0;
            while (i < listValues.size()) {
                ListValue lv = listValues.get(i);
                if (lv.getListClass().getPk().equals(pk)) {
                    returnList.add(lv);
                }
                ++i;
            }
        }
        Collections.sort(returnList, new SelectorComparator());
        return returnList;
    }

    public synchronized void initListValues() throws DataAccessException {
        if (listClasss.size() == 0) {
            String hql_ListClass = "from ListClass";
            List lcs = this.baseDao.getObjectsList(hql_ListClass);
            listClasss.addAll(lcs);
        }
        if (listValues.size() == 0) {
            String hql_ListValue = "from ListValue lv where lv.showIt=0";
            List lvs = this.baseDao.getObjectsList(hql_ListValue);
            listValues.addAll(lvs);
        }
    }

    public synchronized void forceReset() throws DataAccessException {
        listClasss.clear();
        listValues.clear();
        this.initListValues();
    }

    public static String getValue(Integer pk) throws DataAccessException {
        int i = 0;
        while (i < listValues.size()) {
            ListValue listValue = listValues.get(i);
            if (listValue.getPk().equals(pk)) {
                return listValue.getName();
            }
            ++i;
        }
        return null;
    }

    public static ListValue getValueByAliasCode(String code) throws DataAccessException {
        int i = 0;
        while (i < listValues.size()) {
            ListValue listValue = listValues.get(i);
            if (code.equals(listValue.getAliasCode())) {
                return listValue;
            }
            ++i;
        }
        return new ListValue();
    }

    public static ListValue getValueByValuePk(Integer pk) throws DataAccessException {
        int i = 0;
        while (i < listValues.size()) {
            ListValue listValue = listValues.get(i);
            if (listValue.getPk().equals(pk)) {
                return listValue;
            }
            ++i;
        }
        return new ListValue();
    }

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }
}

