/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.framework.common;

import com.highesthelp.framework.common.Node;
import com.highesthelp.framework.common.Selector;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tree {
    public static String ROOT_ID = "0";
    private ArrayList<Node> nodeListTemp = new ArrayList();
    private ArrayList<Selector> selectorList = new ArrayList();
    private Node rootNode = new Node();

    public Tree() {
        this.rootNode.setId(ROOT_ID);
        this.rootNode.setName("www.highesthelp.com");
        this.nodeListTemp.add(this.rootNode);
    }

    public void addNode(Node node) {
        String pId = node.getPerantId();
        for (Node n : this.nodeListTemp) {
            if (pId == null || !pId.equals(n.getId())) continue;
            if (n.getChildNodes() == null) {
                n.setChildNodes(new ArrayList<Node>());
            }
            n.getChildNodes().add(node);
        }
        this.nodeListTemp.add(node);
    }

    public String toXMLString() {
        StringBuffer retValue = new StringBuffer("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        retValue.append("<tree id=\"" + this.rootNode.getId() + "\" text=\"" + this.rootNode.getName() + "\">");
        retValue.append(this.viewNode(this.rootNode, true));
        retValue.append("</tree>");
        return retValue.toString();
    }

    private String viewNode(Node rootNode, boolean isOpen) {
        StringBuffer retValue = new StringBuffer("");
        if (rootNode.getChildNodes() != null && rootNode.getChildNodes().size() > 0) {
            for (Node node : rootNode.getChildNodes()) {
                retValue.append("<item id=\"" + node.getId() + "\" text=\"" + node.getName() + "\" " + (isOpen ? "open=\"1\"" : "") + " " + (node.getIco() != null ? "im0=\"" + node.getIco() + "\"" : "") + ">");
                if (node.getChildNodes() != null && node.getChildNodes().size() > 0) {
                    retValue.append(this.viewNode(node, true));
                }
                retValue.append("</item>");
            }
        }
        return retValue.toString();
    }

    private List<Selector> viewSelectNode(Node rootNode, int pos) {
        if (rootNode.getChildNodes() != null && rootNode.getChildNodes().size() > 0) {
            int p = pos + 1;
            for (Node node : rootNode.getChildNodes()) {
                this.selectorList.add(new Selector(Integer.valueOf(node.getId()), String.valueOf(this.calcSpace(pos)) + node.getName()));
                if (node.getChildNodes() == null || node.getChildNodes().size() <= 0) continue;
                this.viewSelectNode(node, p);
            }
        }
        return this.selectorList;
    }

    private String calcSpace(int pos) {
        String sbnp = "-----";
        String retValue = "";
        int i = 0;
        while (i < pos) {
            retValue = String.valueOf(retValue) + sbnp;
            ++i;
        }
        if (pos == 0) {
            return retValue;
        }
        return "|" + retValue;
    }

    public List<Selector> toSelected() {
        return this.viewSelectNode(this.rootNode, 0);
    }

    private String getSubPks(Node rootNode) {
        StringBuffer retValue = new StringBuffer("");
        if (rootNode.getChildNodes() != null && rootNode.getChildNodes().size() > 0) {
            for (Node node : rootNode.getChildNodes()) {
                retValue.append(String.valueOf(node.getId()) + ",");
                if (node.getChildNodes() == null || node.getChildNodes().size() <= 0) continue;
                retValue.append(this.getSubPks(node));
            }
        }
        return retValue.toString();
    }

    public String treeSubPks() {
        String retValue = this.getSubPks(this.rootNode);
        if (retValue.endsWith(",")) {
            return retValue.substring(0, retValue.length() - 1);
        }
        return "";
    }

    public static void main(String[] args) {
        Tree tree = new Tree();
        Node n7 = new Node("7", "\u7f51\u6613", ROOT_ID);
        Node n8 = new Node("8", "movie", "7");
        Node n1 = new Node("11", "\u4e2d\u56fd", "8");
        Node n2 = new Node("12", "\u7f8e\u56fd", "8");
        Node n3 = new Node("13", "\u6b27\u6d32", "8");
        Node n4 = new Node("14", "\u65e5\u672c", "8");
        Node n9 = new Node("9", "new", "7");
        Node n10 = new Node("10", "joke", "7");
        Node n15 = new Node("15", "\u65b0\u6d6a", ROOT_ID);
        Node n16 = new Node("16", "\u751f\u6d3b", "15");
        Node n17 = new Node("17", "\u8d22\u7ecf", "15");
        tree.addNode(n7);
        tree.addNode(n8);
        tree.addNode(n9);
        tree.addNode(n10);
        tree.addNode(n1);
        tree.addNode(n2);
        tree.addNode(n3);
        tree.addNode(n4);
        tree.addNode(n15);
        tree.addNode(n16);
        tree.addNode(n17);
    }
}

