/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.framework.common;

import com.highesthelp.framework.acl.CacheResources;
import com.highesthelp.framework.exception.SessionTimeOutException;
import com.highesthelp.pdcajob.pojo.Operator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebContext {
    Log log = LogFactory.getLog(this.getClass());
    private static final ThreadLocal webContext = new ThreadLocal();
    private HttpServletRequest request;
    private HttpServletResponse response;

    private WebContext() {
    }

    public static void initialize(HttpServletRequest request, HttpServletResponse response) {
        WebContext ctx = WebContext.getWebContext();
        ctx.request = request;
        ctx.response = response;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public static WebContext getWebContext() {
        WebContext ctx = (WebContext)webContext.get();
        if (ctx == null) {
            ctx = new WebContext();
            webContext.set(ctx);
        }
        return ctx;
    }

    public static Operator getLoginUser() throws SessionTimeOutException {
        WebContext ctx = (WebContext)webContext.get();
        HttpServletRequest request = ctx.getRequest();
        Operator user = (Operator)request.getSession().getAttribute("login_user_key");
        if (user == null) {
            throw new SessionTimeOutException();
        }
        return user;
    }

    public static boolean authorized(String key) throws SessionTimeOutException {
        WebContext ctx = (WebContext)webContext.get();
        HttpServletRequest request = ctx.getRequest();
        CacheResources cache = (CacheResources)request.getSession().getAttribute("user_resource_key");
        return cache.authorized(key);
    }
}

