/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.framework.create;

import com.highesthelp.framework.util.StringTools;

public class ColumnInfo {
    public static String STRING_TYPE = "String";
    public static String SHORT_TYPE = "Short";
    public static String DOUBLE_TYPE = "Double";
    public static String FLOAT_TYPE = "Float";
    public static String DATE_TYPE = "Date";
    private String name;
    private String type;
    private int length;
    private boolean notNull = false;

    public ColumnInfo() {
    }

    public ColumnInfo(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public ColumnInfo(String name, String type, int length) {
        this.name = name;
        this.type = type;
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public void setNotNull(boolean notNull) {
        this.notNull = notNull;
    }

    public String renderListJSP() {
        if (this.name.endsWith("Type")) {
            return "\t\t<ec:column property=\"" + this.name + "\" headerCell=\"head\" title=\"" + this.name + "\" styleClass=\"listTd\" >\r\n" + "\t\t\t<cache:value showPk=\"\\${item." + this.name + "}\"/>\r\n" + "\t\t</ec:column>";
        }
        return "\t\t<ec:column property=\"" + this.name + "\" headerCell=\"head\" title=\"" + this.name + "\" styleClass=\"listTd\" />";
    }

    public String renderAddJSP() {
        String tdClass = "rtd";
        String inputClass = "";
        if (this.notNull) {
            tdClass = "tdr";
            inputClass = this.name.endsWith("Type") ? "styleClass=\"select-one-required\"" : (this.type.equals(SHORT_TYPE) || this.type.equals(FLOAT_TYPE) || this.type.equals(DOUBLE_TYPE) ? "styleClass=\"required validate-number\"" : (this.type.equals(DATE_TYPE) ? "styleClass=\"required validate-date-cn\"" : "styleClass=\"required\""));
        }
        if (this.name.endsWith("File")) {
            return "\t\t\t\t<td class=\"ltd\"> " + this.name + "\uff1a</td>\r\n" + "\t\t\t\t<td class=\"" + tdClass + "\">\r\n" + "\t\t\t\t\t<html:file property=\"" + this.name + "\" " + inputClass + "/>\r\n" + "\t\t\t\t</td>\r\n";
        }
        if (this.type.equals(STRING_TYPE) && this.length > 255) {
            return "\t\t\t\t<td class=\"ltd\"> " + this.name + "\uff1a</td>\r\n" + "\t\t\t\t<td class=\"" + tdClass + "\">\r\n" + "\t\t\t\t\t<html:textarea property=\"" + this.name + "\" " + inputClass + " rows=\"6\" cols=\"35\"></html:textarea>\n" + "\t\t\t\t</td>\r\n";
        }
        if (this.name.endsWith("Type")) {
            return "\t\t\t\t<td class=\"ltd\"> " + this.name + "\uff1a</td>\r\n" + "\t\t\t\t<td class=\"" + tdClass + "\">\r\n" + "\t\t\t\t\t<html:select property=\"" + this.name + "\" " + inputClass + ">\r\n" + "\t\t\t\t\t\t<html:options collection=\"" + this.name + "Select\" property=\"pk\" labelProperty=\"name\" />\r\n" + "\t\t\t\t\t</html:select>\r\n" + "\t\t\t\t</td>\r\n";
        }
        return "\t\t\t\t<td class=\"ltd\"> " + this.name + "\uff1a</td>\r\n" + "\t\t\t\t<td class=\"" + tdClass + "\">\r\n" + "\t\t\t\t\t<html:text property=\"" + this.name + "\" " + inputClass + " size=\"18\" />\r\n" + "\t\t\t\t</td>\r\n";
    }

    public String renderViewJSP(String tablename) {
        if (this.name.toLowerCase().endsWith("type")) {
            return "\t\t\t\t<td class=\"ltd\"> " + this.name + "\uff1a</td>\n" + "\t\t\t\t<td class=\"rtd\">\n" + "\t\t\t\t\t<cache:value showPk=\"\\${" + tablename + "." + this.name + "}\"/>\n" + "\t\t\t\t</td>\n";
        }
        return "\t\t\t\t<td class=\"ltd\"> " + this.name + "\uff1a</td>\n" + "\t\t\t\t<td class=\"rtd\">\n" + "\t\t\t\t\t\\${" + tablename + "Pojo." + this.name + "}\n" + "\t\t\t\t</td>\n";
    }

    public String renderPrivate() {
        if (this.name.endsWith("File")) {
            return "\tprivate FormFile " + this.name + ";\n";
        }
        if (this.type.equals("Date")) {
            return "\tprivate String " + this.name + ";\n";
        }
        return "\tprivate " + this.type + " " + this.name + ";\n";
    }

    public String renderSeter() {
        String seterString = "";
        if (this.name.endsWith("File")) {
            seterString = "\tpublic void set" + StringTools.upperFirst(this.name) + "(FormFile " + this.name + ") {\n";
            seterString = String.valueOf(seterString) + "\t\tthis." + this.name + " = " + this.name + ";";
            seterString = String.valueOf(seterString) + "\n\t}\n";
        } else if (this.getType().equals("Date")) {
            seterString = "\tpublic void set" + StringTools.upperFirst(this.name) + "(String " + this.name + ") {\n";
            seterString = String.valueOf(seterString) + "\t\tthis." + this.name + " = " + this.name + ";";
            seterString = String.valueOf(seterString) + "\n\t}\n";
        } else {
            seterString = "\tpublic void set" + StringTools.upperFirst(this.name) + "(" + this.type + " " + this.name + ") {\n";
            seterString = String.valueOf(seterString) + "\t\tthis." + this.name + " = " + this.name + ";";
            seterString = String.valueOf(seterString) + "\n\t}\n";
        }
        return seterString;
    }

    public String renderGeter() {
        String seterString = "";
        if (this.name.endsWith("File")) {
            seterString = "\tpublic FormFile get" + StringTools.upperFirst(this.name) + "() {\n";
            seterString = String.valueOf(seterString) + "\t\treturn this." + this.name + ";";
            seterString = String.valueOf(seterString) + "\n\t}\n";
        } else if (this.getType().equals("Date")) {
            seterString = "\tpublic String get" + StringTools.upperFirst(this.name) + "() {\n";
            seterString = String.valueOf(seterString) + "\t\treturn this." + this.name + ";";
            seterString = String.valueOf(seterString) + "\n\t}\n";
        } else {
            seterString = "\tpublic " + this.getType() + " get" + StringTools.upperFirst(this.name) + "() {\n";
            seterString = String.valueOf(seterString) + "\t\treturn this." + this.name + ";";
            seterString = String.valueOf(seterString) + "\n\t}\n";
        }
        return seterString;
    }
}

