/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.framework.create;

import com.highesthelp.framework.HighestHelpProduct;
import com.highesthelp.framework.create.ColumnInfo;
import com.highesthelp.framework.create.HibernateFileFilter;
import com.highesthelp.framework.create.TableInfo;
import com.highesthelp.framework.util.FileTools;
import com.highesthelp.framework.util.StringTools;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateSystem {
    public static String PRODUCT_NAME = "pdcajob";
    public static String SAVE_PATH = "E:\\workspace\\" + PRODUCT_NAME + "\\";
    public static String ACTION_SUFFIX = "act";
    public static String HIBERNATE_XML_PATH = String.valueOf(SAVE_PATH) + "src\\com\\highesthelp\\" + PRODUCT_NAME + "\\pojo";
    public static String TEMPLETE_ADDRESS = String.valueOf(SAVE_PATH) + "templete\\";
    public static String CONFIG_ADDRESS_PATH = String.valueOf(SAVE_PATH) + "WebRoot\\WEB-INF\\";
    public static String FILE_JSP_TEMPLETE_LIST = String.valueOf(TEMPLETE_ADDRESS) + "jsp\\List.jsp";
    public static String FILE_JSP_TEMPLETE_ADD = String.valueOf(TEMPLETE_ADDRESS) + "jsp\\Add.jsp";
    public static String FILE_JSP_TEMPLETE_EIDT = String.valueOf(TEMPLETE_ADDRESS) + "jsp\\Edit.jsp";
    public static String FILE_JSP_TEMPLETE_SEARCH = String.valueOf(TEMPLETE_ADDRESS) + "jsp\\Search.jsp";
    public static String FILE_JSP_TEMPLETE_VIEW = String.valueOf(TEMPLETE_ADDRESS) + "jsp\\View.jsp";
    public static String FILE_SERVICE_TEMPLETE = String.valueOf(TEMPLETE_ADDRESS) + "service\\Service.java";
    public static String FILE_FORM_TEMPLETE = String.valueOf(TEMPLETE_ADDRESS) + "form\\Form.java";
    public static String FILE_ACTION_TEMPLETE = String.valueOf(TEMPLETE_ADDRESS) + "action\\Action.java";
    public static String STRUTS_CONFIG_TEMPLETE_ADDRESS = String.valueOf(TEMPLETE_ADDRESS) + "xml\\struts-config.xml";
    public static String STRUTS_CONFIG_FILE_ADDRESS = String.valueOf(CONFIG_ADDRESS_PATH) + "struts-config.xml";
    public static String SPRING_TEMPLETE_ADDRESS = String.valueOf(TEMPLETE_ADDRESS) + "xml\\spring-beans.xml";
    public static String SPRING_TEMPLETE_ACTION_ADDRESS = String.valueOf(TEMPLETE_ADDRESS) + "xml\\spring-servlet.xml";
    public static String SPRING_CONFIG_FILE_ADDRESS = String.valueOf(CONFIG_ADDRESS_PATH) + "spring-beans.xml";
    public static String SPRING_CONFIG_FILE_ACTION_ADDRESS = String.valueOf(CONFIG_ADDRESS_PATH) + "spring-servlet.xml";

    public File[] getHibernateFiles(String path) {
        File folder = new File(path);
        File[] retArray = null;
        if (!folder.isFile()) {
            retArray = folder.listFiles(new HibernateFileFilter());
        }
        System.out.println("\u603b\u6587\u4ef6\u6570 \uff1a" + retArray.length);
        int a = 0;
        File[] fileArray = retArray;
        int n = retArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            System.out.println(String.valueOf(++a) + ":" + f.getAbsolutePath());
            ++n2;
        }
        return retArray;
    }

    public List<TableInfo> AnalysisFileToTableInfos(File[] files) {
        String JSPPATH = HighestHelpProduct.getPagesPath();
        System.out.println("Product.getPagesPath() =  " + JSPPATH);
        ArrayList<TableInfo> retArray = new ArrayList<TableInfo>();
        int a = 0;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            System.out.println(String.valueOf(++a) + ": \u5f00\u59cb\u5206\u6790\u6587\u4ef6 " + file.getAbsolutePath());
            try {
                String shortName;
                TableInfo table = new TableInfo();
                SAXReader saxReader = new SAXReader();
                Document document = saxReader.read(file);
                Element classElement = document.getRootElement().element("class");
                String tName = classElement.attribute("name").getValue();
                String[] pa = tName.split("\\.");
                if ("pojo".equals(pa[pa.length - 1])) {
                    table.setPrefixTable(String.valueOf(pa[pa.length - 1]) + ".");
                } else {
                    table.setPrefixTable("");
                }
                String tableName = shortName = tName.substring(tName.lastIndexOf(".") + 1);
                table.setTableName(tableName);
                System.out.println("\u5b9e\u4f53\u540d\u79f0 : " + table.getTableName());
                Element IdElement = classElement.element("id");
                ColumnInfo keyColumn = new ColumnInfo();
                String keyName = IdElement.attribute("name").getValue();
                String keyType = IdElement.attribute("type").getValue();
                keyColumn.setName(keyName);
                keyColumn.setType(keyType.substring(keyType.lastIndexOf(".") + 1));
                table.setKey(keyColumn);
                System.out.println("\u4e3b\u952e\u540d\u79f0 : " + table.getKey().getName() + " \u6570\u636e\u7c7b\u578b :" + table.getKey().getType());
                List propertys = classElement.elements("property");
                ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
                for (Element e : propertys) {
                    ColumnInfo ci = new ColumnInfo();
                    String cName = e.attribute("name").getValue();
                    String cType = e.attribute("type").getValue();
                    ci.setName(cName);
                    ci.setType(cType.substring(cType.lastIndexOf(".") + 1));
                    Element columnElement = e.element("column");
                    if (ci.getType().equals("String") && columnElement.attribute("length") != null) {
                        ci.setLength(Integer.valueOf(columnElement.attribute("length").getValue()));
                    }
                    if (columnElement.attribute("not-null") != null) {
                        ci.setNotNull(true);
                    }
                    System.out.println("\u5c5e\u6027\u540d\u79f0 : " + ci.getName() + " \u6570\u636e\u7c7b\u578b :" + ci.getType() + " \u6570\u636e\u957f\u5ea6\uff1a" + ci.getLength());
                    columns.add(ci);
                }
                table.setColumns(columns);
                String pre = "";
                if (!StringTools.isEmpty(table.getPrefixTable())) {
                    pre = StringTools.upperFirst(table.getPrefixTable().replace('.', '/'));
                }
                FileTools.writeFile(table.rendListJSP(), String.valueOf(JSPPATH) + "/" + pre + StringTools.lowerFirst(table.getTableName()) + "/list.jsp");
                System.out.println("\u751f\u6210\u7684\u5217\u8868\u9875\u9762: " + JSPPATH + "/" + pre + StringTools.lowerFirst(table.getTableName()) + "/list.jsp");
                FileTools.writeFile(table.renderAddJSP(), String.valueOf(JSPPATH) + "/" + pre + StringTools.lowerFirst(table.getTableName()) + "/add.jsp");
                System.out.println("\u751f\u6210\u7684\u65b0\u589e\u9875\u9762: " + JSPPATH + "/" + pre + StringTools.lowerFirst(table.getTableName()) + "/add.jsp");
                FileTools.writeFile(table.renderEditJSP(), String.valueOf(JSPPATH) + "/" + pre + StringTools.lowerFirst(table.getTableName()) + "/edit.jsp");
                System.out.println("\u751f\u6210\u7684\u7f16\u8f91\u9875\u9762: " + JSPPATH + "/" + pre + StringTools.lowerFirst(table.getTableName()) + "/edit.jsp");
                FileTools.writeFile(table.renderViewJSP(), String.valueOf(JSPPATH) + "/" + pre + StringTools.lowerFirst(table.getTableName()) + "/view.jsp");
                System.out.println("\u751f\u6210\u7684\u67e5\u770b\u9875\u9762: " + JSPPATH + "/" + pre + StringTools.lowerFirst(table.getTableName()) + "/view.jsp");
                String formFile = HighestHelpProduct.getUpRootPath("../src/com/highesthelp/" + PRODUCT_NAME + "/form/" + table.getTableName() + "Form.java");
                String content = table.renderForm();
                FileTools.writeFile(content, formFile);
                System.out.println("\u751f\u6210Form\u6587\u4ef6: " + formFile);
                String servicePath = HighestHelpProduct.getUpRootPath("../src/com/highesthelp/" + PRODUCT_NAME + "/service");
                FileTools.writeFile(table.renderServiceImplByTemplete(), String.valueOf(servicePath) + "/" + table.getTableName() + "Service.java");
                System.out.println("\u751f\u6210Service: " + servicePath + "/" + table.getTableName() + "Service.java");
                String actionPath = HighestHelpProduct.getUpRootPath("../src/com/highesthelp/" + PRODUCT_NAME + "/action");
                FileTools.writeFile(table.renderActionByTemplete(), String.valueOf(actionPath) + "/" + table.getTableName() + "Action.java");
                System.out.println("\u751f\u6210Action: " + actionPath + "/" + table.getTableName() + "Action.java");
                retArray.add(table);
            }
            catch (Exception e) {
                System.out.println("\u9519\u8bef\uff1a" + e);
            }
            ++n2;
        }
        return retArray;
    }

    public static void editSpringConfigFile(List<TableInfo> tables) {
        try {
            System.out.println("\u5f00\u59cb\u4fee\u6539Spring \u914d\u7f6e \u6587\u4ef6\uff01..................");
            File springConfigFile = new File(SPRING_CONFIG_FILE_ADDRESS);
            SAXReader saxReader = new SAXReader();
            Document document = saxReader.read(springConfigFile);
            System.out.println("\u83b7\u53d6\u8ddf\u5143\u7d20...");
            Element root = document.getRootElement();
            System.out.println("\u5f00\u59cb\u751f\u6210Service\u5c42\u5143\u7d20..........");
            for (TableInfo ti : tables) {
                Element bean = root.addElement("bean");
                bean.addAttribute("id", String.valueOf(StringTools.lowerFirst(ti.getTableName())) + "Service");
                bean.addAttribute("class", "com.highesthelp." + PRODUCT_NAME + ".service." + ti.getTableName() + "Service");
                System.out.println("\u751f\u6210\u5143\u7d20 service bean , id = " + StringTools.lowerFirst(ti.getTableName()));
                Element property = bean.addElement("property");
                property.addAttribute("name", "baseDao");
                Element ref = property.addElement("ref");
                ref.addAttribute("local", "baseDao");
            }
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            XMLWriter output = new XMLWriter((Writer)new FileWriter(new File(SPRING_CONFIG_FILE_ADDRESS)), format);
            System.out.println("\u8f93\u51fa\u5230\u6587\u4ef6:" + SPRING_CONFIG_FILE_ADDRESS);
            output.write(document);
            output.close();
            File springActionConfigFile = new File(SPRING_CONFIG_FILE_ACTION_ADDRESS);
            SAXReader saxReaderAction = new SAXReader();
            Document documentAction = saxReaderAction.read(springActionConfigFile);
            Element rootAction = documentAction.getRootElement();
            System.out.println("\u5f00\u59cb\u751f\u6210 Action \u5c42\u5143\u7d20..........");
            for (TableInfo ti : tables) {
                Element bean = rootAction.addElement("bean");
                bean.addAttribute("name", "/" + StringTools.lowerFirst(ti.getTableName()));
                bean.addAttribute("class", "com.highesthelp." + PRODUCT_NAME + ".action." + ti.getTableName() + "Action");
                Element property = bean.addElement("property");
                property.addAttribute("name", String.valueOf(StringTools.lowerFirst(ti.getTableName())) + "Service");
                Element ref = property.addElement("ref");
                ref.addAttribute("bean", String.valueOf(StringTools.lowerFirst(ti.getTableName())) + "Service");
                Element propertyCache = bean.addElement("property");
                propertyCache.addAttribute("name", "selectorCache");
                Element refCache = propertyCache.addElement("ref");
                refCache.addAttribute("bean", "selectorCache");
                System.out.println("\u751f\u6210\u5143\u7d20 action bean , name = /" + StringTools.lowerFirst(ti.getTableName()));
            }
            XMLWriter outputAction = new XMLWriter((Writer)new FileWriter(new File(SPRING_CONFIG_FILE_ACTION_ADDRESS)), format);
            System.out.println("\u8f93\u51fa\u5230\u6587\u4ef6:" + SPRING_CONFIG_FILE_ACTION_ADDRESS);
            outputAction.write(documentAction);
            outputAction.close();
            System.out.println("\u4fee\u6539Spring \u914d\u7f6e \u6587\u4ef6\uff01\u6210\u529f..............................");
        }
        catch (Exception ex) {
            System.out.println("\u4fee\u6539Spring \u914d\u7f6e\u6587\u4ef6\u9519\u8bef\uff0c\u9519\u8bef\u63cf\u8ff0" + ex.getMessage());
        }
    }

    public static void editStrutsConfigFile(List<TableInfo> tables) {
        try {
            System.out.println("\u5f00\u59cb\u4fee\u6539Struts Config \u6587\u4ef6\uff01.........................");
            File strutsConfigFile = new File(STRUTS_CONFIG_FILE_ADDRESS);
            SAXReader saxReader = new SAXReader();
            Document document = saxReader.read(strutsConfigFile);
            Element beans = document.getRootElement().element("form-beans");
            Element maps = document.getRootElement().element("action-mappings");
            for (TableInfo ti : tables) {
                Element bean = beans.addElement("form-bean");
                bean.addAttribute("name", StringTools.lowerFirst(ti.getTableName()));
                bean.addAttribute("type", "com.highesthelp." + PRODUCT_NAME + ".form." + ti.getPrefixTable() + ti.getTableName() + "Form");
                System.out.println("\u751f\u6210\u5143\u7d20 form-bean , name = " + StringTools.lowerFirst(ti.getTableName()));
                Element map = maps.addElement("action");
                map.addAttribute("path", "/" + StringTools.lowerFirst(ti.getTableName()));
                map.addAttribute("scope", "request");
                map.addAttribute("validate", "false");
                map.addAttribute("parameter", ACTION_SUFFIX);
                map.addAttribute("name", StringTools.lowerFirst(ti.getTableName()));
                String pre = "";
                if (!StringTools.isEmpty(ti.getPrefixTable())) {
                    pre = StringTools.upperFirst(ti.getPrefixTable().replace('.', '/'));
                }
                System.out.println("pre = =========" + pre);
                map.addAttribute("input", "/pages/" + pre + StringTools.lowerFirst(ti.getTableName()) + "/list.jsp");
                Element listForward = map.addElement("forward");
                listForward.addAttribute("name", String.valueOf(StringTools.lowerFirst(ti.getTableName())) + "List");
                listForward.addAttribute("path", "/pages/" + pre + StringTools.lowerFirst(ti.getTableName()) + "/list.jsp");
                System.out.println("\u751f\u6210listforward\u5143\u7d20/pages/" + pre + StringTools.lowerFirst(ti.getTableName()) + "/list.jsp");
                Element addForward = map.addElement("forward");
                addForward.addAttribute("name", String.valueOf(StringTools.lowerFirst(ti.getTableName())) + "Add");
                addForward.addAttribute("path", "/pages/" + pre + StringTools.lowerFirst(ti.getTableName()) + "/add.jsp");
                System.out.println("\u751f\u6210addforward\u5143\u7d20/pages/" + pre + StringTools.lowerFirst(ti.getTableName()) + "/add.jsp");
                Element editForward = map.addElement("forward");
                editForward.addAttribute("name", String.valueOf(StringTools.lowerFirst(ti.getTableName())) + "Modify");
                editForward.addAttribute("path", "/pages/" + pre + StringTools.lowerFirst(ti.getTableName()) + "/edit.jsp");
                System.out.println("\u751f\u6210editforward\u5143\u7d20/pages/" + pre + StringTools.lowerFirst(ti.getTableName()) + "/edit.jsp");
                Element viewForward = map.addElement("forward");
                viewForward.addAttribute("name", String.valueOf(StringTools.lowerFirst(ti.getTableName())) + "View");
                viewForward.addAttribute("path", "/pages/" + pre + StringTools.lowerFirst(ti.getTableName()) + "/view.jsp");
                System.out.println("\u751f\u6210viewforward\u5143\u7d20/pages/" + pre + StringTools.lowerFirst(ti.getTableName()) + "/view.jsp");
                Element listActionForward = map.addElement("forward");
                listActionForward.addAttribute("name", String.valueOf(StringTools.lowerFirst(ti.getTableName())) + "ListAction");
                listActionForward.addAttribute("path", "/" + StringTools.lowerFirst(ti.getTableName()) + ".do?" + ACTION_SUFFIX + "=list" + ti.getTableName());
                listActionForward.addAttribute("redirect", "true");
                System.out.println("\u751f\u6210viewforward\u5143\u7d20/" + StringTools.lowerFirst(ti.getTableName()) + ".do?" + ACTION_SUFFIX + "=list" + ti.getTableName());
                System.out.println("\u751f\u6210\u5143\u7d20 action , path = /" + StringTools.lowerFirst(ti.getTableName()));
            }
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            XMLWriter output = new XMLWriter((Writer)new FileWriter(new File(STRUTS_CONFIG_FILE_ADDRESS)), format);
            output.write(document);
            System.out.println("\u8f93\u51fa\u5230\u6587\u4ef6:" + STRUTS_CONFIG_FILE_ADDRESS);
            output.close();
            System.out.println("\u4fee\u6539Struts Config \u6587\u4ef6\uff01\u6210\u529f..............................");
        }
        catch (Exception ex) {
            System.out.println("\u4fee\u6539Struts-config.xml\u6587\u4ef6\u9519\u8bef\uff0c\u9519\u8bef\u63cf\u8ff0" + ex.getMessage());
        }
    }

    public static void createResourceSql(List<TableInfo> tables) {
        String resource = "";
        try {
            for (TableInfo ti : tables) {
                String tableName = ti.getTableName();
                resource = String.valueOf(resource) + "insert into resource_class(pk,name) values('" + tableName + "','" + tableName + "');\n";
                resource = String.valueOf(resource) + "insert into resource(name,description,resource_class) values('add_" + StringTools.lowerFirst(tableName) + "','\u65b0\u589e','" + tableName + "');\n";
                resource = String.valueOf(resource) + "insert into resource(name,description,resource_class) values('edit_" + StringTools.lowerFirst(tableName) + "','\u7f16\u8f91','" + tableName + "');\n";
                resource = String.valueOf(resource) + "insert into resource(name,description,resource_class) values('del_" + StringTools.lowerFirst(tableName) + "','\u5220\u9664','" + tableName + "');\n";
                resource = String.valueOf(resource) + "insert into resource(name,description,resource_class) values('view_" + StringTools.lowerFirst(tableName) + "','\u67e5\u770b','" + tableName + "');\n";
                resource = String.valueOf(resource) + "insert into resource(name,description,resource_class) values('list_" + StringTools.lowerFirst(tableName) + "','\u5217\u8868','" + tableName + "');\n";
            }
            System.out.println("\u751f\u6210\u6743\u9650\u8d44\u6e90\uff1a\n" + resource);
            FileTools.writeFile(resource, String.valueOf(HighestHelpProduct.getSQLPath()) + "init_resource.sql");
        }
        catch (Exception e) {
            System.out.println("\u751f\u6210\u6743\u9650\u8d44\u6e90SQL\u6587\u4ef6\u9519\u8bef\uff0c\u9519\u8bef\u63cf\u8ff0" + e.getMessage());
        }
    }

    public static void main(String[] args) {
        CreateSystem cs = new CreateSystem();
        File[] files = cs.getHibernateFiles(HIBERNATE_XML_PATH);
        List<TableInfo> tables = cs.AnalysisFileToTableInfos(files);
        CreateSystem.editSpringConfigFile(tables);
        CreateSystem.editStrutsConfigFile(tables);
        CreateSystem.createResourceSql(tables);
    }
}

