/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.framework.dao;

import com.highesthelp.framework.common.Page;
import com.highesthelp.framework.exception.DataAccessException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.classic.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class BaseDao
extends HibernateDaoSupport {
    public Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public Object getObjectByPk(Class cls, Short pk) throws DataAccessException {
        try {
            this.log.info((Object)("get " + cls.getName() + " from database,it's pk is " + pk));
            Object obj = this.getHibernateTemplate().get(cls, (Serializable)pk);
            return obj;
        }
        catch (Exception e) {
            this.log.error((Object)("Failture: error getObjectByPk from database ,it's pk is :" + pk + " exception info: " + e));
            throw new DataAccessException();
        }
    }

    public Object getObjectByPk(Class cls, String pk) throws DataAccessException {
        try {
            this.log.info((Object)("get " + cls.getName() + " from database,it's pk is " + pk));
            Object obj = this.getHibernateTemplate().get(cls, (Serializable)((Object)pk));
            return obj;
        }
        catch (Exception e) {
            this.log.error((Object)("Failture: error getObjectByPk from database ,it's pk is :" + pk + " exception info: " + e));
            throw new DataAccessException();
        }
    }

    public Object getObjectByPk(Class cls, Long pk) throws DataAccessException {
        try {
            this.log.info((Object)("get " + cls.getName() + " from database,it's pk is " + pk));
            Object obj = this.getHibernateTemplate().get(cls, (Serializable)pk);
            return obj;
        }
        catch (Exception e) {
            this.log.error((Object)("Failture: error getObjectByPk from database ,it's pk is :" + pk + " exception info: " + e));
            throw new DataAccessException();
        }
    }

    public Object getObjectByPk(Class cls, Float pk) throws DataAccessException {
        try {
            this.log.info((Object)("get " + cls.getName() + " from database,it's pk is " + pk));
            Object obj = this.getHibernateTemplate().get(cls, (Serializable)pk);
            return obj;
        }
        catch (Exception e) {
            this.log.error((Object)("Failture: error getObjectByPk from database ,it's pk is :" + pk + " exception info: " + e));
            throw new DataAccessException();
        }
    }

    public Object getObjectByPk(Class cls, Double pk) throws DataAccessException {
        try {
            this.log.info((Object)("get " + cls.getName() + " from database,it's pk is " + pk));
            Object obj = this.getHibernateTemplate().get(cls, (Serializable)pk);
            return obj;
        }
        catch (Exception e) {
            this.log.error((Object)("Failture: error getObjectByPk from database ,it's pk is :" + pk + " exception info: " + e));
            throw new DataAccessException();
        }
    }

    public Object getObjectByPk(Class cls, Integer pk) throws DataAccessException {
        try {
            this.log.info((Object)("get " + cls.getName() + " from database,it's pk is " + pk));
            Object obj = this.getHibernateTemplate().get(cls, (Serializable)pk);
            return obj;
        }
        catch (Exception e) {
            this.log.error((Object)("Failture: error getObjectByPk from database ,it's pk is :" + pk + " exception info: " + e));
            throw new DataAccessException();
        }
    }

    public Object getObjectByPk(Object obj, Serializable pk) throws DataAccessException {
        try {
            this.log.info((Object)("get " + obj.getClass().getName() + " from database,it's pk is " + pk.toString()));
            Object o = this.getHibernateTemplate().get(obj.getClass(), pk);
            return o;
        }
        catch (Exception e) {
            this.log.error((Object)("Failture: error getObjectByPk from database ,it's pk is :" + pk + " exception info: " + e));
            throw new DataAccessException();
        }
    }

    public List getObjectsList(String hql) throws DataAccessException {
        try {
            this.log.info((Object)("get list from database,it's hql is :" + hql));
            List list = new ArrayList();
            list = this.getHibernateTemplate().find(hql);
            return list;
        }
        catch (Exception e) {
            this.log.error((Object)("Failture: error getObjectsList from database ,it's hql is :" + hql + " exception info: " + e));
            throw new DataAccessException();
        }
    }

    public Object getObject(String hql) throws DataAccessException {
        try {
            this.log.info((Object)("get Object from database,it's hql is :" + hql));
            List list = new ArrayList();
            list = this.getHibernateTemplate().find(hql);
            if (list != null && list.size() > 0) {
                return list.get(0);
            }
            return null;
        }
        catch (Exception e) {
            this.log.error((Object)("Failture: error getObjectsList from database ,it's hql is :" + hql + " exception info: " + e));
            throw new DataAccessException();
        }
    }

    public List getObjectsList(String hql, Object[] obj) throws DataAccessException {
        try {
            this.log.info((Object)("get list from database,it's hql is :" + hql));
            List list = new ArrayList();
            list = this.getHibernateTemplate().find(hql, obj);
            return list;
        }
        catch (Exception e) {
            this.log.error((Object)("Failture: error getObjectsList from database ,it's hql is :" + hql + " and parameter is" + obj.toString() + " exception info: " + e));
            throw new DataAccessException();
        }
    }

    public List getObjectsListPage(final String hql, final int startIndex, final int pageSize) throws DataAccessException {
        try {
            List list = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                    try {
                        Query query = session.createQuery(hql);
                        query.setFirstResult(startIndex);
                        query.setMaxResults(pageSize);
                        List innerlist = query.list();
                        BaseDao.this.log.info((Object)("get list from database it's hql is :" + hql + ", startIndex = " + startIndex + " pageSize = " + pageSize));
                        return innerlist;
                    }
                    catch (Exception e) {
                        BaseDao.this.log.error((Object)("failture: get list from database,it's hql is :" + hql + ", startIndex = " + startIndex + " pageSize = " + pageSize), (Throwable)e);
                        throw new SQLException();
                    }
                }
            });
            return list;
        }
        catch (Exception e) {
            this.log.error((Object)("Failture: error getObjectsListPage from database ,it's hql is :" + hql + " exception info: " + e));
            throw new DataAccessException();
        }
    }

    public Page getBaseDaoPage(String hql, int startIndex, int pageSize) throws DataAccessException {
        try {
            StringBuffer bufferString = new StringBuffer("select count(*) ");
            String tempStr = hql.toLowerCase();
            int fromIndex = tempStr.indexOf("from ");
            int orderIndex = tempStr.indexOf(" order ");
            int limitIndex = tempStr.indexOf(" limit ");
            if (orderIndex > 0) {
                bufferString.append(hql.substring(fromIndex, orderIndex));
            } else if (limitIndex <= 0) {
                bufferString.append(hql.substring(fromIndex));
            } else {
                bufferString.append(hql.substring(fromIndex, limitIndex));
            }
            Page page = new Page(startIndex, pageSize);
            List list = this.getObjectsListPage(hql, startIndex, pageSize);
            page.setResult(list);
            int totalCount = this.getHQLCount(bufferString.toString());
            page.setTotalCount(totalCount);
            return page;
        }
        catch (Exception e) {
            this.log.error((Object)("Failture: error getBaseDaoPage from database ,it's hql is :" + hql + " exception info: " + e));
            throw new DataAccessException(e.getMessage());
        }
    }

    public Object saveObject(Object obj) throws DataAccessException {
        try {
            this.log.info((Object)("save object to database,it's name is :" + obj.getClass().getName()));
            this.getHibernateTemplate().save(obj);
            return null;
        }
        catch (Exception e) {
            this.log.error((Object)("Failture: error saveObject to database ,it is :" + obj.toString() + " exception info: " + e));
            throw new DataAccessException(e.getMessage());
        }
    }

    public void saveObjectsList(List list) throws DataAccessException {
        try {
            this.log.info((Object)"save object (List) to database");
            this.getHibernateTemplate().saveOrUpdateAll((Collection)list);
        }
        catch (Exception e) {
            this.log.error((Object)("Failture: error saveObject to database ,it is :" + list.toString() + " exception info: " + e));
            throw new DataAccessException(e.getMessage());
        }
    }

    public void deleteObject(Object obj) throws DataAccessException {
        try {
            this.log.info((Object)("delete object from database,it's name is :" + obj.getClass().getName()));
            this.getHibernateTemplate().delete(obj);
        }
        catch (Exception e) {
            this.log.error((Object)("Failture: error deleteObject from database,it's name is :" + obj.getClass().getName() + " exception info: " + e));
            throw new DataAccessException(e.getMessage());
        }
    }

    public int excuteHQL(String hql) throws DataAccessException {
        try {
            Session session = this.getHibernateTemplate().getSessionFactory().openSession();
            int effect = 0;
            try {
                try {
                    Query query = session.createQuery(hql);
                    effect = query.executeUpdate();
                    this.log.info((Object)("execute effect result = " + effect + " hql =" + hql));
                }
                catch (Exception e) {
                    this.log.error((Object)("Failture: error delete/update to database ,it's hql is :" + hql));
                    throw new DataAccessException(e.getMessage());
                }
            }
            finally {
                session.close();
            }
            return effect;
        }
        catch (Exception e) {
            this.log.error((Object)("Failture: error deleteObject from database,it's hql is :" + hql + " exception info: " + e));
            throw new DataAccessException(e.getMessage());
        }
    }

    public Object updateObject(Object obj) throws DataAccessException {
        try {
            this.log.info((Object)("update Object to database , it's name is :" + obj.getClass().getName()));
            this.getHibernateTemplate().update(obj);
            return obj;
        }
        catch (Exception e) {
            this.log.error((Object)("Failture: error updateObject to database,it's obj is :" + obj.toString() + " exception info: " + e));
            throw new DataAccessException(e.getMessage());
        }
    }

    public void updateObjectsList(List list) throws DataAccessException {
        try {
            this.log.info((Object)"update Object (list) to database");
            this.getHibernateTemplate().saveOrUpdateAll((Collection)list);
        }
        catch (Exception e) {
            this.log.error((Object)("Failture: error updateObjectsList to database,it's obj is :" + list.toString() + " exception info: " + e));
            throw new DataAccessException(e.getMessage());
        }
    }

    public int getHQLCount(String hql) throws DataAccessException {
        int count = 0;
        try {
            List list = this.getHibernateTemplate().find(hql);
            Object obj = list.get(0);
            count = Integer.valueOf(obj.toString());
        }
        catch (Exception e) {
            this.log.error((Object)("Failture: error get HQL Count from database ,it's hql is :" + hql + " exception info: " + e));
            throw new DataAccessException(e.getMessage());
        }
        return count;
    }

    public org.hibernate.Session getHibernateSession() {
        return this.getSession();
    }

    public Connection getConnection() {
        Connection conn = this.getSession().connection();
        return conn;
    }
}

