/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.framework.email;

import com.highesthelp.framework.email.PopupAuthenticator;
import com.highesthelp.framework.util.EncodingTools;
import com.highesthelp.framework.util.FileTools;
import com.highesthelp.framework.util.StringTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailSender {
    private static final String PROP_SMTP = "smtp";
    private static final String PROP_HOST = "mail.smtp.host";
    private static final String PROP_AUTH = "mail.smtp.auth";
    private String emailEncoding = "GB18030";
    private boolean needHtml = true;
    private String smtpServer = "smtp.163.com";
    private boolean needAuth = true;
    private String fromEmail = "";
    private String emailUserName = "";
    private String emailUserPassword = "";
    private String toEmailAddress = "";
    private String ccEailAddress = "";
    private String subject = " \uff01";
    private String body = "";
    private Collection<String> attachCollection = new ArrayList<String>();

    public static void main(String[] args) {
        EmailSender sender = new EmailSender();
        try {
            ArrayList<String> list = new ArrayList<String>();
            list.add("E:\\\u65b0\u5efa\u6587\u4ef6\u5939\\show\\IMG0206A.jpg");
            list.add("E:\\\u65b0\u5efa\u6587\u4ef6\u5939\\show\\\u65b0\u5efa \u6587\u672c\u6587\u6863.txt");
            sender.setAttachCollection(list);
            String content = FileTools.file2String("E:\\MyHtml.html");
            sender.setBody(content);
            sender.send();
            System.out.println("ok.............................");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public EmailSender() {
    }

    public EmailSender(String emailEncoding, boolean needHtml, String smtpServer, boolean needAuth, String fromEmail, String emailUserName, String emailUserPassword, String toEmailAddress, String subject, String body, Collection<String> attachCollection) {
        this.emailEncoding = emailEncoding;
        this.needHtml = needHtml;
        this.smtpServer = smtpServer;
        this.needAuth = needAuth;
        this.fromEmail = fromEmail;
        this.emailUserName = emailUserName;
        this.emailUserPassword = emailUserPassword;
        this.toEmailAddress = toEmailAddress;
        this.subject = subject;
        this.body = body;
        this.attachCollection = attachCollection;
    }

    public void send() throws Exception {
        Properties props = System.getProperties();
        props.put(PROP_HOST, this.smtpServer);
        if (this.needAuth) {
            props.put(PROP_AUTH, "true");
        } else {
            props.put(PROP_AUTH, "false");
        }
        PopupAuthenticator popupAuthenticator = new PopupAuthenticator(this.emailUserName, this.emailUserPassword);
        Session session = null;
        session = !this.needAuth ? Session.getDefaultInstance((Properties)props) : Session.getDefaultInstance((Properties)props, (Authenticator)popupAuthenticator);
        MimeMessage message = new MimeMessage(session);
        message.setSentDate(new Date());
        message.setFrom((Address)new InternetAddress(this.fromEmail));
        message.setSubject(this.subject, this.emailEncoding);
        message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.toEmailAddress));
        if (StringTools.isNotEmpty(this.getCcEailAddress())) {
            message.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)this.getCcEailAddress()));
        }
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart bodyPart = new MimeBodyPart();
        if (this.needHtml) {
            bodyPart.setContent((Object)EncodingTools.toEncoding(this.body, this.emailEncoding), "text/html;charset=" + this.emailEncoding);
        } else {
            bodyPart.setText(EncodingTools.toEncoding(this.body, this.emailEncoding));
        }
        multipart.addBodyPart((BodyPart)bodyPart);
        if (this.attachCollection != null) {
            Iterator<String> iterator = this.attachCollection.iterator();
            while (iterator.hasNext()) {
                MimeBodyPart mbpFile = new MimeBodyPart();
                String filename = iterator.next().toString();
                FileDataSource fds = new FileDataSource(filename);
                mbpFile.setDataHandler(new DataHandler((DataSource)fds));
                mbpFile.setFileName(MimeUtility.encodeText((String)fds.getName()));
                multipart.addBodyPart((BodyPart)mbpFile);
            }
        }
        message.setContent((Multipart)multipart);
        Transport transport = session.getTransport(PROP_SMTP);
        Transport.send((Message)message);
        transport.close();
    }

    public String getEmailEncoding() {
        return this.emailEncoding;
    }

    public boolean isNeedHtml() {
        return this.needHtml;
    }

    public String getSmtpServer() {
        return this.smtpServer;
    }

    public boolean isNeedAuth() {
        return this.needAuth;
    }

    public String getFromEmail() {
        return this.fromEmail;
    }

    public String getEmailUserName() {
        return this.emailUserName;
    }

    public String getEmailUserPassword() {
        return this.emailUserPassword;
    }

    public String getToEmailAddress() {
        return this.toEmailAddress;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBody() {
        return this.body;
    }

    public Collection<String> getAttachCollection() {
        return this.attachCollection;
    }

    public void setEmailEncoding(String emailEncoding) {
        this.emailEncoding = emailEncoding;
    }

    public void setNeedHtml(boolean needHtml) {
        this.needHtml = needHtml;
    }

    public void setSmtpServer(String smtpServer) {
        this.smtpServer = smtpServer;
    }

    public void setNeedAuth(boolean needAuth) {
        this.needAuth = needAuth;
    }

    public void setFromEmail(String fromEmail) {
        this.fromEmail = fromEmail;
    }

    public void setEmailUserName(String emailUserName) {
        this.emailUserName = emailUserName;
    }

    public void setEmailUserPassword(String emailUserPassword) {
        this.emailUserPassword = emailUserPassword;
    }

    public void setToEmailAddress(String toEmailAddress) {
        this.toEmailAddress = toEmailAddress;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setAttachCollection(Collection<String> attachCollection) {
        this.attachCollection = attachCollection;
    }

    public String getCcEailAddress() {
        return this.ccEailAddress;
    }

    public void setCcEailAddress(String ccEailAddress) {
        this.ccEailAddress = ccEailAddress;
    }
}

