/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.framework.email;

import com.highesthelp.framework.email.PopupAuthenticator;
import com.highesthelp.framework.util.EncodingTools;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailSender2 {
    private static final String PROP_SMTP = "smtp";
    private static final String PROP_HOST = "mail.smtp.host";
    private static final String PROP_AUTH = "mail.smtp.auth";
    private String emailEncoding = "GB18030";
    private boolean needHtml = true;
    private String smtpServer = null;
    private boolean needAuth = true;
    private String fromEmail = null;
    private String emailUserName = null;
    private String emailUserPassword = null;
    private String toEmailAddress = null;
    private String subject = "";
    private String body = "";
    private Collection<String> attachCollection = null;

    public static void main(String[] args) {
    }

    public void send() throws Exception {
        Properties props = System.getProperties();
        props.put(PROP_HOST, this.smtpServer);
        if (this.needAuth) {
            props.put(PROP_AUTH, "true");
        } else {
            props.put(PROP_AUTH, "false");
        }
        PopupAuthenticator popupAuthenticator = new PopupAuthenticator(this.emailUserName, this.emailUserPassword);
        Session session = null;
        session = !this.needAuth ? Session.getDefaultInstance((Properties)props) : Session.getDefaultInstance((Properties)props, (Authenticator)popupAuthenticator);
        MimeMessage message = new MimeMessage(session);
        message.setSentDate(new Date());
        message.setFrom((Address)new InternetAddress(this.fromEmail));
        message.setSubject(this.subject, this.emailEncoding);
        message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.toEmailAddress));
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart bodyPart = new MimeBodyPart();
        if (this.needHtml) {
            bodyPart.setContent((Object)EncodingTools.toEncoding(this.body, this.emailEncoding), "text/plain;charset=" + this.emailEncoding);
        } else {
            bodyPart.setText(EncodingTools.toEncoding(this.body, this.emailEncoding));
        }
        multipart.addBodyPart((BodyPart)bodyPart);
        if (this.attachCollection != null) {
            for (String filename : this.attachCollection) {
                filename = EncodingTools.toEncoding(filename, this.emailEncoding);
                MimeBodyPart attachBodyPart = new MimeBodyPart();
                FileDataSource fds = new FileDataSource(filename);
                attachBodyPart.setFileName(fds.getName());
                attachBodyPart.setDataHandler(new DataHandler((DataSource)fds));
                multipart.addBodyPart((BodyPart)attachBodyPart);
            }
        }
        Transport transport = session.getTransport(PROP_SMTP);
        Transport.send((Message)message);
        transport.close();
    }

    public boolean isNeedHtml() {
        return this.needHtml;
    }

    public void setNeedHtml(boolean needHtml) {
        this.needHtml = needHtml;
    }

    public String getEmailEncoding() {
        return this.emailEncoding;
    }

    public String getSmtpServer() {
        return this.smtpServer;
    }

    public boolean isNeedAuth() {
        return this.needAuth;
    }

    public String getFromEmail() {
        return this.fromEmail;
    }

    public String getEmailUserName() {
        return this.emailUserName;
    }

    public String getEmailUserPassword() {
        return this.emailUserPassword;
    }

    public String getToEmailAddress() {
        return this.toEmailAddress;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBody() {
        return this.body;
    }

    public Collection<String> getAttachCollection() {
        return this.attachCollection;
    }

    public void setEmailEncoding(String emailEncoding) {
        this.emailEncoding = emailEncoding;
    }

    public void setSmtpServer(String smtpServer) {
        this.smtpServer = smtpServer;
    }

    public void setNeedAuth(boolean needAuth) {
        this.needAuth = needAuth;
    }

    public void setFromEmail(String fromEmail) {
        this.fromEmail = fromEmail;
    }

    public void setEmailUserName(String emailUserName) {
        this.emailUserName = emailUserName;
    }

    public void setEmailUserPassword(String emailUserPassword) {
        this.emailUserPassword = emailUserPassword;
    }

    public void setToEmailAddress(String toEmailAddress) {
        this.toEmailAddress = toEmailAddress;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setAttachCollection(Collection<String> attachCollection) {
        this.attachCollection = attachCollection;
    }
}

