/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.framework.jfreechart;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class BarChartServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletOutputStream out = response.getOutputStream();
        try {
            try {
                PieDataset data = BarChartServlet.createDataset();
                JFreeChart chart = ChartFactory.createPieChart3D((String)"\u56fe\u4e66\u9500\u91cf\u7edf\u8ba1\u56fe", (PieDataset)data, (boolean)true, (boolean)true, (boolean)true);
                PiePlot pieplot = (PiePlot)chart.getPlot();
                pieplot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0}\uff1a{1}({2})"));
                pieplot.setLabelBackgroundPaint((Paint)new Color(220, 220, 220));
                pieplot.setLabelFont(new Font("\u5b8b\u4f53", 0, 12));
                pieplot.setNoDataMessage("\u65e0\u6570\u636e");
                pieplot.setNoDataMessageFont(new Font("\u5b8b\u4f53", 1, 14));
                pieplot.setNoDataMessagePaint((Paint)Color.red);
                pieplot.setIgnoreNullValues(true);
                pieplot.setIgnoreZeroValues(true);
                if (chart != null) {
                    response.setContentType("image/png");
                    ChartUtilities.writeChartAsPNG((OutputStream)out, (JFreeChart)chart, (int)600, (int)400);
                }
            }
            catch (Exception e) {
                System.err.println(e.toString());
                out.close();
            }
        }
        finally {
            out.close();
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPost(req, resp);
    }

    private static PieDataset createDataset() {
        DefaultPieDataset defaultpiedataset = new DefaultPieDataset();
        defaultpiedataset.setValue((Comparable)((Object)"\u6b63\u5e38\u6536\u5165"), (Number)new Double(43.2));
        defaultpiedataset.setValue((Comparable)((Object)"\u4e0d\u6b63\u5e38\u6536\u5165"), (Number)new Double(10.0));
        defaultpiedataset.setValue((Comparable)((Object)"three"), (Number)new Double(27.5));
        defaultpiedataset.setValue((Comparable)((Object)"four"), (Number)new Double(17.5));
        return defaultpiedataset;
    }
}

