/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.framework.jfreechart;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.servlet.ServletUtilities;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;

public class Chart {
    public static String getChart(String title, String columnName, String rowName, CategoryDataset dataset, HttpServletRequest request) {
        try {
            JFreeChart chart = ChartFactory.createStackedBarChart3D((String)title, (String)columnName, (String)rowName, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            CategoryPlot plot = chart.getCategoryPlot();
            CategoryAxis domainAxis = plot.getDomainAxis();
            plot.setDomainAxis(domainAxis);
            ValueAxis rangeAxis = plot.getRangeAxis();
            rangeAxis.setUpperMargin(0.15);
            rangeAxis.setLowerMargin(0.15);
            plot.setRangeAxis(rangeAxis);
            BarRenderer3D renderer = new BarRenderer3D();
            renderer.setBaseOutlinePaint((Paint)Color.BLACK);
            renderer.setWallPaint((Paint)Color.white);
            renderer.setSeriesPaint(0, (Paint)Color.RED);
            renderer.setSeriesPaint(1, (Paint)Color.BLUE);
            renderer.setSeriesPaint(2, (Paint)Color.GREEN);
            renderer.setSeriesPaint(3, (Paint)Color.CYAN);
            renderer.setItemMargin(0.1);
            renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
            renderer.setBaseItemLabelsVisible(true);
            plot.setRenderer((CategoryItemRenderer)renderer);
            plot.setForegroundAlpha(1.0f);
            String filename = ServletUtilities.saveChartAsPNG((JFreeChart)chart, (int)480, (int)220, null, (HttpSession)request.getSession());
            return filename;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getPieChart3D(String title, PieDataset dataset, HttpServletRequest request) {
        try {
            JFreeChart chart = ChartFactory.createPieChart3D((String)title, (PieDataset)dataset, (boolean)true, (boolean)true, (boolean)true);
            PiePlot pieplot = (PiePlot)chart.getPlot();
            pieplot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0}\uff1a{1}({2})"));
            pieplot.setLabelBackgroundPaint((Paint)new Color(246, 246, 246));
            pieplot.setLabelFont(new Font("\u5b8b\u4f53", 0, 14));
            pieplot.setNoDataMessage("\u65e0\u6570\u636e");
            pieplot.setNoDataMessageFont(new Font("\u5b8b\u4f53", 1, 14));
            pieplot.setNoDataMessagePaint((Paint)Color.red);
            pieplot.setIgnoreNullValues(true);
            pieplot.setIgnoreZeroValues(true);
            String filename = ServletUtilities.saveChartAsPNG((JFreeChart)chart, (int)600, (int)400, null, (HttpSession)request.getSession());
            return filename;
        }
        catch (Exception e) {
            return null;
        }
    }
}

