/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.framework.quartz;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.MethodInvoker;

public class BeanInvokingJobDetailFactoryBean
implements FactoryBean,
BeanNameAware,
InitializingBean,
ApplicationContextAware {
    protected static ApplicationContext applicationContext;
    private Log logger = LogFactory.getLog(this.getClass());
    private String group = "DEFAULT";
    private boolean concurrent = true;
    private boolean durable = false;
    private boolean volatility = false;
    private boolean shouldRecover = false;
    private String[] jobListenerNames;
    private String beanName;
    private JobDetail jobDetail;
    private String targetBean;
    private String targetMethod;
    private Object[] arguments;

    public String getTargetBean() {
        return this.targetBean;
    }

    public void setTargetBean(String targetBean) {
        this.targetBean = targetBean;
    }

    public String getTargetMethod() {
        return this.targetMethod;
    }

    public void setTargetMethod(String targetMethod) {
        this.targetMethod = targetMethod;
    }

    public Object getObject() throws Exception {
        return this.jobDetail;
    }

    public Class getObjectType() {
        return JobDetail.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            this.logger.debug((Object)"start");
            this.logger.debug((Object)("Creating JobDetail " + this.beanName));
            this.jobDetail = new JobDetail();
            this.jobDetail.setName(this.beanName);
            this.jobDetail.setGroup(this.group);
            this.jobDetail.setJobClass(this.concurrent ? BeanInvokingJob.class : StatefulBeanInvokingJob.class);
            this.jobDetail.setDurability(this.durable);
            this.jobDetail.setVolatility(this.volatility);
            this.jobDetail.setRequestsRecovery(this.shouldRecover);
            this.jobDetail.getJobDataMap().put("targetBean", this.targetBean);
            this.jobDetail.getJobDataMap().put("targetMethod", this.targetMethod);
            this.jobDetail.getJobDataMap().put((Object)"arguments", (Object)this.arguments);
            this.logger.debug((Object)("Registering JobListener names with JobDetail object " + this.beanName));
            if (this.jobListenerNames != null) {
                int i = 0;
                while (i < this.jobListenerNames.length) {
                    this.jobDetail.addJobListener(this.jobListenerNames[i]);
                    ++i;
                }
            }
            this.logger.info((Object)("Created JobDetail: " + this.jobDetail + "; targetBean: " + this.targetBean + "; targetMethod: " + this.targetMethod + "; arguments: " + this.arguments + ";"));
        }
        finally {
            this.logger.debug((Object)"end");
        }
    }

    public void setConcurrent(boolean concurrent) {
        this.concurrent = concurrent;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setJobListenerNames(String[] jobListenerNames) {
        this.jobListenerNames = jobListenerNames;
    }

    public void setShouldRecover(boolean shouldRecover) {
        this.shouldRecover = shouldRecover;
    }

    public void setVolatility(boolean volatility) {
        this.volatility = volatility;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        applicationContext = context;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    public static class BeanInvokingJob
    implements Job {
        protected Log logger = LogFactory.getLog(this.getClass());

        public void execute(JobExecutionContext context) throws JobExecutionException {
            try {
                try {
                    this.logger.debug((Object)"start");
                    String targetBean = context.getMergedJobDataMap().getString("targetBean");
                    this.logger.debug((Object)("targetBean is " + targetBean));
                    if (targetBean == null) {
                        throw new JobExecutionException("targetBean cannot be null.", false);
                    }
                    String targetMethod = context.getMergedJobDataMap().getString("targetMethod");
                    this.logger.debug((Object)("targetMethod is " + targetMethod));
                    if (targetMethod == null) {
                        throw new JobExecutionException("targetMethod cannot be null.", false);
                    }
                    Object argumentsObject = context.getMergedJobDataMap().get((Object)"arguments");
                    Object[] arguments = argumentsObject instanceof String ? null : (Object[])argumentsObject;
                    this.logger.debug((Object)("arguments array is " + arguments));
                    Object bean = applicationContext.getBean(targetBean);
                    this.logger.debug((Object)("applicationContext resolved bean name/id '" + targetBean + "' to " + bean));
                    MethodInvoker beanMethod = new MethodInvoker();
                    beanMethod.setTargetObject(bean);
                    beanMethod.setTargetMethod(targetMethod);
                    beanMethod.setArguments(arguments);
                    beanMethod.prepare();
                    this.logger.info((Object)("Invoking Bean: " + targetBean + "; Method: " + targetMethod + "; arguments: " + arguments + ";"));
                    beanMethod.invoke();
                }
                catch (JobExecutionException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new JobExecutionException((Throwable)e);
                }
            }
            finally {
                this.logger.debug((Object)"end");
            }
        }
    }

    public static class StatefulBeanInvokingJob
    extends BeanInvokingJob
    implements StatefulJob {
    }
}

