/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.framework.quartz;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.MethodInvoker;

public class MethodInvokingJobDetailFactoryBean
implements FactoryBean,
BeanNameAware,
InitializingBean {
    private Log logger = LogFactory.getLog(this.getClass());
    private String group = "DEFAULT";
    private boolean concurrent = true;
    private boolean durable = false;
    private boolean volatility = false;
    private boolean shouldRecover = false;
    private String[] jobListenerNames;
    private String beanName;
    private JobDetail jobDetail;
    private String targetClass;
    private Object targetObject;
    private String targetMethod;
    private String staticMethod;
    private Object[] arguments;

    public String getTargetClass() {
        return this.targetClass;
    }

    public void setTargetClass(String targetClass) {
        this.targetClass = targetClass;
    }

    public String getTargetMethod() {
        return this.targetMethod;
    }

    public void setTargetMethod(String targetMethod) {
        this.targetMethod = targetMethod;
    }

    public Object getObject() throws Exception {
        return this.jobDetail;
    }

    public Class getObjectType() {
        return JobDetail.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            this.logger.debug((Object)"start");
            this.logger.debug((Object)("Creating JobDetail " + this.beanName));
            this.jobDetail = new JobDetail();
            this.jobDetail.setName(this.beanName);
            this.jobDetail.setGroup(this.group);
            this.jobDetail.setJobClass(this.concurrent ? MethodInvokingJob.class : StatefulMethodInvokingJob.class);
            this.jobDetail.setDurability(this.durable);
            this.jobDetail.setVolatility(this.volatility);
            this.jobDetail.setRequestsRecovery(this.shouldRecover);
            if (this.targetClass != null) {
                this.jobDetail.getJobDataMap().put("targetClass", this.targetClass);
            }
            if (this.targetObject != null) {
                this.jobDetail.getJobDataMap().put((Object)"targetObject", this.targetObject);
            }
            if (this.targetMethod != null) {
                this.jobDetail.getJobDataMap().put("targetMethod", this.targetMethod);
            }
            if (this.staticMethod != null) {
                this.jobDetail.getJobDataMap().put("staticMethod", this.staticMethod);
            }
            if (this.arguments != null) {
                this.jobDetail.getJobDataMap().put((Object)"arguments", (Object)this.arguments);
            }
            this.logger.debug((Object)("Registering JobListener names with JobDetail object " + this.beanName));
            if (this.jobListenerNames != null) {
                int i = 0;
                while (i < this.jobListenerNames.length) {
                    this.jobDetail.addJobListener(this.jobListenerNames[i]);
                    ++i;
                }
            }
            this.logger.info((Object)("Created JobDetail: " + this.jobDetail + "; targetClass: " + this.targetClass + "; targetObject: " + this.targetObject + "; targetMethod: " + this.targetMethod + "; staticMethod: " + this.staticMethod + "; arguments: " + this.arguments + ";"));
        }
        finally {
            this.logger.debug((Object)"end");
        }
    }

    public void setConcurrent(boolean concurrent) {
        this.concurrent = concurrent;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setJobListenerNames(String[] jobListenerNames) {
        this.jobListenerNames = jobListenerNames;
    }

    public void setShouldRecover(boolean shouldRecover) {
        this.shouldRecover = shouldRecover;
    }

    public void setVolatility(boolean volatility) {
        this.volatility = volatility;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    public String getStaticMethod() {
        return this.staticMethod;
    }

    public void setStaticMethod(String staticMethod) {
        this.staticMethod = staticMethod;
    }

    public void setTargetObject(Object targetObject) {
        this.targetObject = targetObject;
    }

    public static class MethodInvokingJob
    implements Job {
        protected Log logger = LogFactory.getLog(this.getClass());

        public void execute(JobExecutionContext context) throws JobExecutionException {
            try {
                try {
                    this.logger.debug((Object)"start");
                    String targetClass = context.getMergedJobDataMap().getString("targetClass");
                    this.logger.debug((Object)("targetClass is " + targetClass));
                    Class<?> targetClassClass = null;
                    if (targetClass != null) {
                        targetClassClass = Class.forName(targetClass);
                    }
                    Object targetObject = context.getMergedJobDataMap().get((Object)"targetObject");
                    this.logger.debug((Object)("targetObject is " + targetObject));
                    String targetMethod = context.getMergedJobDataMap().getString("targetMethod");
                    this.logger.debug((Object)("targetMethod is " + targetMethod));
                    String staticMethod = context.getMergedJobDataMap().getString("staticMethod");
                    this.logger.debug((Object)("staticMethod is " + staticMethod));
                    Object[] arguments = (Object[])context.getMergedJobDataMap().get((Object)"arguments");
                    this.logger.debug((Object)("arguments are " + arguments));
                    this.logger.debug((Object)"creating MethodInvoker");
                    MethodInvoker methodInvoker = new MethodInvoker();
                    methodInvoker.setTargetClass(targetClassClass);
                    methodInvoker.setTargetObject(targetObject);
                    methodInvoker.setTargetMethod(targetMethod);
                    methodInvoker.setStaticMethod(staticMethod);
                    methodInvoker.setArguments(arguments);
                    methodInvoker.prepare();
                    this.logger.info((Object)("Invoking: " + methodInvoker.getPreparedMethod().toGenericString()));
                    methodInvoker.invoke();
                }
                catch (Exception e) {
                    throw new JobExecutionException((Throwable)e);
                }
            }
            finally {
                this.logger.debug((Object)"end");
            }
        }
    }

    public static class StatefulMethodInvokingJob
    extends MethodInvokingJob
    implements StatefulJob {
    }
}

