/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.framework.reg;

import com.highesthelp.framework.reg.NetworkInfo;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.StringTokenizer;

public class LinuxNetworkInfo
extends NetworkInfo {
    public static final String IPCONFIG_COMMAND = "ifconfig";

    public String parseMacAddress() throws ParseException {
        String ipConfigResponse = null;
        try {
            ipConfigResponse = this.runConsoleCommand(IPCONFIG_COMMAND);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ParseException(e.getMessage(), 0);
        }
        String localHost = null;
        try {
            localHost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
            throw new ParseException(ex.getMessage(), 0);
        }
        StringTokenizer tokenizer = new StringTokenizer(ipConfigResponse, "\n");
        String lastMacAddress = null;
        while (tokenizer.hasMoreTokens()) {
            String macAddressCandidate;
            boolean containsLocalHost;
            String line = tokenizer.nextToken().trim();
            boolean bl = containsLocalHost = line.indexOf(localHost) >= 0;
            if (containsLocalHost && lastMacAddress != null) {
                return lastMacAddress;
            }
            int macAddressPosition = line.indexOf("HWaddr");
            if (macAddressPosition <= 0 || !this.isMacAddress(macAddressCandidate = line.substring(macAddressPosition + 6).trim())) continue;
            lastMacAddress = macAddressCandidate;
        }
        ParseException ex = new ParseException("cannot read MAC address for " + localHost + " from [" + ipConfigResponse + "]", 0);
        ex.printStackTrace();
        throw ex;
    }

    public String parseDomain(String hostname) throws ParseException {
        return "";
    }

    private final boolean isMacAddress(String macAddressCandidate) {
        return macAddressCandidate.length() == 17;
    }
}

