/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.framework.reg;

import com.highesthelp.framework.reg.LinuxNetworkInfo;
import com.highesthelp.framework.reg.WindowsNetworkInfo;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class NetworkInfo {
    private static final String LOCALHOST = "localhost";
    public static final String NSLOOKUP_CMD = "nslookup";

    public abstract String parseMacAddress() throws ParseException;

    public String parseDomain() throws ParseException {
        return this.parseDomain(LOCALHOST);
    }

    public static final String getMacAddress() throws IOException {
        try {
            NetworkInfo info = NetworkInfo.getNetworkInfo();
            String mac = info.parseMacAddress();
            return mac;
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    public static final String getNetworkDomain() throws IOException {
        try {
            NetworkInfo info = NetworkInfo.getNetworkInfo();
            String domain = info.parseDomain();
            return domain;
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    protected String parseDomain(String hostname) throws ParseException {
        InetAddress addy = null;
        try {
            addy = InetAddress.getByName(hostname);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            throw new ParseException(e.getMessage(), 0);
        }
        hostname = addy.getCanonicalHostName();
        String nslookupCommand = "nslookup " + hostname;
        String nslookupResponse = null;
        try {
            nslookupResponse = this.runConsoleCommand(nslookupCommand);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ParseException(e.getMessage(), 0);
        }
        StringTokenizer tokeit = new StringTokenizer(nslookupResponse, "\n", false);
        while (tokeit.hasMoreTokens()) {
            String line = tokeit.nextToken();
            if (!line.startsWith("Name:")) continue;
            line = line.substring(line.indexOf(":") + 1);
            if (!NetworkInfo.isDomain(line = line.trim(), hostname)) continue;
            line = line.substring(hostname.length() + 1);
            return line;
        }
        return "n.a.";
    }

    private static boolean isDomain(String domainCandidate, String hostname) {
        Pattern domainPattern = Pattern.compile("[\\w-]+\\.[\\w-]+\\.[\\w-]+\\.[\\w-]+");
        Matcher m = domainPattern.matcher(domainCandidate);
        return m.matches() && domainCandidate.startsWith(hostname);
    }

    protected String runConsoleCommand(String command) throws IOException {
        int c;
        Process p = Runtime.getRuntime().exec(command);
        BufferedInputStream stdoutStream = new BufferedInputStream(p.getInputStream());
        StringBuffer buffer = new StringBuffer();
        while ((c = ((InputStream)stdoutStream).read()) != -1) {
            buffer.append((char)c);
        }
        String outputText = buffer.toString();
        ((InputStream)stdoutStream).close();
        return outputText;
    }

    private static NetworkInfo getNetworkInfo() throws IOException {
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            return new WindowsNetworkInfo();
        }
        if (os.startsWith("Linux")) {
            return new LinuxNetworkInfo();
        }
        throw new IOException("unknown operating system: " + os);
    }

    protected String getLocalHost() throws ParseException {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            throw new ParseException(e.getMessage(), 0);
        }
    }
}

