/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.framework.reg;

import com.highesthelp.framework.reg.NetworkInfo;
import java.io.IOException;
import java.text.ParseException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WindowsNetworkInfo
extends NetworkInfo {
    public static final String IPCONFIG_COMMAND = "ipconfig /all";

    public String parseMacAddress() throws ParseException {
        String ipConfigResponse = null;
        try {
            ipConfigResponse = this.runConsoleCommand(IPCONFIG_COMMAND);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ParseException(e.getMessage(), 0);
        }
        String localHost = this.getLocalHost();
        StringTokenizer tokenizer = new StringTokenizer(ipConfigResponse, "\n");
        String lastMacAddress = null;
        while (tokenizer.hasMoreTokens()) {
            String macAddressCandidate;
            String line = tokenizer.nextToken().trim();
            if (line.endsWith(localHost) && lastMacAddress != null) {
                return lastMacAddress;
            }
            int macAddressPosition = line.indexOf(":");
            if (macAddressPosition <= 0 || !WindowsNetworkInfo.isMacAddress(macAddressCandidate = line.substring(macAddressPosition + 1).trim())) continue;
            lastMacAddress = macAddressCandidate;
        }
        ParseException ex = new ParseException("Cannot read MAC address from [" + ipConfigResponse + "]", 0);
        ex.printStackTrace();
        throw ex;
    }

    private static boolean isMacAddress(String macAddressCandidate) {
        Pattern macPattern = Pattern.compile("[0-9a-fA-F]{2}-[0-9a-fA-F]{2}-[0-9a-fA-F]{2}-[0-9a-fA-F]{2}-[0-9a-fA-F]{2}-[0-9a-fA-F]{2}");
        Matcher m = macPattern.matcher(macAddressCandidate);
        return m.matches();
    }
}

