/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.framework.report;

import com.highesthelp.framework.report.Header;
import com.highesthelp.framework.util.FileTools;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;

public class HReport {
    public static String HTML_PREFIX = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"><HTML><HEAD><TITLE></TITLE><link rel=\"stylesheet\" href=\"print.css\" type=\"text/css\" media=\"print\"></HEAD><BODY>";
    public static String HTML_SUBFIX = "</BODY></HTML>";
    private String title;
    private Header[] headers;
    private Object[][] values;
    private int maxItem = 36;
    private String printer;
    private String printDate = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
    private boolean showPrinter = false;
    private boolean showPrintDate = false;
    private boolean showTitleInPerPage = true;

    public String reportToExcel(String path) {
        String outputFile = path;
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet sheet = workbook.createSheet(this.title);
            HSSFRow titleRow = sheet.createRow(0);
            titleRow.setHeight((short)600);
            HSSFCell titleCell = titleRow.createCell((short)0);
            HSSFFont font = workbook.createFont();
            font.setColor((short)Short.MAX_VALUE);
            font.setBoldweight((short)700);
            font.setFontHeight((short)550);
            HSSFCellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setFont(font);
            cellStyle.setAlignment((short)2);
            titleCell.setCellStyle(cellStyle);
            titleCell.setCellValue(this.title);
            sheet.addMergedRegion(new Region(0, 0, 0, (short)(this.getShowHeaderCount() - 1)));
            HSSFRow printerRow = sheet.createRow(1);
            printerRow.setHeight((short)400);
            HSSFCell pCell = printerRow.createCell((short)0);
            pCell.setCellType(1);
            pCell.setCellValue("\u6253\u5370\u4eba:" + this.printer);
            HSSFCell dCell = printerRow.createCell((short)(this.getShowHeaderCount() - 1));
            dCell.setCellType(1);
            dCell.setCellValue("\u65f6\u95f4:" + this.printDate);
            HSSFRow headerRow = sheet.createRow(2);
            headerRow.setHeight((short)400);
            int o = 0;
            int i = 0;
            while (i < this.headers.length) {
                if (this.headers[i].isShow()) {
                    HSSFFont headerFont = workbook.createFont();
                    headerFont.setBoldweight((short)700);
                    headerFont.setFontHeight((short)250);
                    HSSFCellStyle headerCellStyle = workbook.createCellStyle();
                    headerCellStyle.setFont(headerFont);
                    if (this.headers[i].getAlign().equals(Header.TEXT_ALIGN_RGIHT)) {
                        headerCellStyle.setAlignment((short)3);
                    } else if (this.headers[i].getAlign().equals(Header.TEXT_ALIGN_CENTER)) {
                        headerCellStyle.setAlignment((short)2);
                    } else {
                        headerCellStyle.setAlignment((short)1);
                    }
                    HSSFCell headerCell = headerRow.createCell((short)o);
                    headerCell.setCellValue(this.headers[i].getHeaderName());
                    headerCell.setCellStyle(headerCellStyle);
                    ++o;
                }
                ++i;
            }
            if (this.values != null) {
                i = 0;
                while (i < this.values.length) {
                    HSSFRow valueRow = sheet.createRow((int)((short)(3 + i)));
                    valueRow.setHeight((short)300);
                    Object[] objs = this.values[i];
                    int p = 0;
                    if (objs != null) {
                        int j = 0;
                        while (j < objs.length) {
                            if (this.headers[j].isShow()) {
                                HSSFCellStyle valueCellStyle = workbook.createCellStyle();
                                if (this.headers[j].getAlign().equals(Header.TEXT_ALIGN_RGIHT)) {
                                    valueCellStyle.setAlignment((short)3);
                                } else if (this.headers[j].getAlign().equals(Header.TEXT_ALIGN_CENTER)) {
                                    valueCellStyle.setAlignment((short)2);
                                } else {
                                    valueCellStyle.setAlignment((short)1);
                                }
                                HSSFCell valueCell = valueRow.createCell((short)p);
                                valueCell.setCellStyle(valueCellStyle);
                                String val = null;
                                val = objs[j] != null ? objs[j].toString() : "";
                                valueCell.setCellValue(val);
                                ++p;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            FileTools.createFolderNoExist(FileTools.removeFileName(outputFile));
            FileOutputStream fOut = new FileOutputStream(outputFile);
            workbook.write((OutputStream)fOut);
            fOut.flush();
            fOut.close();
            System.out.println("\u6587\u4ef6\u751f\u6210...");
        }
        catch (Exception e) {
            System.out.println("\u5df2\u8fd0\u884c exlCreate() : " + e);
        }
        return path;
    }

    public String reportToHTML() {
        String tablePrefix = "<TABLE border=\"0\" cellpadding=\"0\" cellspacing=\"0\" align=\"center\"> <THEAD> <TR><TD colspan=\"" + this.getShowHeaderCount() + "\" align=\"center\" style=\"border-top:1px solid #CCDCEE;\"><h1>" + this.title + "</h1></TD>" + "</TR> ";
        String printerTR = "<TR><TD colspan=\"" + this.getShowHeaderCount() + "\" align=\"right\" style=\"bleft\">" + " \u6253\u5370\u65f6\u95f4:" + this.printDate + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\u6253\u5370\u4eba:" + this.printer + "</TD>" + "</TR>";
        String headerTR = "<TR>";
        int i = 0;
        while (i < this.headers.length) {
            if (this.headers[i].isShow()) {
                headerTR = String.valueOf(headerTR) + "<TD align=\"" + this.headers[i].getAlign() + "\"><b>" + this.headers[i].getHeaderName() + "</b></TD>";
            }
            ++i;
        }
        headerTR = String.valueOf(headerTR) + "</TR></THEAD><TBODY>";
        String valueTR = "";
        if (this.values != null) {
            int i2 = 0;
            while (i2 < this.values.length) {
                Object[] objs;
                String value = "<TR>";
                if ((i2 + 1) % this.maxItem == 0) {
                    value = "<TR style=\"page-break-after: always;\">";
                }
                if ((objs = this.values[i2]) != null) {
                    int j = 0;
                    while (j < objs.length) {
                        if (this.headers[j].isShow()) {
                            String val = "";
                            if (objs[j] != null) {
                                val = objs[j].toString();
                            }
                            value = String.valueOf(value) + "<TD  align=\"" + this.headers[j].getAlign() + "\">" + val + "&nbsp;</TD>";
                        }
                        ++j;
                    }
                }
                value = String.valueOf(value) + "</TR>";
                valueTR = String.valueOf(valueTR) + value;
                ++i2;
            }
        }
        String tableSubfix = "</TBODY></TABLE> ";
        return String.valueOf(tablePrefix) + printerTR + headerTR + valueTR + tableSubfix;
    }

    public static void main(String[] args) {
        Header[] hd = new Header[]{new Header("\u59d3\u540d"), new Header("\u73ed\u7ea7", Header.TEXT_ALIGN_CENTER), new Header("\u6027\u522b", Header.TEXT_ALIGN_RGIHT), new Header("\u8054\u7cfb\u5730\u5740"), new Header("\u8054\u7cfb\u7535\u8bdd", Header.TEXT_ALIGN_RGIHT), new Header("\u51fa\u751f\u65e5\u671f", false)};
        Object[][] values = new Object[94][6];
        int i = 0;
        while (i < values.length) {
            int j = 0;
            while (j < values[i].length) {
                values[i][j] = String.valueOf(i) + "_" + j;
                ++j;
            }
            ++i;
        }
        HReport hr = new HReport();
        hr.setPrinter("\u97e6\u6770");
        hr.setTitle("\u5b66\u751f\u73ed\u7ea7\u5bf9\u5e94\u8868");
        hr.setHeaders(hd);
        hr.setValues(values);
        hr.reportToHTML();
    }

    private int getShowHeaderCount() {
        int retValue = this.headers.length;
        int i = 0;
        while (i < this.headers.length) {
            if (!this.headers[i].isShow()) {
                --retValue;
            }
            ++i;
        }
        return retValue;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Header[] getHeaders() {
        return this.headers;
    }

    public void setHeaders(Header[] headers) {
        this.headers = headers;
    }

    public Object[][] getValues() {
        return this.values;
    }

    public void setValues(Object[][] values) {
        this.values = values;
    }

    public int getMaxItem() {
        return this.maxItem;
    }

    public void setMaxItem(int maxItem) {
        this.maxItem = maxItem;
    }

    public String getPrinter() {
        return this.printer;
    }

    public void setPrinter(String printer) {
        this.printer = printer;
    }

    public boolean isShowPrinter() {
        return this.showPrinter;
    }

    public void setShowPrinter(boolean showPrinter) {
        this.showPrinter = showPrinter;
    }

    public boolean isShowPrintDate() {
        return this.showPrintDate;
    }

    public void setShowPrintDate(boolean showPrintDate) {
        this.showPrintDate = showPrintDate;
    }

    public boolean isShowTitleInPerPage() {
        return this.showTitleInPerPage;
    }

    public void setShowTitleInPerPage(boolean showTitleInPerPage) {
        this.showTitleInPerPage = showTitleInPerPage;
    }

    public String getPrintDate() {
        return this.printDate;
    }

    public void setPrintDate(String printDate) {
        this.printDate = printDate;
    }
}

