/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.framework.service;

import com.highesthelp.framework.common.Page;
import com.highesthelp.framework.common.PageLimit;
import com.highesthelp.framework.common.WebContext;
import com.highesthelp.framework.dao.BaseDao;
import com.highesthelp.framework.email.EmailSender;
import com.highesthelp.framework.exception.DataAccessException;
import com.highesthelp.framework.exception.SessionTimeOutException;
import com.highesthelp.framework.util.ResourcesTools;
import com.highesthelp.framework.util.StringTools;
import com.highesthelp.pdcajob.pojo.Operator;
import com.highesthelp.pdcajob.pojo.SystemSet;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.extremecomponents.table.context.Context;
import org.extremecomponents.table.context.HttpServletRequestContext;
import org.extremecomponents.table.limit.Limit;
import org.extremecomponents.table.limit.LimitFactory;
import org.extremecomponents.table.limit.Sort;
import org.extremecomponents.table.limit.TableLimit;
import org.extremecomponents.table.limit.TableLimitFactory;

public class BaseServiceImpl {
    public Log log = LogFactory.getLog(this.getClass());
    public BaseDao baseDao;

    public PageLimit getPageLimit() throws ServletException {
        WebContext content = WebContext.getWebContext();
        HttpServletRequest request = content.getRequest();
        int startIndex = 0;
        int pageSize = Page.getDefaultPageSize();
        try {
            String currentPage = request.getParameter("ec_p");
            String currentPageSize = request.getParameter("ec_crd");
            if (!StringTools.isEmpty(currentPageSize)) {
                pageSize = Integer.valueOf(currentPageSize);
            }
            if (!StringTools.isEmpty(currentPage)) {
                startIndex = (Integer.valueOf(currentPage) - 1) * pageSize;
            }
            PageLimit limit = new PageLimit();
            limit.setStartIndex(startIndex);
            limit.setPageSize(pageSize);
            return limit;
        }
        catch (Exception e) {
            throw new ServletException();
        }
    }

    public Page getPage(String hql) throws ServletException, DataAccessException, Exception {
        PageLimit limit = this.getPageLimit();
        return this.baseDao.getBaseDaoPage(hql, limit.getStartIndex(), limit.getPageSize());
    }

    public List getList(String hql) throws DataAccessException, DataAccessException {
        return this.baseDao.getObjectsList(hql);
    }

    public Object getObject(String hql) throws DataAccessException, DataAccessException {
        return this.baseDao.getObject(hql);
    }

    public List getList(String hql, Object[] obj) throws DataAccessException, DataAccessException {
        return this.baseDao.getObjectsList(hql, obj);
    }

    public Object getObject(Object obj, Serializable pk) throws DataAccessException {
        return this.baseDao.getObjectByPk(obj, pk);
    }

    public Object saveObject(Object obj) throws DataAccessException {
        return this.baseDao.saveObject(obj);
    }

    public void saveOrUpdateList(List list) throws DataAccessException {
        this.baseDao.updateObjectsList(list);
    }

    public Object updateObject(Object obj) throws DataAccessException {
        return this.baseDao.updateObject(obj);
    }

    public boolean deleteObject(Object obj) throws DataAccessException {
        try {
            this.baseDao.deleteObject(obj);
            return true;
        }
        catch (Exception e) {
            throw new DataAccessException(e.getMessage());
        }
    }

    private int getPageSize() throws ServletException {
        WebContext content = WebContext.getWebContext();
        HttpServletRequest request = content.getRequest();
        String pageSizeParam = request.getParameter("ec_crd");
        if (pageSizeParam == null || "".equals(pageSizeParam)) {
            pageSizeParam = String.valueOf(Page.getDefaultPageSize());
        }
        int nPageSize = Integer.parseInt(pageSizeParam);
        return nPageSize;
    }

    private Limit getLimit() throws ServletException {
        WebContext content = WebContext.getWebContext();
        HttpServletRequest request = content.getRequest();
        HttpServletRequestContext context = new HttpServletRequestContext(request);
        TableLimitFactory limitFactory = new TableLimitFactory((Context)context);
        TableLimit limit = new TableLimit((LimitFactory)limitFactory);
        return limit;
    }

    private Sort getSort() throws ServletException {
        WebContext content = WebContext.getWebContext();
        HttpServletRequest request = content.getRequest();
        Limit limit = this.getLimit();
        Sort sort = limit.getSort();
        return sort;
    }

    public String getOrderString(String prefix) throws ServletException {
        String orderString = " order by ";
        try {
            Sort sort = this.getSort();
            String orderPropertes = sort.getProperty();
            String DescOrAsc = sort.getSortOrder();
            if (!StringTools.isEmpty(orderPropertes) && !StringTools.isEmpty(DescOrAsc)) {
                if (!StringTools.isEmpty(prefix)) {
                    return String.valueOf(orderString) + prefix + "." + orderPropertes.replaceAll("_", ".") + " " + DescOrAsc;
                }
                return String.valueOf(orderString) + orderPropertes.replaceAll("_", ".") + " " + DescOrAsc;
            }
            return "";
        }
        catch (Exception e) {
            throw new ServletException();
        }
    }

    public void executeHQL(String hql) throws DataAccessException {
        try {
            this.baseDao.excuteHQL(hql);
        }
        catch (Exception e) {
            throw new DataAccessException();
        }
    }

    public Connection getConnection() throws DataAccessException {
        try {
            Connection conn = this.baseDao.getConnection();
            return conn;
        }
        catch (Exception e) {
            throw new DataAccessException();
        }
    }

    public int getHQLCount(String hql) throws DataAccessException {
        int count = this.baseDao.getHQLCount(hql);
        return count;
    }

    public Operator getLoginUser() throws SessionTimeOutException {
        Operator user = WebContext.getLoginUser();
        return user;
    }

    public boolean sendNoticEmail(String title, String content, Operator operator) {
        try {
            SystemSet systemSet;
            boolean autoEmail = ResourcesTools.convertToBoolean(ResourcesTools.getOptionsMessage("option.system.message.send.email.auto"), false);
            if (autoEmail && (systemSet = (SystemSet)this.getObject(new SystemSet(), (Serializable)((Object)"emailsetter"))) != null && systemSet.getNeedSendEmail() == SystemSet.NEED_SEND_EMAIL && operator != null && StringTools.isNotEmpty(operator.getEmail())) {
                EmailSender sender = new EmailSender();
                sender.setToEmailAddress(operator.getEmail());
                sender.setFromEmail(systemSet.getFromEmail());
                sender.setEmailUserName(systemSet.getEmailUserName());
                sender.setEmailUserPassword(systemSet.getEmailPassword());
                sender.setNeedHtml(true);
                sender.setSmtpServer(systemSet.getSmtpServer());
                sender.setSubject(title);
                sender.setBody(content);
                sender.send();
            }
        }
        catch (Exception e) {
            this.log.error((Object)("send notic email error " + e.getMessage()));
            return false;
        }
        return true;
    }

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }
}

