/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.framework.servlet;

import com.highesthelp.framework.util.StringTools;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;

public class ReportServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            JRPdfExporter exporter;
            String renderType = request.getParameter("renderType");
            String fileName = StringTools.Date2String(new Date(), "yyyyMMddHHmmss");
            Object jasperPrint = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if ("pdf".equals(renderType)) {
                response.setContentType("application/pdf");
                response.setHeader("Content-Disposition", "attachment; filename=" + fileName + ".pdf");
                exporter = new JRPdfExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)baos);
                exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)(String.valueOf(fileName) + ".pdf"));
                exporter.exportReport();
            } else if ("csv".equals(renderType)) {
                response.setContentType("application/csv");
                response.setHeader("Content-Disposition", "attachment; filename=" + fileName + ".csv");
                exporter = new JRCsvExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)baos);
                exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)(String.valueOf(fileName) + ".csv"));
                exporter.exportReport();
            } else {
                response.setContentType("application/vnd.ms-excel");
                response.setHeader("Content-Disposition", "attachment; filename=" + fileName + ".xls");
                exporter = new JRXlsExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)baos);
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
                exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)(String.valueOf(fileName) + ".xls"));
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
                exporter.exportReport();
            }
            byte[] bytes = baos.toByteArray();
            response.setContentLength(bytes.length);
            ServletOutputStream ouputStream = response.getOutputStream();
            ouputStream.write(bytes, 0, bytes.length);
            ouputStream.flush();
            ouputStream.close();
        }
        catch (Exception e) {
            throw new InvalidParameterException("\u62a5\u8868\u751f\u6210\u6587\u4ef6\u65f6\u51fa\u9519\uff1a" + e.getMessage());
        }
    }

    protected void doPost(HttpServletRequest requst, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(requst, response);
    }
}

