/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.framework.upload;

import com.highesthelp.framework.exception.UploadFileException;
import com.highesthelp.framework.upload.FileLoad;
import com.highesthelp.framework.util.FileTools;
import java.io.IOException;
import org.apache.struts.upload.FormFile;

public class FileUpload
extends FileLoad {
    FormFile formFile = null;
    private String allowFileExt = ".*";
    private long maxFileSize = 50000000L;

    public FileUpload(FormFile formFile) {
        this.setFileNameRenderPlot(FileLoad.PLOT_RETAIN);
        this.formFile = formFile;
        this.setFileName(this.formFile.getFileName());
        this.setFileSize(this.formFile.getFileSize());
        this.setFileExtName(this.getFileExt(this.formFile.getFileName()));
    }

    public String saveFileToServer() throws UploadFileException {
        if (this.checkFileExt()) {
            if (this.checkFileSize()) {
                String saveFilePath = String.valueOf(this.getSavePath()) + this.getFileName() + this.getFileExtName();
                try {
                    while (this.getFileNameRenderPlot() == FileLoad.PLOT_RETAIN && FileTools.isFileExisted(saveFilePath)) {
                        saveFilePath = String.valueOf(this.getSavePath()) + this.getFileName() + "(1)" + this.getFileExtName();
                    }
                    FileTools.createFolderNoExist(this.getSavePath());
                    FileTools.makeFileByInputStream(saveFilePath, this.formFile.getInputStream());
                    return saveFilePath;
                }
                catch (IOException ioe) {
                    throw new UploadFileException(ioe.getMessage());
                }
            }
            throw new UploadFileException("file size " + this.getFileSize() + " is not allow");
        }
        throw new UploadFileException("file Ext " + this.getFileExtName() + " is not allow");
    }

    private boolean checkFileSize() {
        int size = this.formFile.getFileSize();
        return (long)size <= this.maxFileSize;
    }

    private boolean checkFileExt() {
        String[] arrExt = this.allowFileExt.split(",");
        int i = 0;
        while (i < arrExt.length) {
            if (".*".equals(arrExt[i])) {
                return true;
            }
            if (this.getFileExtName().equals(arrExt[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getFileExt(String fileName) {
        return "." + fileName.substring(fileName.lastIndexOf(".") + 1);
    }
}

