/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.framework.util;

import com.highesthelp.framework.util.StringTools;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class DateTools {
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    public static final String TIME_FORMAT = "HH:mm:ss:SS";
    public static final String DEFAULT_SHORT_DATE_FORMAT = "yyyy-MM-dd";
    public static final String DEFAULT_LONG_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss:SS";
    public static final String DATE_FORMAT = "dd MMM yyyy";
    public static final SimpleDateFormat DIS_DATE_FORMAT = new SimpleDateFormat("dd MMM yyyy", Locale.ENGLISH);
    public static final String MAINMENU_DATE_FORMAT = "EEE, dd MMM yyyy";
    public static final SimpleDateFormat MM_DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy", Locale.ENGLISH);
    public static final String DATETIME_FORMAT = "HH:mm:ss";
    public static final String DATE_TIME_FORMAT = "dd MMM yyyy HH:mm:ss";
    public static final SimpleDateFormat DIS_DATE_TIME_FORMAT = new SimpleDateFormat("dd MMM yyyy HH:mm:ss", Locale.ENGLISH);

    public static Timestamp convertStrToTimestamp(String dateStr) {
        if (dateStr == null) {
            return null;
        }
        String dStr = new String(dateStr).trim();
        if (dStr.indexOf(" ") == -1) {
            dStr = String.valueOf(dStr) + " " + DateTools.getCurrDateStr(TIME_FORMAT);
        }
        Date utilDate = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DEFAULT_LONG_DATE_FORMAT);
        try {
            utilDate = simpleDateFormat.parse(dStr);
        }
        catch (Exception ex) {
            throw new RuntimeException("DateUtil.convertStrToTimestamp(): " + ex.getMessage());
        }
        return new Timestamp(utilDate.getTime());
    }

    public static Timestamp getCurrTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static Timestamp convertDate2Timestamp(Date date) {
        if (date != null) {
            long dateLong = date.getTime();
            String dateStr = "" + dateLong;
            dateStr = String.valueOf(dateStr.substring(0, dateStr.length() - 3)) + "000";
            Long timeLong = new Long(dateStr);
            return new Timestamp(timeLong);
        }
        return null;
    }

    public static String getCurrDateStr(String dateFormat) {
        return DateTools.convertDateToStr(new Date(), dateFormat);
    }

    public static String convertDateToStr(Date date, String dateFormat) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        return sdf.format(date);
    }

    public static Date convertStrToDate(String dateStr, String dateFormat) {
        if (dateStr == null || dateStr.equals("")) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        try {
            return sdf.parse(dateStr);
        }
        catch (Exception e) {
            throw new RuntimeException("DateUtil.convertStrToDate():" + e.getMessage());
        }
    }

    public static double dateDiff(String datepart, Date startdate, Date enddate) {
        if (datepart == null || datepart.equals("")) {
            throw new IllegalArgumentException("DateUtil.dateDiff()\u65b9\u6cd5\u975e\u6cd5\u53c2\u6570\u503c\uff1a" + datepart);
        }
        double distance = (enddate.getTime() - startdate.getTime()) / 86400000L;
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(enddate.getTime() - startdate.getTime());
        if (datepart.equals("yy")) {
            distance /= 365.0;
        } else if (datepart.equals("MM")) {
            distance /= 30.0;
        } else if (datepart.equals("dd")) {
            distance = (enddate.getTime() - startdate.getTime()) / 86400000L;
        } else if (datepart.equals("hh")) {
            distance = (enddate.getTime() - startdate.getTime()) / 3600000L;
        } else {
            throw new IllegalArgumentException("DateUtil.dateDiff()\u65b9\u6cd5\u975e\u6cd5\u53c2\u6570\u503c\uff1a" + datepart);
        }
        return distance;
    }

    public static int getMonthDiff(Date startdate, Date enddate) {
        int k = 0;
        GregorianCalendar temp = new GregorianCalendar();
        temp.setTime(startdate);
        temp.set(14, 0);
        temp.add(5, 1);
        int day = temp.getActualMaximum(5);
        GregorianCalendar endCal = new GregorianCalendar();
        endCal.setTime(enddate);
        endCal.set(14, 0);
        endCal.add(5, 1);
        while (temp.getTime().before(endCal.getTime())) {
            ++k;
            day = temp.getActualMaximum(5);
            temp.add(5, day);
        }
        return k;
    }

    public static Date addDate(String datepart, int number, Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (datepart.equals("yy")) {
            cal.add(1, number);
        } else if (datepart.equals("MM")) {
            cal.add(2, number);
        } else if (datepart.equals("dd")) {
            cal.add(5, number);
        } else {
            throw new IllegalArgumentException("DateUtil.addDate()\u65b9\u6cd5\u975e\u6cd5\u53c2\u6570\u503c\uff1a" + datepart);
        }
        return cal.getTime();
    }

    public static String formatDate(Date date, int style, Locale loc) {
        if (style < 1 || style > 3) {
            throw new IllegalArgumentException("parameter is invalid.");
        }
        String newDate = "";
        if (loc == null) {
            loc = Locale.getDefault();
        }
        if (date != null) {
            DateFormat df = DateFormat.getDateInstance(style, loc);
            newDate = df.format(date);
        }
        return newDate;
    }

    public static String formatDate(Date date, String pattern, Locale loc) {
        if (pattern == null) {
            throw new IllegalArgumentException("parameter is invalid.");
        }
        String newDate = "";
        if (loc == null) {
            loc = Locale.getDefault();
        }
        if (date != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern, loc);
            newDate = sdf.format(date);
        }
        return newDate;
    }

    public static String formatDateTime(Date date, int dateStyle, int timeStyle, Locale loc) {
        if (dateStyle < 1 || dateStyle > 3) {
            throw new IllegalArgumentException("parameter is invalid.");
        }
        if (timeStyle < 1 || timeStyle > 3) {
            throw new IllegalArgumentException("parameter is invalid.");
        }
        String newDate = "";
        if (loc == null) {
            loc = Locale.getDefault();
        }
        if (date != null) {
            DateFormat df = DateFormat.getDateTimeInstance(dateStyle, timeStyle, loc);
            newDate = df.format(date);
        }
        return newDate;
    }

    public static String formatDateTime(Date date, String dateStr, String timeStr, Locale loc) {
        if (dateStr == null) {
            throw new IllegalArgumentException("parameter is invalid.");
        }
        if (timeStr == null) {
            throw new IllegalArgumentException("parameter is invalid.");
        }
        String newDate = "";
        if (loc == null) {
            loc = Locale.getDefault();
        }
        if (date != null) {
            String pattern = String.valueOf(dateStr == null ? "" : dateStr) + " " + (timeStr == null ? "" : timeStr);
            SimpleDateFormat sdf = new SimpleDateFormat(pattern, loc);
            newDate = sdf.format(date);
        }
        return newDate;
    }

    public static String formatDateTime(Date dt) {
        String newDate = "";
        if (dt != null) {
            Locale locale = Locale.CHINESE;
            SimpleDateFormat dateStyle = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", locale);
            newDate = dateStyle.format(dt);
        }
        return newDate;
    }

    public static Date parseStrToDate(String dateStr) throws ParseException {
        SimpleDateFormat sf = new SimpleDateFormat(DEFAULT_SHORT_DATE_FORMAT);
        return sf.parse(dateStr);
    }

    public static Date parseStrToDate(String date, String pattern) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.parse(date);
    }

    public static Date getCurrentDate() {
        return new Date(System.currentTimeMillis());
    }

    public static long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static Date addDate(Date date, int days) {
        if (date == null) {
            return date;
        }
        Locale loc = Locale.getDefault();
        GregorianCalendar cal = new GregorianCalendar(loc);
        cal.setTime(date);
        int day = cal.get(5);
        int month = cal.get(2);
        int year = cal.get(1);
        cal.set(year, month, day + days);
        return cal.getTime();
    }

    public static Date clearFromHoursToMillis(Date date) {
        if (date == null) {
            return date;
        }
        Locale loc = Locale.getDefault();
        GregorianCalendar cal = new GregorianCalendar(loc);
        cal.setTime(date);
        cal.clear(14);
        cal.clear(13);
        cal.clear(12);
        cal.clear(10);
        cal.clear(11);
        return cal.getTime();
    }

    public static Date addDate(int days) {
        Locale loc = Locale.getDefault();
        GregorianCalendar cal = new GregorianCalendar(loc);
        int day = cal.get(5);
        int month = cal.get(2);
        int year = cal.get(1);
        cal.set(year, month, day + days);
        return cal.getTime();
    }

    public static int getDays(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return 0;
        }
        return (int)((date2.getTime() - date1.getTime()) / 86400000L);
    }

    public static Date getNextDay(Date day) {
        Calendar nowC = DateTools.date2Clear(day);
        nowC.add(5, 1);
        return nowC.getTime();
    }

    public static Date getPreDay(Date day) {
        Calendar nowC = DateTools.date2Clear(day);
        nowC.add(5, -1);
        return nowC.getTime();
    }

    public static Date getLastSecPreDay(Date day) {
        Calendar nowC = DateTools.date2Clear(day);
        nowC.set(13, -1);
        return nowC.getTime();
    }

    private static Calendar date2Clear(Date day) {
        Calendar nowC = Calendar.getInstance();
        nowC.setTime(day);
        nowC.set(10, 0);
        nowC.set(11, 0);
        nowC.set(12, 0);
        nowC.set(13, 0);
        nowC.set(14, 0);
        return nowC;
    }

    public static void main(String[] args) {
        try {
            Date nowDate = new Date();
            Date startDate = StringTools.String2Date("2009-4-3");
            double rem = DateTools.dateDiff("dd", startDate, nowDate);
            System.out.println(rem);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

