/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.framework.util;

import com.highesthelp.framework.util.StringTools;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;

public class EncodingTools {
    public static final String CHARSET_ISO88591 = "ISO-8859-1";
    public static final String CHARSET_88591 = "8859_1";
    public static final String CHARSET_GB18030 = "GB18030";
    public static final String CHARSET_GB2312 = "GB18030";
    public static final String CHARSET_UTF8 = "UTF-8";
    public static final String CHARSET_UTF16 = "UTF-16";
    public static final String CHARSET_UNICODEBIGUNMARKED = "UnicodeBigUnmarked";
    public static final String CHARSET_USASCII = "US-ASCII";
    public static final String ENCODING_DEFAULT = "ISO-8859-1";
    private static HashMap theLangToEncodingMap = new HashMap();
    private static final char[] digits;

    static {
        theLangToEncodingMap.put("zh", "GB18030");
        theLangToEncodingMap.put("en", "ISO-8859-1");
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isChinese(String txt) {
        byte[] bytes = new byte[]{};
        try {
            bytes = txt.getBytes("ISO-8859-1");
            int i = 0;
            while (true) {
                if (i >= bytes.length) {
                    return false;
                }
                if (bytes[i] < 0) {
                    return true;
                }
                ++i;
            }
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
    }

    public static boolean isChinese(char message) {
        boolean isChinese = false;
        if (message < '\u0000' || message > '\u007f') {
            isChinese = true;
        }
        return isChinese;
    }

    public static String getSystemEncoding() {
        String lang = Locale.getDefault().getLanguage();
        String enc = (String)theLangToEncodingMap.get(lang);
        if (!StringTools.isEmpty(enc)) {
            return "ISO-8859-1";
        }
        return enc;
    }

    public static boolean sameSystemEncoding(String enc) {
        return enc.equals(EncodingTools.getSystemEncoding());
    }

    public static String ISO88591toGB2312(String gbStr) {
        if (gbStr != null) {
            try {
                gbStr = new String(gbStr.getBytes("ISO-8859-1"), "GB18030");
            }
            catch (Throwable e) {
                return "";
            }
        }
        return gbStr;
    }

    public static String GB2312toISO88591(String uStr) {
        if (uStr != null) {
            try {
                uStr = new String(uStr.getBytes("GB18030"), "ISO-8859-1");
            }
            catch (Throwable e) {
                return "";
            }
        }
        return uStr;
    }

    public static String GB18030toISO88591(String uStr) {
        if (uStr != null) {
            try {
                uStr = new String(uStr.getBytes("GB18030"), "ISO-8859-1");
            }
            catch (Throwable e) {
                return "";
            }
        }
        return uStr;
    }

    public static String toISO88591(String uStr) {
        return EncodingTools.toEncoding(uStr, "ISO-8859-1");
    }

    public static String toGB2312(String uStr) {
        return EncodingTools.toEncoding(uStr, "GB18030");
    }

    public static String toUnicode(String str, String currEncoding) {
        if (str != null) {
            try {
                str = new String(str.getBytes(currEncoding));
            }
            catch (Throwable e) {
                return "";
            }
        }
        return str;
    }

    public static String toUnicodeKeep(String str, String currEncoding) {
        if (str != null) {
            try {
                str = new String(str.getBytes(currEncoding));
            }
            finally {
                return str;
            }
        }
    }

    public static String toEncoding(String str, String destEncoding) {
        if (str != null) {
            try {
                str = new String(str.getBytes(), destEncoding);
            }
            catch (Throwable e) {
                return "";
            }
        }
        return str;
    }

    public static String toEncodingKeep(String str, String destEncoding) {
        if (str != null) {
            try {
                str = new String(str.getBytes(), destEncoding);
            }
            finally {
                return str;
            }
        }
    }

    public static byte[] toByteArray(String str, String srcEncoding) {
        try {
            return str.getBytes(srcEncoding);
        }
        catch (UnsupportedEncodingException e) {
            return str.getBytes();
        }
    }

    public static String URLEncoderToUTF8(String str) {
        if (StringTools.empty(str)) {
            return "";
        }
        try {
            str = URLEncoder.encode(str, CHARSET_UTF8);
            str = str.replace("%", "~");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return str;
    }

    public static String URLDecodeFromUTF8(String str) {
        try {
            str = str.replace("~", "%");
            str = URLDecoder.decode(str, CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return str;
    }
}

