/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.framework.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileTools {
    private static Log getLogger() {
        Log log = LogFactory.getLog(FileTools.class);
        return log;
    }

    public static void touchPath(String path) {
        try {
            new File(path).mkdirs();
        }
        catch (Exception e) {
            FileTools.getLogger().error((Object)("mkdirs failure, path = " + path), (Throwable)e);
        }
    }

    public static boolean delete(String path) {
        try {
            File file = new File(path);
            return file.delete();
        }
        catch (Exception e) {
            FileTools.getLogger().error((Object)("delete failure, path = " + path), (Throwable)e);
            return false;
        }
    }

    public static void deleteAllSubFiles(String dirPath) throws Exception {
        block5: {
            FileTools.getLogger().info((Object)("delete all sub files, dir = " + dirPath));
            try {
                File dir = new File(dirPath);
                if (!dir.isDirectory()) break block5;
                File[] subFiles = dir.listFiles();
                int i = 0;
                while (i < subFiles.length) {
                    File subFile = subFiles[i];
                    try {
                        subFile.delete();
                    }
                    catch (Exception e) {
                        FileTools.getLogger().error((Object)("delete sub file failure, file = " + subFile.getName()), (Throwable)e);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                FileTools.getLogger().error((Object)("delete all sub files failure, dir = " + dirPath), (Throwable)e);
                throw e;
            }
        }
    }

    public static void deleteDirectory(String filePathName) {
        FileTools.deleteDirectory(new File(filePathName));
    }

    public static void deleteDirectory(File f) {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            int i = 0;
            while (i < files.length) {
                FileTools.deleteDirectory(files[i]);
                ++i;
            }
        }
        f.delete();
    }

    public static boolean copy(InputStream src, String dstPath) {
        String srcPath = null;
        try {
            File dstFile = new File(dstPath);
            byte[] buffer = new byte[65536];
            int length = 0;
            FileOutputStream os = new FileOutputStream(dstFile);
            try {
                while ((length = src.read(buffer, 0, buffer.length)) != -1) {
                    ((OutputStream)os).write(buffer, 0, length);
                }
            }
            finally {
                FileTools.close(os);
            }
        }
        catch (Exception e) {
            FileTools.getLogger().error((Object)("backup failure, src path = " + srcPath + ", dst path = " + dstPath), (Throwable)e);
            return false;
        }
    }

    public static void copyFileAsString(String srcFilePathName, String dstFilePathName) throws IOException {
        int c;
        File inputFile = new File(srcFilePathName);
        File outputFile = new File(dstFilePathName);
        File tempfolder = outputFile.getParentFile();
        if (!tempfolder.exists()) {
            tempfolder.mkdirs();
        }
        outputFile = new File(tempfolder.getPath(), outputFile.getName());
        while (!outputFile.exists()) {
            outputFile.createNewFile();
        }
        FileReader in = new FileReader(inputFile);
        FileWriter out = new FileWriter(outputFile);
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        in.close();
        out.close();
    }

    public static void copyFileAsStream(String srcFilePathName, String dstFilePathName) throws IOException {
        FileInputStream fis = new FileInputStream(srcFilePathName);
        FileOutputStream fos = new FileOutputStream(dstFilePathName);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }

    public static void copyDirectiory(String srcFilePathName, String dstFilePathName) throws IOException {
        new File(dstFilePathName).mkdirs();
        File[] file = new File(srcFilePathName).listFiles();
        int i = 0;
        while (i < file.length) {
            File srcFile = file[i];
            String dstPathName = String.valueOf(dstFilePathName) + "/" + srcFile.getName();
            if (srcFile.isFile()) {
                int len;
                FileInputStream input = new FileInputStream(srcFile);
                FileOutputStream output = new FileOutputStream(dstPathName);
                byte[] b = new byte[5120];
                while ((len = input.read(b)) != -1) {
                    output.write(b, 0, len);
                }
                output.flush();
                output.close();
                input.close();
            }
            if (srcFile.isDirectory()) {
                String srcPathName = String.valueOf(srcFilePathName) + "/" + srcFile.getName();
                FileTools.copyDirectiory(srcPathName, dstPathName);
            }
            ++i;
        }
    }

    public static void rename(String path, String suffix) {
        try {
            File file = new File(path);
            File dstFile = new File(String.valueOf(path) + "." + suffix);
            file.renameTo(dstFile);
        }
        catch (Exception e) {
            FileTools.getLogger().error((Object)("rename failure, path = " + path), (Throwable)e);
        }
    }

    public static void close(InputStream stream) {
        try {
            stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(OutputStream stream) {
        try {
            stream.flush();
            stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(Reader reader) {
        try {
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(Writer writer) {
        try {
            writer.flush();
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isFileExisted(String filePathname) {
        boolean existed;
        try {
            File f = new File(filePathname);
            existed = f.isFile();
        }
        catch (Exception e) {
            existed = false;
        }
        return existed;
    }

    public static String removePath(String pathname) {
        int index2;
        String fname = pathname;
        int index1 = pathname.lastIndexOf("/");
        int index = Math.max(index1, index2 = pathname.lastIndexOf("\\"));
        if (index >= 0) {
            fname = pathname.substring(index + 1);
        }
        return fname;
    }

    public static String removeFileName(String pathname) {
        int index2;
        String fname = pathname;
        int index1 = pathname.lastIndexOf("/");
        int index = Math.max(index1, index2 = pathname.lastIndexOf("\\"));
        if (index >= 0) {
            fname = pathname.substring(0, index);
        }
        return fname;
    }

    public static String addTokenToFileName(String pathname, String token) {
        String pname = "";
        String fname = pathname;
        int index = pathname.lastIndexOf(".");
        if (index >= 0) {
            fname = pathname.substring(index);
            pname = pathname.substring(0, index);
        }
        return String.valueOf(pname) + token + fname;
    }

    public static void createFolderNoExist(String dir) {
        File file = new File(dir);
        if (!file.isDirectory() || !file.exists()) {
            FileTools.createFolder(dir);
        }
    }

    public static int createFolder(String dir) {
        File file = new File(dir);
        if (file.mkdirs()) {
            return 0;
        }
        return -1;
    }

    public static String file2String(String filepath) throws UnsupportedEncodingException {
        byte[] b = null;
        try {
            FileInputStream fin = new FileInputStream(filepath);
            int bytelen = fin.available();
            b = new byte[bytelen];
            fin.read(b);
            fin.close();
        }
        catch (Exception e) {
            FileTools.getLogger().error((Object)("read file eorro, dir = " + filepath), (Throwable)e);
            return null;
        }
        return new String(b, "UTF-8");
    }

    public static void copyFile(String srcPathname, String dstfilepathname) throws IOException {
        try {
            String txt = FileTools.file2String(srcPathname);
            FileTools.writeFile(txt, dstfilepathname);
        }
        catch (Exception e) {
            FileTools.getLogger().error((Object)("copyFile eorro!, src path = " + srcPathname + ", dst path = " + dstfilepathname), (Throwable)e);
        }
    }

    public static void writeFile(String str, String dstfilepathname) throws IOException {
        try {
            byte[] t = str.getBytes("UTF-8");
            File ccc = new File(dstfilepathname);
            FileTools.createFolder(ccc.getParent());
            FileTools.makeFile(dstfilepathname);
            FileOutputStream fout = new FileOutputStream(dstfilepathname);
            fout.write(t);
            fout.flush();
            fout.close();
        }
        catch (Exception e) {
            FileTools.getLogger().error((Object)("writeFile error!, str = " + str + ", dst path = " + dstfilepathname), (Throwable)e);
        }
    }

    public static boolean makeFile(String filepath) throws IOException {
        boolean result = false;
        File file = new File(filepath);
        result = file.createNewFile();
        file = null;
        return result;
    }

    public static boolean makeFileByInputStream(String filepath, InputStream inputStream) throws IOException {
        boolean result = false;
        try {
            File file = new File(filepath);
            FileOutputStream bos = new FileOutputStream(file);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = inputStream.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)bos).write(buffer, 0, bytesRead);
            }
            ((OutputStream)bos).close();
            inputStream.close();
            FileTools.getLogger().info((Object)("upload file " + filepath + " success!!!!!!"));
            result = true;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return result;
    }
}

