/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.framework.xtable;

import com.highesthelp.framework.xtable.CustomTableActions;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.view.html.BuilderUtils;
import org.extremecomponents.table.view.html.TableActions;
import org.extremecomponents.table.view.html.ToolbarBuilder;
import org.extremecomponents.table.view.html.toolbar.ButtonItem;
import org.extremecomponents.table.view.html.toolbar.ImageItem;
import org.extremecomponents.table.view.html.toolbar.TextItem;
import org.extremecomponents.table.view.html.toolbar.ToolbarItem;
import org.extremecomponents.table.view.html.toolbar.ToolbarItemUtils;
import org.extremecomponents.util.HtmlBuilder;

public class CustomToolbarBuilder
extends ToolbarBuilder {
    public CustomToolbarBuilder(HtmlBuilder html, TableModel model) {
        super(html, model);
    }

    public void pagesDisplayedDroplist() {
        HtmlBuilder html = this.getHtmlBuilder();
        TableModel model = this.getTableModel();
        int totalPages = BuilderUtils.getTotalPages((TableModel)model);
        int currentPage = model.getLimit().getPage();
        StringBuffer onchange = new StringBuffer();
        onchange.append(new CustomTableActions(model).getPageAction());
        html.select().name("pages").style("width:40px;");
        html.onchange(onchange.toString());
        html.close();
        html.newline();
        html.tabs(4);
        int i = 1;
        while (i <= totalPages) {
            html.option().value(String.valueOf(i));
            if (currentPage == i) {
                html.selected();
            }
            html.close();
            html.append(String.valueOf(i));
            html.optionEnd();
            ++i;
        }
        html.newline();
        html.tabs(4);
        html.selectEnd();
    }

    public void turnToPage(String preText, String afterText, String location) {
        HtmlBuilder html = this.getHtmlBuilder();
        TableModel model = this.getTableModel();
        int totalPages = BuilderUtils.getTotalPages((TableModel)model);
        html.append(preText);
        html.input("text").id("textNum" + location).name("pages1").size("2").value("1").maxlength("3").styleClass("input").onkeypress("if (event.keyCode == 13) {javascript:checkpage(" + totalPages + ",'" + location + "');}").xclose();
        html.append(afterText);
        ButtonItem item7 = new ButtonItem();
        item7.setContents("GO");
        item7.setStyleClass("enter");
        this.buildCurPage(html, model, (ToolbarItem)item7, location);
    }

    public void turnToPage(String preText, String afterText) {
        HtmlBuilder html = this.getHtmlBuilder();
        TableModel model = this.getTableModel();
        int totalPages = BuilderUtils.getTotalPages((TableModel)model);
        html.append(preText);
        html.nbsp();
        html.input("text").id("textNum").name("pages1").size("1").value("1").maxlength("3").styleClass("input").style("vertical-align:middle;").onkeypress("if (event.keyCode == 13) {javascript:checkpage(" + totalPages + ");}").xclose();
        html.nbsp();
        html.append(afterText);
        ButtonItem item7 = new ButtonItem();
        item7.setContents("\u786e\u5b9a");
        item7.setStyleClass("enter");
        this.buildCurPage(html, model, (ToolbarItem)item7);
        html.nbsp();
    }

    public void turnToPageImage(String preText, String afterText) {
        HtmlBuilder html = this.getHtmlBuilder();
        TableModel model = this.getTableModel();
        int totalPages = BuilderUtils.getTotalPages((TableModel)model);
        html.append(preText);
        html.nbsp();
        html.input("text").id("textNum").name("pages1").size("1").value("1").maxlength("3").styleClass("input").style("vertical-align:middle;").onkeypress("if (event.keyCode == 13) {javascript:checkpage(" + totalPages + ");}").xclose();
        html.nbsp();
        html.append(afterText);
        ImageItem item7 = new ImageItem();
        item7.setImage(BuilderUtils.getImage((TableModel)model, (String)"go-1"));
        item7.setDisabledImage(BuilderUtils.getImage((TableModel)model, (String)"go-2"));
        item7.setStyle("border:none;vertical-align:middle;");
        this.buildCurPage(html, model, (ToolbarItem)item7);
        html.nbsp();
    }

    public void jumpPage() {
        HtmlBuilder html = this.getHtmlBuilder();
        html.input("text").id("textNum").name("pages1").size("2").value("1").maxlength("3").xclose();
    }

    public void buildCurPage(HtmlBuilder html, TableModel model, ToolbarItem item, String location) {
        StringBuffer oninput = new StringBuffer();
        oninput.append(new CustomTableActions(model).getPageInputAction(location));
        String action = oninput.toString();
        item.setAction(action);
        int totalPages = BuilderUtils.getTotalPages((TableModel)model);
        if (totalPages < 1) {
            item.disabled(html);
        } else {
            item.enabled(html, model);
        }
    }

    public void buildCurPage(HtmlBuilder html, TableModel model, ToolbarItem item) {
        StringBuffer oninput = new StringBuffer();
        oninput.append(new CustomTableActions(model).getPageInputAction());
        String action = oninput.toString();
        item.setAction(action);
        int totalPages = BuilderUtils.getTotalPages((TableModel)model);
        if (totalPages < 1) {
            item.disabled(html);
        } else {
            item.enabled(html, model);
        }
    }

    public void totalRows() {
        HtmlBuilder html = this.getHtmlBuilder();
        TableModel model = this.getTableModel();
        Integer total = new Integer(model.getLimit().getTotalRows());
        html.append("\u5171\u6709<font color=red>" + total + "</font>\u6761");
    }

    public void RealTotalRows() {
        HtmlBuilder html = this.getHtmlBuilder();
        TableModel model = this.getTableModel();
        String realTotalRows = "0";
        if (model.getContext().getRequestAttribute("real_Total_Count") != null) {
            realTotalRows = model.getContext().getRequestAttribute("real_Total_Count").toString();
        }
        Integer total = new Integer(realTotalRows);
        html.append("\u603b\u5171\u6709<font color=red>" + total + "</font>\u6761\u6570\u636e&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
    }

    public void qtStatus() {
        HtmlBuilder html = this.getHtmlBuilder();
        TableModel model = this.getTableModel();
        if (model.getLimit().getTotalRows() == 0) {
            html.append(model.getMessages().getMessage("statusbar.noResultsFound"));
        } else {
            Integer total = new Integer(model.getLimit().getTotalRows());
            Integer from = new Integer(model.getLimit().getRowStart() + 1);
            Integer to = new Integer(model.getLimit().getRowEnd());
            html.append("\u603b\u5171" + total + "\u6761,\u5217\u51fa\u7b2c" + from + "\u5230\u7b2c" + to + "\u6761");
            html.nbsp();
        }
    }

    public void curTotalPage() {
        HtmlBuilder html = this.getHtmlBuilder();
        TableModel model = this.getTableModel();
        int totalPages = BuilderUtils.getTotalPages((TableModel)model);
        int currentPage = model.getLimit().getPage();
        if (currentPage > totalPages) {
            currentPage = totalPages;
        }
        html.append("\u7b2c" + currentPage + "/" + totalPages + "\u9875");
        html.nbsp();
    }

    public void prevPage(String prevPage) {
        HtmlBuilder html = this.getHtmlBuilder();
        TableModel model = this.getTableModel();
        TextItem item2 = new TextItem();
        item2.setText(prevPage);
        ToolbarItemUtils.buildPrevPage((HtmlBuilder)html, (TableModel)model, (ToolbarItem)item2);
        html.nbsp();
    }

    public void nextPage(String nextPage) {
        HtmlBuilder html = this.getHtmlBuilder();
        TableModel model = this.getTableModel();
        TextItem item3 = new TextItem();
        item3.setTooltip(nextPage);
        item3.setText(nextPage);
        ToolbarItemUtils.buildNextPage((HtmlBuilder)html, (TableModel)model, (ToolbarItem)item3);
        html.nbsp();
    }

    public void displayPages() {
        TableModel model = this.getTableModel();
        int totalPages = BuilderUtils.getTotalPages((TableModel)model);
        int currentPage = model.getLimit().getPage();
        int totalPageGroup = totalPages / 5;
        int yu = totalPages % 5;
        if (totalPages > 0 && totalPages % 5 == 0) {
            --totalPageGroup;
            yu = 5;
        }
        int disPageGroup = currentPage / 5;
        if (currentPage > 0 && currentPage % 5 == 0) {
            --disPageGroup;
        }
        if (disPageGroup < totalPageGroup) {
            int i = 1;
            while (i <= 5) {
                this.displayPage(5 * disPageGroup + i, currentPage);
                ++i;
            }
        } else {
            int i = 1;
            while (i <= yu) {
                this.displayPage(5 * disPageGroup + i, currentPage);
                ++i;
            }
        }
    }

    public void displayPage(int numPage, int currentPage) {
        HtmlBuilder html = this.getHtmlBuilder();
        TableModel model = this.getTableModel();
        TextItem item1 = new TextItem();
        item1.setTooltip("\u7b2c" + numPage + "\u9875");
        item1.setText(Integer.toString(numPage));
        if (numPage == currentPage) {
            html.span().close();
            item1.setText(" " + Integer.toString(numPage) + " ");
            item1.setStyleClass("pageCurrent");
        } else {
            html.span().close();
            item1.setStyleClass("page_number");
        }
        String action = new TableActions(model).getPageAction(numPage);
        item1.setAction(action);
        item1.enabled(html, model);
        html.spanEnd();
        html.nbsp();
    }

    public void separatorLine() {
        HtmlBuilder html = this.getHtmlBuilder();
        html.append("|");
        html.nbsp();
    }

    public void customRowsDisplayedDroplist() {
        HtmlBuilder html = this.getHtmlBuilder();
        TableModel model = this.getTableModel();
        int rowsDisplayed = model.getTableHandler().getTable().getRowsDisplayed();
        int maxRowsDisplayed = model.getTableHandler().getTable().getMaxRowsDisplayed();
        int currentRowsDisplayed = model.getLimit().getCurrentRowsDisplayed();
        html.select().name(String.valueOf(model.getTableHandler().prefixWithTableId()) + "rd").style("width:40px;");
        StringBuffer onchange = new StringBuffer();
        onchange.append(new TableActions(model).getRowsDisplayedAction());
        html.onchange(onchange.toString());
        html.close();
        html.newline();
        html.tabs(4);
        html.option().value(String.valueOf(rowsDisplayed));
        if (currentRowsDisplayed == rowsDisplayed) {
            html.selected();
        }
        html.close();
        html.append(String.valueOf(rowsDisplayed));
        html.optionEnd();
        html.option().value(String.valueOf(maxRowsDisplayed));
        if (currentRowsDisplayed == maxRowsDisplayed) {
            html.selected();
        }
        html.close();
        html.append(String.valueOf(maxRowsDisplayed));
        html.optionEnd();
        html.newline();
        html.tabs(4);
        html.selectEnd();
        html.append("\u6761/\u9875");
    }
}

