/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.framework.xtable;

import org.apache.commons.lang.StringUtils;
import org.extremecomponents.table.bean.Column;
import org.extremecomponents.table.cell.Cell;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.core.TableModelUtils;
import org.extremecomponents.table.view.html.BuilderUtils;
import org.extremecomponents.table.view.html.TableActions;
import org.extremecomponents.util.HtmlBuilder;

public class HHHeadCell
implements Cell {
    public String getExportDisplay(TableModel model, Column column) {
        return column.getTitle();
    }

    public String getHtmlDisplay(TableModel model, Column column) {
        HtmlBuilder html = new HtmlBuilder();
        String headerClass = null;
        String sortImage = null;
        String sortOrder = null;
        headerClass = column.getHeaderClass();
        if (TableModelUtils.isSorted((TableModel)model, (String)column.getAlias())) {
            sortOrder = model.getLimit().getSort().getSortOrder();
            if (sortOrder.equals("default")) {
                sortOrder = "asc";
            } else if (sortOrder.equals("asc")) {
                sortImage = BuilderUtils.getImage((TableModel)model, (String)"sortAsc");
                sortOrder = "desc";
            } else if (sortOrder.equals("desc")) {
                sortImage = BuilderUtils.getImage((TableModel)model, (String)"sortDesc");
                sortOrder = "default";
            }
        } else {
            sortOrder = "asc";
        }
        this.buildHeaderHtml(html, model, column, headerClass, sortImage, sortOrder);
        return html.toString();
    }

    protected void buildHeaderHtml(HtmlBuilder html, TableModel model, Column column, String headerClass, String sortImage, String sortOrder) {
        html.td(2);
        if (StringUtils.isNotEmpty((String)headerClass)) {
            html.styleClass(headerClass);
        }
        if (StringUtils.isNotEmpty((String)column.getHeaderStyle())) {
            html.style(column.getHeaderStyle());
        }
        if (StringUtils.isNotEmpty((String)column.getWidth())) {
            html.width(column.getWidth());
        }
        if (column.isSortable()) {
            if (sortOrder.equals("asc")) {
                if (StringUtils.isNotEmpty((String)headerClass)) {
                    html.onmouseout("this.className='grid_sort_off';this.style.cursor='pointer'");
                    html.onmouseover("this.className='grid_sort_on';this.style.cursor='pointer'");
                } else {
                    html.onmouseout("this.className='grid_sort_off';this.style.cursor='pointer'");
                    html.onmouseover("this.className='grid_sort_on';this.style.cursor='pointer'");
                }
            }
            if (sortOrder.equals("default") || sortOrder.equals("desc")) {
                if (StringUtils.isNotEmpty((String)headerClass)) {
                    html.onmouseout("this.className='grid_sort_off';this.style.cursor='pointer'");
                    html.onmouseover("this.className='grid_sort_on';this.style.cursor='pointer'");
                } else {
                    html.onmouseout("this.className='grid_sort_off';this.style.cursor='pointer'");
                    html.onmouseover("this.className='grid_sort_on';this.style.cursor='pointer'");
                }
            }
            html.onclick(new TableActions(model).getSortAction(column, sortOrder));
            boolean showTooltips = model.getTableHandler().getTable().isShowTooltips();
            if (showTooltips) {
                String headercellTooltip = model.getMessages().getMessage("column.headercell.tooltip.sort");
                html.title(String.valueOf(headercellTooltip) + " " + column.getTitle());
            }
        } else if (StringUtils.isNotEmpty((String)headerClass)) {
            html.onmouseout("this.className='grid_sort_off';this.style.cursor='default'");
            html.onmouseover("this.className='grid_sort_on';this.style.cursor='default'");
        } else {
            html.onmouseout("this.className='grid_sort_off';this.style.cursor='default'");
            html.onmouseover("this.className='grid_sort_on';this.style.cursor='default'");
        }
        html.close();
        html.span().styleClass("grid_head_line").close();
        html.append(column.getTitle());
        html.spanEnd();
        if (column.isSortable() && StringUtils.isNotEmpty((String)sortImage)) {
            html.nbsp();
            html.img();
            html.src(sortImage);
            html.style("border:0");
            html.xclose();
        }
        html.tdEnd();
    }
}

