/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.pdcajob.action;

import com.highesthelp.framework.action.BaseAction;
import com.highesthelp.framework.common.Node;
import com.highesthelp.framework.common.Page;
import com.highesthelp.framework.common.Tree;
import com.highesthelp.framework.exception.CommonException;
import com.highesthelp.framework.exception.DelException;
import com.highesthelp.framework.util.ObjectUtil;
import com.highesthelp.framework.util.StringTools;
import com.highesthelp.pdcajob.form.DepartmentForm;
import com.highesthelp.pdcajob.pojo.Department;
import com.highesthelp.pdcajob.service.DepartmentService;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class DepartmentAction
extends BaseAction {
    private DepartmentService departmentService;

    public ActionForward viewDepartment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DepartmentForm departmentForm = (DepartmentForm)form;
        Department department = this.departmentService.getDepartment(departmentForm.getPk());
        request.setAttribute("departmentPojo", (Object)department);
        return mapping.findForward("departmentView");
    }

    public ActionForward listDepartment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Page page = this.departmentService.getDepartmentPage();
        this.addEmptyRows(new Department(), page, request);
        return mapping.findForward("departmentList");
    }

    public ActionForward addDepartment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DepartmentForm departmentForm = (DepartmentForm)form;
        Department department = new Department();
        department.setName(departmentForm.getName());
        if (departmentForm.getParentPk() == null) {
            department.setParentPk(0);
        } else {
            department.setParentPk(departmentForm.getParentPk());
        }
        department.setCreateTime(StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
        this.departmentService.saveDepartment(department);
        return mapping.findForward("operatortreesuccess");
    }

    public ActionForward updateDepartment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DepartmentForm departmentForm = (DepartmentForm)form;
        Department department = this.departmentService.getDepartment(departmentForm.getPk());
        department.setName(departmentForm.getName());
        this.departmentService.updateDepartment(department);
        return mapping.findForward("operatortreesuccess");
    }

    public ActionForward deleteDepartment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DepartmentForm departmentForm = (DepartmentForm)form;
        String pks = StringTools.Array2String(departmentForm.getSelectPks());
        int list = this.departmentService.getHQLCount("select count(*) from Operator operator where operator.department.pk in(" + pks + ")");
        if (list > 0) {
            throw new DelException();
        }
        this.departmentService.deleteDepartments(departmentForm.getSelectPks());
        return mapping.findForward("operatortreesuccess");
    }

    public ActionForward goAddPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Department department;
        String[] sPk;
        DepartmentForm departmentForm = (DepartmentForm)form;
        if (departmentForm.getSelectPks() != null && StringTools.isNotEmpty(departmentForm.getSelectPks()[0]) && (sPk = departmentForm.getSelectPks()[0].split(",")).length > 0 && (department = this.departmentService.getDepartment(Integer.valueOf(sPk[0]))) != null) {
            departmentForm.setParentPk(Integer.valueOf(sPk[0]));
            departmentForm.setParentName(department.getName());
        }
        return mapping.findForward("departmentAdd");
    }

    public ActionForward goModifyPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Department parentDep;
        DepartmentForm departmentForm = (DepartmentForm)form;
        Department department = null;
        department = departmentForm.getPk() != null ? this.departmentService.getDepartment(departmentForm.getPk()) : this.departmentService.getDepartment(Integer.valueOf(departmentForm.getSelectPks()[0]));
        ObjectUtil.objectPopulate((Object)departmentForm, department);
        Integer pdpk = department.getParentPk();
        if (pdpk != null && (parentDep = this.departmentService.getDepartment(pdpk)) != null) {
            departmentForm.setParentPk(parentDep.getParentPk());
            departmentForm.setParentName(parentDep.getName());
        }
        return mapping.findForward("departmentModify");
    }

    public ActionForward departmentTreeView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List dList = this.departmentService.getList("from Department department");
        Tree tree = new Tree();
        int i = 0;
        while (i < dList.size()) {
            Department department = (Department)dList.get(i);
            String parentPk = "";
            parentPk = department.getParentPk() == null ? Tree.ROOT_ID : department.getParentPk().toString();
            Node node = new Node(department.getPk().toString(), department.getName(), parentPk);
            tree.addNode(node);
            ++i;
        }
        Document document = DocumentHelper.parseText((String)tree.toXMLString());
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("utf-8");
        XMLWriter output = new XMLWriter((OutputStream)response.getOutputStream(), format);
        try {
            response.setContentType("text/xml;charset=utf-8");
            response.setHeader("Cache-Control", "no-cache");
            output.write(document);
            output.close();
        }
        catch (Exception e) {
            throw new CommonException();
        }
        return null;
    }

    public ActionForward departmentSubPks(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer depPk = 2;
        List dList = this.departmentService.getList("from Department dep where dep.parentPk >= " + depPk);
        Tree tree = new Tree();
        Department dep = this.departmentService.getDepartment(depPk);
        tree.addNode(new Node(dep.getPk().toString(), dep.getName(), Tree.ROOT_ID));
        int i = 0;
        while (i < dList.size()) {
            Department department = (Department)dList.get(i);
            Node node = new Node(department.getPk().toString(), department.getName(), department.getParentPk().toString());
            tree.addNode(node);
            ++i;
        }
        String pks = tree.treeSubPks();
        System.out.println(pks);
        return null;
    }

    public DepartmentService getDepartmentService() {
        return this.departmentService;
    }

    public void setDepartmentService(DepartmentService departmentService) {
        this.departmentService = departmentService;
    }
}

