/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.pdcajob.action;

import com.highesthelp.framework.action.BaseAction;
import com.highesthelp.framework.util.ObjectUtil;
import com.highesthelp.framework.util.StringTools;
import com.highesthelp.pdcajob.form.ExperienceForm;
import com.highesthelp.pdcajob.pojo.Experience;
import com.highesthelp.pdcajob.pojo.ListValue;
import com.highesthelp.pdcajob.service.ExperienceService;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ExperienceAction
extends BaseAction {
    private ExperienceService experienceService;

    public ActionForward viewExperience(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExperienceForm experienceForm = (ExperienceForm)form;
        Experience experience = this.experienceService.getExperience(experienceForm.getPk());
        request.setAttribute("experiencePojo", (Object)experience);
        return mapping.findForward("experienceView");
    }

    public ActionForward listExperience(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<ListValue> experienceTypeSelect = this.selectorCache.getListValuesByListClassType("experienceType");
        request.setAttribute("experienceTypeSelect", experienceTypeSelect);
        return mapping.findForward("experienceList");
    }

    public ActionForward addExperience(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExperienceForm experienceForm = (ExperienceForm)form;
        Experience experience = new Experience();
        ObjectUtil.objectPopulate(experience, (Object)experienceForm);
        experience.setCreateTime(StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
        experience.setCreateUser(this.getLoginUser().getRealName());
        this.experienceService.saveExperience(experience);
        return mapping.findForward("experienceListAction");
    }

    public ActionForward updateExperience(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExperienceForm experienceForm = (ExperienceForm)form;
        Experience experience = this.experienceService.getExperience(experienceForm.getPk());
        ObjectUtil.objectPopulate((Object)experience, (Object)experienceForm, true);
        this.experienceService.updateExperience(experience);
        return mapping.findForward("experienceListAction");
    }

    public ActionForward deleteExperience(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExperienceForm experienceForm = (ExperienceForm)form;
        this.experienceService.deleteExperiences(experienceForm.getSelectPks());
        return mapping.findForward("experienceListAction");
    }

    public ActionForward goAddPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<ListValue> experienceTypeSelect = this.selectorCache.getListValuesByListClassType("experienceType");
        request.setAttribute("experienceTypeSelect", experienceTypeSelect);
        return mapping.findForward("experienceAdd");
    }

    public ActionForward goModifyPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<ListValue> experienceTypeSelect = this.selectorCache.getListValuesByListClassType("experienceType");
        request.setAttribute("experienceTypeSelect", experienceTypeSelect);
        ExperienceForm experienceForm = (ExperienceForm)form;
        Experience experience = null;
        experience = experienceForm.getPk() != null ? this.experienceService.getExperience(experienceForm.getPk()) : this.experienceService.getExperience(Integer.valueOf(experienceForm.getSelectPks()[0]));
        ObjectUtil.objectPopulate((Object)experienceForm, experience);
        return mapping.findForward("experienceModify");
    }

    public ExperienceService getExperienceService() {
        return this.experienceService;
    }

    public void setExperienceService(ExperienceService experienceService) {
        this.experienceService = experienceService;
    }
}

