/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.pdcajob.action;

import com.highesthelp.framework.HighestHelpProduct;
import com.highesthelp.framework.action.BaseAction;
import com.highesthelp.framework.common.Page;
import com.highesthelp.framework.util.ObjectUtil;
import com.highesthelp.framework.util.StringTools;
import com.highesthelp.pdcajob.form.MessagesForm;
import com.highesthelp.pdcajob.pojo.Messages;
import com.highesthelp.pdcajob.pojo.MessagesBox;
import com.highesthelp.pdcajob.service.MessagesService;
import com.highesthelp.pdcajob.service.OperatorService;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class MessagesAction
extends BaseAction {
    private MessagesService messagesService;
    private OperatorService operatorService;

    public ActionForward viewMessages(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MessagesForm messagesForm = (MessagesForm)form;
        Messages messages = this.messagesService.getMessages(messagesForm.getPk());
        request.setAttribute("messagesPojo", (Object)messages);
        return mapping.findForward("messagesView");
    }

    public ActionForward listMessages(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Page page = this.messagesService.getMessagesPage();
        this.addEmptyRows(new Messages(), page, request);
        return mapping.findForward("messagesList");
    }

    public ActionForward addMessages(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MessagesForm messagesForm = (MessagesForm)form;
        Messages messages = new Messages();
        String attrFile = this.saveUploadFile(messagesForm.getAttrFile(), HighestHelpProduct.getDataPath());
        messages.setAttrFile(attrFile);
        ObjectUtil.objectPopulate(messages, (Object)messagesForm);
        messages.setCreateTime(StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
        messages.setOperatorByFormUser(this.getLoginUser());
        if (messagesForm.getOperatorPk() != null) {
            messages.setOperatorByToUser(this.operatorService.getOperator(messagesForm.getOperatorPk()));
        }
        messages.setCreateTime(StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
        this.messagesService.saveMessages(messages);
        MessagesBox mb = new MessagesBox();
        mb.setAttrFile(attrFile);
        mb.setContent(messages.getContent());
        mb.setTitle(messages.getTitle());
        mb.setCreateTime(messages.getCreateTime());
        mb.setOperatorByFormUser(this.getLoginUser());
        mb.setOperatorByToUser(messages.getOperatorByToUser());
        mb.setViewIt(MessagesBox.MESSAGESBOX_VIEW_IT_NO);
        mb.setMessageType(MessagesBox.MESSAGESBOX_TYPE_USER);
        mb.setCreateTime(StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
        this.messagesService.saveObject(mb);
        return mapping.findForward("messagesListAction");
    }

    public ActionForward updateMessages(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MessagesForm messagesForm = (MessagesForm)form;
        Messages messages = this.messagesService.getMessages(messagesForm.getPk());
        ObjectUtil.objectPopulate((Object)messages, (Object)messagesForm, true);
        this.messagesService.updateMessages(messages);
        return mapping.findForward("messagesListAction");
    }

    public ActionForward deleteMessages(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MessagesForm messagesForm = (MessagesForm)form;
        this.messagesService.deleteMessagess(messagesForm.getSelectPks());
        return mapping.findForward("messagesListAction");
    }

    public ActionForward goAddPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("messagesAdd");
    }

    public ActionForward goModifyPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MessagesForm messagesForm = (MessagesForm)form;
        Messages messages = null;
        messages = messagesForm.getPk() != null ? this.messagesService.getMessages(messagesForm.getPk()) : this.messagesService.getMessages(Integer.valueOf(messagesForm.getSelectPks()[0]));
        ObjectUtil.objectPopulate((Object)messagesForm, messages);
        return mapping.findForward("messagesModify");
    }

    public MessagesService getMessagesService() {
        return this.messagesService;
    }

    public void setMessagesService(MessagesService messagesService) {
        this.messagesService = messagesService;
    }

    public OperatorService getOperatorService() {
        return this.operatorService;
    }

    public void setOperatorService(OperatorService operatorService) {
        this.operatorService = operatorService;
    }
}

