/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.pdcajob.action;

import com.highesthelp.framework.action.BaseAction;
import com.highesthelp.framework.common.Page;
import com.highesthelp.framework.util.ObjectUtil;
import com.highesthelp.framework.util.StringTools;
import com.highesthelp.pdcajob.form.NoticeForm;
import com.highesthelp.pdcajob.pojo.Notice;
import com.highesthelp.pdcajob.service.NoticeService;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class NoticeAction
extends BaseAction {
    private NoticeService noticeService;

    public ActionForward viewNotice(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NoticeForm noticeForm = (NoticeForm)form;
        Notice notice = this.noticeService.getNotice(noticeForm.getPk());
        request.setAttribute("noticePojo", (Object)notice);
        return mapping.findForward("noticeView");
    }

    public ActionForward listNotice(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Page page = this.noticeService.getNoticePage();
        this.addEmptyRows(new Notice(), page, request);
        return mapping.findForward("noticeList");
    }

    public ActionForward addNotice(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NoticeForm noticeForm = (NoticeForm)form;
        Notice notice = new Notice();
        ObjectUtil.objectPopulate(notice, (Object)noticeForm);
        notice.setCreateTime(StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
        this.noticeService.saveNotice(notice);
        return mapping.findForward("noticeListAction");
    }

    public ActionForward updateNotice(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NoticeForm noticeForm = (NoticeForm)form;
        Notice notice = this.noticeService.getNotice(noticeForm.getPk());
        ObjectUtil.objectPopulate((Object)notice, (Object)noticeForm, true);
        this.noticeService.updateNotice(notice);
        return mapping.findForward("noticeListAction");
    }

    public ActionForward deleteNotice(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NoticeForm noticeForm = (NoticeForm)form;
        this.noticeService.deleteNotices(noticeForm.getSelectPks());
        return mapping.findForward("noticeListAction");
    }

    public ActionForward goAddPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("noticeAdd");
    }

    public ActionForward goModifyPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NoticeForm noticeForm = (NoticeForm)form;
        Notice notice = null;
        notice = noticeForm.getPk() != null ? this.noticeService.getNotice(noticeForm.getPk()) : this.noticeService.getNotice(Integer.valueOf(noticeForm.getSelectPks()[0]));
        ObjectUtil.objectPopulate((Object)noticeForm, notice);
        return mapping.findForward("noticeModify");
    }

    public NoticeService getNoticeService() {
        return this.noticeService;
    }

    public void setNoticeService(NoticeService noticeService) {
        this.noticeService = noticeService;
    }
}

