/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.pdcajob.action;

import com.highesthelp.framework.HighestHelpProduct;
import com.highesthelp.framework.acl.CacheResources;
import com.highesthelp.framework.action.BaseAction;
import com.highesthelp.framework.common.Md5Encrypt;
import com.highesthelp.framework.common.Node;
import com.highesthelp.framework.common.Page;
import com.highesthelp.framework.common.Tree;
import com.highesthelp.framework.exception.CommonException;
import com.highesthelp.framework.form.BaseForm;
import com.highesthelp.framework.jdbc.Db;
import com.highesthelp.framework.util.ObjectUtil;
import com.highesthelp.framework.util.StringTools;
import com.highesthelp.pdcajob.form.OperatorForm;
import com.highesthelp.pdcajob.pojo.Department;
import com.highesthelp.pdcajob.pojo.ListValue;
import com.highesthelp.pdcajob.pojo.Operator;
import com.highesthelp.pdcajob.pojo.OperatorRole;
import com.highesthelp.pdcajob.pojo.Resource;
import com.highesthelp.pdcajob.pojo.Role;
import com.highesthelp.pdcajob.service.OperatorService;
import com.highesthelp.pdcajob.service.RoleService;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class OperatorAction
extends BaseAction {
    private OperatorService operatorService;
    private Md5Encrypt md5Encrypt;
    private RoleService roleService;

    public ActionForward viewOperator(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OperatorForm operatorForm = (OperatorForm)form;
        Operator operator = this.operatorService.getOperator(operatorForm.getPk());
        request.setAttribute("operatorPojo", (Object)operator);
        List operatorRoleList = this.operatorService.getList("from OperatorRole orole where orole.operator.pk = " + operator.getPk());
        ArrayList<Role> userRolesSelect = new ArrayList<Role>();
        int i = 0;
        while (i < operatorRoleList.size()) {
            OperatorRole or = (OperatorRole)operatorRoleList.get(i);
            Role r = or.getRole();
            if (r != null) {
                userRolesSelect.add(r);
            }
            ++i;
        }
        request.setAttribute("userRolesSelect", userRolesSelect);
        return mapping.findForward("operatorView");
    }

    public ActionForward listOperator(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OperatorForm operatorForm = (OperatorForm)form;
        Page page = this.operatorService.getOperatorPage();
        this.addEmptyRows(new Operator(), page, request);
        if (operatorForm.getListItem() != null && operatorForm.getListItem() == 1) {
            return mapping.findForward("operatorListselect");
        }
        if (operatorForm.getListItem() != null && operatorForm.getListItem() == 2) {
            return mapping.findForward("addresslist");
        }
        return mapping.findForward("operatorList");
    }

    public ActionForward addOperator(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OperatorForm operatorForm = (OperatorForm)form;
        List list = this.operatorService.getList("from Operator operator where operator.name=?", new String[]{operatorForm.getName()});
        if (list.size() > 0) {
            request.setAttribute("nameExiste", (Object)true);
            return mapping.findForward("goOperatorAdd");
        }
        Operator operator = new Operator();
        String photoFile = this.saveUploadFile(operatorForm.getPhotoFile(), HighestHelpProduct.getDataPath());
        operator.setPhotoFile(photoFile);
        ObjectUtil.objectPopulate(operator, (Object)operatorForm);
        if (operatorForm.getDepartmentPk() != null) {
            Department department = (Department)this.operatorService.getObject(new Department(), operatorForm.getDepartmentPk());
            operator.setDepartment(department);
        }
        operator.setLeverFlag(0);
        operator.setPassWord(this.md5Encrypt.Encrypt(operatorForm.getPassWord()));
        operator.setCreateTime(StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
        operator.setCreateUser(this.getLoginUser().getPk());
        operator.setDelIt(BaseForm.ITEM_DEL_NO);
        this.operatorService.saveOperator(operator);
        Integer[] roles = operatorForm.getSelectedRoles();
        if (roles != null) {
            int i = 0;
            while (i < roles.length) {
                Role role = this.roleService.getRole(roles[i]);
                OperatorRole operatorRole = new OperatorRole();
                operatorRole.setOperator(operator);
                operatorRole.setRole(role);
                this.operatorService.saveObject(operatorRole);
                ++i;
            }
        }
        return mapping.findForward("operatorsuccess");
    }

    public ActionForward updateOperator(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OperatorForm operatorForm = (OperatorForm)form;
        Operator operator = this.operatorService.getOperator(operatorForm.getPk());
        String oldPassword = operator.getPassWord();
        ObjectUtil.objectPopulate((Object)operator, (Object)operatorForm, true);
        if (operatorForm.getDepartmentPk() != null) {
            Department department = (Department)this.operatorService.getObject(new Department(), operatorForm.getDepartmentPk());
            operator.setDepartment(department);
        }
        if (StringTools.isNotEmpty(operatorForm.getPassWord())) {
            operator.setPassWord(this.md5Encrypt.Encrypt(operatorForm.getPassWord()));
        } else {
            operator.setPassWord(oldPassword);
        }
        this.operatorService.updateOperator(operator);
        this.roleService.executeHQL("delete from OperatorRole orole where orole.operator.pk = " + operator.getPk());
        Integer[] roles = operatorForm.getSelectedRoles();
        if (roles != null) {
            int i = 0;
            while (i < roles.length) {
                Role role = this.roleService.getRole(roles[i]);
                OperatorRole operatorRole = new OperatorRole();
                operatorRole.setOperator(operator);
                operatorRole.setRole(role);
                this.operatorService.saveObject(operatorRole);
                ++i;
            }
        }
        return mapping.findForward("operatorsuccess");
    }

    public ActionForward deleteOperator(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OperatorForm operatorForm = (OperatorForm)form;
        String pks = StringTools.Array2String(operatorForm.getSelectPks());
        if (StringTools.isNotEmpty(pks)) {
            this.operatorService.executeHQL("update Operator operator set operator.delIt = " + BaseForm.ITEM_DEL_YES + " where operator.pk in(" + pks + ")");
        }
        return mapping.findForward("operatorsuccess");
    }

    public ActionForward goAddPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<ListValue> enabledTypeSelect = this.selectorCache.getListValuesByListClassType("enabledType");
        request.setAttribute("enabledTypeSelect", enabledTypeSelect);
        List<ListValue> politicsTypeSelect = this.selectorCache.getListValuesByListClassType("politicsType");
        request.setAttribute("politicsTypeSelect", politicsTypeSelect);
        List<ListValue> eduTypeSelect = this.selectorCache.getListValuesByListClassType("eduType");
        request.setAttribute("eduTypeSelect", eduTypeSelect);
        List<ListValue> jobTypeSelect = this.selectorCache.getListValuesByListClassType("jobType");
        request.setAttribute("jobTypeSelect", jobTypeSelect);
        List<ListValue> provinceTypeSelect = this.selectorCache.getListValuesByListClassType("provinceType");
        request.setAttribute("provinceTypeSelect", provinceTypeSelect);
        List<ListValue> cityTypeSelect = this.selectorCache.getListValuesByListClassType("cityType");
        request.setAttribute("cityTypeSelect", cityTypeSelect);
        List<ListValue> sexTypeSelect = this.selectorCache.getListValuesByListClassType("sexType");
        request.setAttribute("sexTypeSelect", sexTypeSelect);
        List dList = this.operatorService.getList("from Department department");
        this.setDepartmentTreeInRequest(request, dList, "departments");
        List sysRolesList = this.operatorService.getList("from Role");
        int j = 0;
        while (j < sysRolesList.size()) {
            Role role = (Role)sysRolesList.get(j);
            role.setName(String.valueOf(role.getName()) + "(" + role.getRemarks() + ")");
            ++j;
        }
        request.setAttribute("sysRolesSelect", (Object)sysRolesList);
        return mapping.findForward("operatorAdd");
    }

    public ActionForward goModifyPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Department dep;
        List<ListValue> enabledTypeSelect = this.selectorCache.getListValuesByListClassType("enabledType");
        request.setAttribute("enabledTypeSelect", enabledTypeSelect);
        List<ListValue> politicsTypeSelect = this.selectorCache.getListValuesByListClassType("politicsType");
        request.setAttribute("politicsTypeSelect", politicsTypeSelect);
        List<ListValue> eduTypeSelect = this.selectorCache.getListValuesByListClassType("eduType");
        request.setAttribute("eduTypeSelect", eduTypeSelect);
        List<ListValue> jobTypeSelect = this.selectorCache.getListValuesByListClassType("jobType");
        request.setAttribute("jobTypeSelect", jobTypeSelect);
        List<ListValue> provinceTypeSelect = this.selectorCache.getListValuesByListClassType("provinceType");
        request.setAttribute("provinceTypeSelect", provinceTypeSelect);
        List<ListValue> cityTypeSelect = this.selectorCache.getListValuesByListClassType("cityType");
        request.setAttribute("cityTypeSelect", cityTypeSelect);
        List<ListValue> sexTypeSelect = this.selectorCache.getListValuesByListClassType("sexType");
        request.setAttribute("sexTypeSelect", sexTypeSelect);
        OperatorForm operatorForm = (OperatorForm)form;
        Operator operator = null;
        operator = operatorForm.getPk() != null ? this.operatorService.getOperator(operatorForm.getPk()) : this.operatorService.getOperator(Integer.valueOf(operatorForm.getSelectPks()[0]));
        ObjectUtil.objectPopulate((Object)operatorForm, operator);
        List dList = this.operatorService.getList("from Department department");
        this.setDepartmentTreeInRequest(request, dList, "departments");
        if (operator != null && (dep = operator.getDepartment()) != null) {
            operatorForm.setDepartmentPk(dep.getPk());
        }
        operatorForm.setPassWord("");
        List sysRolesList = this.operatorService.getList("from Role");
        int j = 0;
        while (j < sysRolesList.size()) {
            Role role = (Role)sysRolesList.get(j);
            role.setName(String.valueOf(role.getName()) + "(" + role.getRemarks() + ")");
            ++j;
        }
        request.setAttribute("sysRolesSelect", (Object)sysRolesList);
        List operatorRoleList = this.operatorService.getList("from OperatorRole orole where orole.operator.pk = " + operator.getPk());
        ArrayList<Role> userRolesSelect = new ArrayList<Role>();
        int i = 0;
        while (i < operatorRoleList.size()) {
            OperatorRole or = (OperatorRole)operatorRoleList.get(i);
            Role r = or.getRole();
            if (r != null) {
                userRolesSelect.add(r);
            }
            ++i;
        }
        request.setAttribute("userRolesSelect", userRolesSelect);
        return mapping.findForward("operatorModify");
    }

    public ActionForward userTreeView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Node node;
        Tree tree = new Tree();
        List dList = this.operatorService.getList("from Department department");
        int i = 0;
        while (i < dList.size()) {
            Department department = (Department)dList.get(i);
            String parentPk = "";
            parentPk = department.getParentPk() == null ? Tree.ROOT_ID : department.getParentPk().toString();
            node = new Node(department.getPk().toString(), department.getName(), parentPk);
            tree.addNode(node);
            ++i;
        }
        List uList = this.operatorService.getList("from Operator user where user.leverFlag != 1 and user.delIt = " + BaseForm.ITEM_DEL_NO);
        int i2 = 0;
        while (i2 < uList.size()) {
            Operator user = (Operator)uList.get(i2);
            node = new Node("u_" + user.getPk().toString(), user.getRealName(), user.getDepartment().getPk().toString(), "user.gif");
            tree.addNode(node);
            ++i2;
        }
        Document document = DocumentHelper.parseText((String)tree.toXMLString());
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("utf-8");
        XMLWriter output = new XMLWriter((OutputStream)response.getOutputStream(), format);
        try {
            response.setContentType("text/xml;charset=utf-8");
            response.setHeader("Cache-Control", "no-cache");
            output.write(document);
            output.close();
        }
        catch (Exception e) {
            throw new CommonException();
        }
        return null;
    }

    public ActionForward goAuthPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OperatorForm operatorForm = (OperatorForm)form;
        List list = this.operatorService.getList("from ResourceClass rc where rc.innerRes = 0 order by rc.sort asc");
        request.setAttribute("RC", (Object)list);
        if (operatorForm.getPk() != null && operatorForm.getPk() != 0) {
            Operator user = this.operatorService.getOperator(operatorForm.getPk());
            if (user != null) {
                operatorForm.setName(user.getName());
                operatorForm.setRealName(user.getRealName());
                request.setAttribute("selecteduser", (Object)true);
                ArrayList<Resource> resources = new ArrayList<Resource>();
                Db db = new Db();
                Connection conn = Db.getConnection();
                Statement sm = conn.createStatement();
                ResultSet rs = sm.executeQuery("select res.* from operator_resource as operes left join resource as res on operes.resource = res.pk where operes.operator = " + user.getPk());
                while (rs.next()) {
                    Resource resource = new Resource();
                    resource.setDescription(rs.getString("description"));
                    resource.setInnerRes(rs.getInt("inner_res"));
                    resource.setPk(rs.getInt("pk"));
                    resource.setName(rs.getString("name"));
                    resources.add(resource);
                }
                CacheResources cache = new CacheResources();
                cache.initResources(resources);
                request.setAttribute("cache", (Object)cache);
                sm.close();
                conn.close();
            }
        } else {
            request.setAttribute("noselecteduser", (Object)true);
        }
        return mapping.findForward("operatorAuthPage");
    }

    public ActionForward assignAuth(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String prefix = "us_";
        Enumeration pns = request.getParameterNames();
        OperatorForm operatorForm = (OperatorForm)form;
        Operator user = this.operatorService.getOperator(operatorForm.getPk());
        Db db = new Db();
        Connection conn = Db.getConnection();
        Statement sm = conn.createStatement();
        sm.executeUpdate("delete from operator_resource where operator = " + user.getPk());
        sm.close();
        PreparedStatement ps = conn.prepareStatement("insert into operator_resource(operator,resource) values(?,?)");
        while (pns.hasMoreElements()) {
            String key = (String)pns.nextElement();
            if (!key.startsWith(prefix)) continue;
            ps.setInt(1, user.getPk());
            ps.setInt(2, Integer.valueOf(key.replace(prefix, "")));
            ps.addBatch();
        }
        ps.executeBatch();
        ps.close();
        List list = this.operatorService.getList("from ResourceClass rc where rc.innerRes = 0 order by rc.sort asc");
        request.setAttribute("RC", (Object)list);
        if (operatorForm.getPk() != null && operatorForm.getPk() != 0) {
            Operator ouser = this.operatorService.getOperator(operatorForm.getPk());
            if (ouser != null) {
                operatorForm.setName(ouser.getName());
                operatorForm.setRealName(ouser.getRealName());
                request.setAttribute("selecteduserok", (Object)true);
                ArrayList<Resource> resources = new ArrayList<Resource>();
                Statement smm = conn.createStatement();
                ResultSet rs = smm.executeQuery("select res.* from operator_resource as operes left join resource as res on operes.resource = res.pk where operes.operator = " + user.getPk());
                while (rs.next()) {
                    Resource resource = new Resource();
                    resource.setDescription(rs.getString("description"));
                    resource.setInnerRes(rs.getInt("inner_res"));
                    resource.setPk(rs.getInt("pk"));
                    resource.setName(rs.getString("name"));
                    resources.add(resource);
                }
                CacheResources cache = new CacheResources();
                cache.initResources(resources);
                request.setAttribute("cache", (Object)cache);
                smm.close();
            }
        } else {
            request.setAttribute("selecteduserfailture", (Object)true);
        }
        conn.close();
        return mapping.findForward("operatorAuthPage");
    }

    public ActionForward goUpdatePassPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Department dep;
        List<ListValue> enabledTypeSelect = this.selectorCache.getListValuesByListClassType("enabledType");
        request.setAttribute("enabledTypeSelect", enabledTypeSelect);
        List<ListValue> politicsTypeSelect = this.selectorCache.getListValuesByListClassType("politicsType");
        request.setAttribute("politicsTypeSelect", politicsTypeSelect);
        List<ListValue> eduTypeSelect = this.selectorCache.getListValuesByListClassType("eduType");
        request.setAttribute("eduTypeSelect", eduTypeSelect);
        List<ListValue> jobTypeSelect = this.selectorCache.getListValuesByListClassType("jobType");
        request.setAttribute("jobTypeSelect", jobTypeSelect);
        List<ListValue> provinceTypeSelect = this.selectorCache.getListValuesByListClassType("provinceType");
        request.setAttribute("provinceTypeSelect", provinceTypeSelect);
        List<ListValue> cityTypeSelect = this.selectorCache.getListValuesByListClassType("cityType");
        request.setAttribute("cityTypeSelect", cityTypeSelect);
        List<ListValue> sexTypeSelect = this.selectorCache.getListValuesByListClassType("sexType");
        request.setAttribute("sexTypeSelect", sexTypeSelect);
        OperatorForm operatorForm = (OperatorForm)form;
        Operator operator = this.getLoginUser();
        ObjectUtil.objectPopulate((Object)operatorForm, operator);
        List dList = this.operatorService.getList("from Department department");
        this.setDepartmentTreeInRequest(request, dList, "departments");
        if (operator != null && (dep = operator.getDepartment()) != null) {
            operatorForm.setDepartmentPk(dep.getPk());
        }
        operatorForm.setPassWord("");
        return mapping.findForward("updatePassWordPage");
    }

    public ActionForward updatePassWord(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OperatorForm operatorForm = (OperatorForm)form;
        Operator operator = this.getLoginUser();
        String oldPassword = operator.getPassWord();
        ObjectUtil.objectPopulate((Object)operator, (Object)operatorForm, true);
        if (operatorForm.getDepartmentPk() != null) {
            Department department = (Department)this.operatorService.getObject(new Department(), operatorForm.getDepartmentPk());
            operator.setDepartment(department);
        }
        if (StringTools.isNotEmpty(operatorForm.getPassWord())) {
            operator.setPassWord(this.md5Encrypt.Encrypt(operatorForm.getPassWord()));
        } else {
            operator.setPassWord(oldPassword);
        }
        this.operatorService.updateOperator(operator);
        operatorForm.setPassWord("");
        request.setAttribute("passwordok", (Object)true);
        return mapping.findForward("goUpdatePassPage");
    }

    public OperatorService getOperatorService() {
        return this.operatorService;
    }

    public void setOperatorService(OperatorService operatorService) {
        this.operatorService = operatorService;
    }

    public Md5Encrypt getMd5Encrypt() {
        return this.md5Encrypt;
    }

    public void setMd5Encrypt(Md5Encrypt md5Encrypt) {
        this.md5Encrypt = md5Encrypt;
    }

    public RoleService getRoleService() {
        return this.roleService;
    }

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }
}

