/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.pdcajob.action;

import com.highesthelp.framework.HighestHelpProduct;
import com.highesthelp.framework.action.BaseAction;
import com.highesthelp.framework.common.Config;
import com.highesthelp.framework.common.Page;
import com.highesthelp.framework.form.BaseForm;
import com.highesthelp.framework.util.ObjectUtil;
import com.highesthelp.framework.util.StringTools;
import com.highesthelp.pdcajob.form.PlanForm;
import com.highesthelp.pdcajob.pojo.ListValue;
import com.highesthelp.pdcajob.pojo.Plan;
import com.highesthelp.pdcajob.pojo.PlanChangeHistory;
import com.highesthelp.pdcajob.pojo.Task;
import com.highesthelp.pdcajob.service.PlanService;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class PlanAction
extends BaseAction {
    private PlanService planService;

    public ActionForward viewPlan(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Plan parentPlan;
        List<ListValue> planTypeSelect = this.selectorCache.getListValuesByListClassType("planType");
        request.setAttribute("planTypeSelect", planTypeSelect);
        List<ListValue> qualityStatusTypeSelect = this.selectorCache.getListValuesByListClassType("qualityStatusType");
        request.setAttribute("qualityStatusTypeSelect", qualityStatusTypeSelect);
        PlanForm planForm = (PlanForm)form;
        Plan plan = this.planService.getPlan(planForm.getPk());
        if (plan.getParent() != null && (parentPlan = this.planService.getPlan(plan.getParent())) != null) {
            planForm.setPlanCode(parentPlan.getCode());
            planForm.setPlanPk(parentPlan.getPk());
            planForm.setPlanName(parentPlan.getName());
            planForm.setParentCode(parentPlan.getCode());
        }
        request.setAttribute("planPojo", (Object)plan);
        if (planForm.getViewPath() != null && planForm.getViewPath() == 1) {
            planForm.setNext(plan.getNext());
            planForm.setSummary(plan.getSummary());
            planForm.setScore(plan.getScore());
            planForm.setQualityStatusType(plan.getQualityStatusType());
            int taskNoDoneCount = this.planService.getHQLCount("select count(*) from Task task where task.plan.pk=" + plan.getPk() + " and task.taskStatusType<" + Task.TASK_STATUS_DONE);
            request.setAttribute("taskNoDoneCount", (Object)taskNoDoneCount);
            return mapping.findForward("planSummary");
        }
        return mapping.findForward("planView");
    }

    public ActionForward summaryPlan(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PlanForm planForm = (PlanForm)form;
        Plan plan = this.planService.getPlan(planForm.getPk());
        plan.setQualityStatusType(planForm.getQualityStatusType());
        plan.setScore(planForm.getScore());
        plan.setSummary(planForm.getSummary());
        plan.setNext(planForm.getNext());
        this.planService.updatePlan(plan);
        request.setAttribute("planPojo", (Object)plan);
        return mapping.findForward("planView");
    }

    public ActionForward listPlan(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PlanForm planForm = (PlanForm)form;
        List<ListValue> planTypeSelect = this.selectorCache.getListValuesByListClassType("planType");
        request.setAttribute("planTypeSelect", planTypeSelect);
        List<ListValue> qualityStatusTypeSelect = this.selectorCache.getListValuesByListClassType("qualityStatusType");
        request.setAttribute("qualityStatusTypeSelect", qualityStatusTypeSelect);
        Page page = this.planService.getPlanPage();
        this.addEmptyRows(new Plan(), page, request);
        if (planForm.getViewPath() != null && planForm.getViewPath() == 1) {
            return mapping.findForward("planListSelect");
        }
        return mapping.findForward("planList");
    }

    public ActionForward addPlan(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Plan parentPlan;
        int planCount = this.planService.getHQLCount("select count(*) from Plan plan");
        if (planCount >= 50) {
            this.checkRegSystem();
        }
        PlanForm planForm = (PlanForm)form;
        Plan plan = new Plan();
        String attrFile = this.saveUploadFile(planForm.getAttrFile(), HighestHelpProduct.getDataPath());
        plan.setAttrFile(attrFile);
        ObjectUtil.objectPopulate(plan, (Object)planForm);
        plan.setCreateTime(StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
        plan.setOperator(this.getLoginUser());
        if (planForm.getPlanPk() != null && (parentPlan = this.planService.getPlan(planForm.getPlanPk())) != null) {
            plan.setParent(parentPlan.getPk());
        }
        plan.setDelIt(BaseForm.ITEM_DEL_NO);
        this.planService.savePlan(plan);
        return mapping.findForward("planListAction");
    }

    public ActionForward updatePlan(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Plan parentPlan;
        PlanForm planForm = (PlanForm)form;
        Plan plan = this.planService.getPlan(planForm.getPk());
        PlanChangeHistory pch = new PlanChangeHistory();
        ObjectUtil.objectPopulate((Object)pch, (Object)plan, true);
        pch.setCreateTime(StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
        pch.setReason(planForm.getReason());
        pch.setOperator(this.getLoginUser());
        this.planService.saveObject(pch);
        String attrFile = this.saveUploadFile(planForm.getAttrFile(), HighestHelpProduct.getDataPath());
        if (StringTools.isNotEmpty(attrFile)) {
            plan.setAttrFile(attrFile);
        }
        ObjectUtil.objectPopulate((Object)plan, (Object)planForm, true);
        if (planForm.getPlanPk() != null && (parentPlan = this.planService.getPlan(planForm.getPlanPk())) != null) {
            plan.setParent(parentPlan.getPk());
        }
        this.planService.updatePlan(plan);
        return mapping.findForward("planListAction");
    }

    public ActionForward deletePlan(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PlanForm planForm = (PlanForm)form;
        String pks = StringTools.Array2String(planForm.getSelectPks());
        if (StringTools.isNotEmpty(pks)) {
            this.planService.executeHQL("update Plan plan set plan.delIt = " + BaseForm.ITEM_DEL_YES);
        }
        return mapping.findForward("planListAction");
    }

    public ActionForward goAddPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<ListValue> planTypeSelect = this.selectorCache.getListValuesByListClassType("planType");
        request.setAttribute("planTypeSelect", planTypeSelect);
        List<ListValue> qualityStatusTypeSelect = this.selectorCache.getListValuesByListClassType("qualityStatusType");
        request.setAttribute("qualityStatusTypeSelect", qualityStatusTypeSelect);
        PlanForm planForm = (PlanForm)form;
        planForm.setCode(Config.getUniquePk("P"));
        return mapping.findForward("planAdd");
    }

    public ActionForward goModifyPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Plan parentPlan;
        List<ListValue> planTypeSelect = this.selectorCache.getListValuesByListClassType("planType");
        request.setAttribute("planTypeSelect", planTypeSelect);
        List<ListValue> qualityStatusTypeSelect = this.selectorCache.getListValuesByListClassType("qualityStatusType");
        request.setAttribute("qualityStatusTypeSelect", qualityStatusTypeSelect);
        PlanForm planForm = (PlanForm)form;
        Plan plan = null;
        plan = planForm.getPk() != null ? this.planService.getPlan(planForm.getPk()) : this.planService.getPlan(Integer.valueOf(planForm.getSelectPks()[0]));
        ObjectUtil.objectPopulate((Object)planForm, plan);
        if (plan.getParent() != null && (parentPlan = this.planService.getPlan(plan.getParent())) != null) {
            planForm.setPlanCode(parentPlan.getCode());
            planForm.setPlanPk(parentPlan.getPk());
            planForm.setPlanName(parentPlan.getName());
            planForm.setParentCode(parentPlan.getCode());
        }
        return mapping.findForward("planModify");
    }

    public PlanService getPlanService() {
        return this.planService;
    }

    public void setPlanService(PlanService planService) {
        this.planService = planService;
    }
}

