/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.pdcajob.action;

import com.highesthelp.framework.HighestHelpProduct;
import com.highesthelp.framework.action.BaseAction;
import com.highesthelp.framework.common.Page;
import com.highesthelp.framework.util.ObjectUtil;
import com.highesthelp.framework.util.StringTools;
import com.highesthelp.pdcajob.form.PlanChangeHistoryForm;
import com.highesthelp.pdcajob.pojo.ListValue;
import com.highesthelp.pdcajob.pojo.Plan;
import com.highesthelp.pdcajob.pojo.PlanChangeHistory;
import com.highesthelp.pdcajob.service.PlanChangeHistoryService;
import com.highesthelp.pdcajob.service.PlanService;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class PlanChangeHistoryAction
extends BaseAction {
    private PlanChangeHistoryService planChangeHistoryService;
    private PlanService planService;

    public ActionForward viewPlanChangeHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Plan parentPlan;
        PlanChangeHistoryForm planChangeHistoryForm = (PlanChangeHistoryForm)form;
        PlanChangeHistory planChangeHistory = this.planChangeHistoryService.getPlanChangeHistory(planChangeHistoryForm.getPk());
        if (planChangeHistory.getParent() != null && (parentPlan = this.planService.getPlan(planChangeHistory.getParent())) != null) {
            planChangeHistory.setParentName(parentPlan.getName());
            planChangeHistory.setParentCode(parentPlan.getCode());
        }
        request.setAttribute("planChangeHistoryPojo", (Object)planChangeHistory);
        return mapping.findForward("planChangeHistoryView");
    }

    public ActionForward listPlanChangeHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Page page = this.planChangeHistoryService.getPlanChangeHistoryPage();
        this.addEmptyRows(new PlanChangeHistory(), page, request, false);
        return mapping.findForward("planChangeHistoryList");
    }

    public ActionForward addPlanChangeHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PlanChangeHistoryForm planChangeHistoryForm = (PlanChangeHistoryForm)form;
        PlanChangeHistory planChangeHistory = new PlanChangeHistory();
        String attrFile = this.saveUploadFile(planChangeHistoryForm.getAttrFile(), HighestHelpProduct.getDataPath());
        planChangeHistory.setAttrFile(attrFile);
        ObjectUtil.objectPopulate(planChangeHistory, (Object)planChangeHistoryForm);
        planChangeHistory.setCreateTime(StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
        planChangeHistory.setOperator(this.getLoginUser());
        this.planChangeHistoryService.savePlanChangeHistory(planChangeHistory);
        return mapping.findForward("planChangeHistoryListAction");
    }

    public ActionForward updatePlanChangeHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PlanChangeHistoryForm planChangeHistoryForm = (PlanChangeHistoryForm)form;
        PlanChangeHistory planChangeHistory = this.planChangeHistoryService.getPlanChangeHistory(planChangeHistoryForm.getPk());
        ObjectUtil.objectPopulate((Object)planChangeHistory, (Object)planChangeHistoryForm, true);
        this.planChangeHistoryService.updatePlanChangeHistory(planChangeHistory);
        return mapping.findForward("planChangeHistoryListAction");
    }

    public ActionForward deletePlanChangeHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PlanChangeHistoryForm planChangeHistoryForm = (PlanChangeHistoryForm)form;
        this.planChangeHistoryService.deletePlanChangeHistorys(planChangeHistoryForm.getSelectPks());
        return mapping.findForward("planChangeHistoryListAction");
    }

    public ActionForward goAddPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<ListValue> planTypeSelect = this.selectorCache.getListValuesByListClassType("planType");
        request.setAttribute("planTypeSelect", planTypeSelect);
        return mapping.findForward("planChangeHistoryAdd");
    }

    public ActionForward goModifyPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<ListValue> planTypeSelect = this.selectorCache.getListValuesByListClassType("planType");
        request.setAttribute("planTypeSelect", planTypeSelect);
        PlanChangeHistoryForm planChangeHistoryForm = (PlanChangeHistoryForm)form;
        PlanChangeHistory planChangeHistory = null;
        planChangeHistory = planChangeHistoryForm.getPk() != null ? this.planChangeHistoryService.getPlanChangeHistory(planChangeHistoryForm.getPk()) : this.planChangeHistoryService.getPlanChangeHistory(Integer.valueOf(planChangeHistoryForm.getSelectPks()[0]));
        ObjectUtil.objectPopulate((Object)planChangeHistoryForm, planChangeHistory);
        return mapping.findForward("planChangeHistoryModify");
    }

    public PlanChangeHistoryService getPlanChangeHistoryService() {
        return this.planChangeHistoryService;
    }

    public void setPlanChangeHistoryService(PlanChangeHistoryService planChangeHistoryService) {
        this.planChangeHistoryService = planChangeHistoryService;
    }

    public PlanService getPlanService() {
        return this.planService;
    }

    public void setPlanService(PlanService planService) {
        this.planService = planService;
    }
}

