/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.pdcajob.action;

import com.highesthelp.framework.action.BaseAction;
import com.highesthelp.framework.common.Page;
import com.highesthelp.framework.util.ObjectUtil;
import com.highesthelp.framework.util.StringTools;
import com.highesthelp.pdcajob.form.PlanCheckHistoryForm;
import com.highesthelp.pdcajob.pojo.Plan;
import com.highesthelp.pdcajob.pojo.PlanCheckHistory;
import com.highesthelp.pdcajob.service.PlanCheckHistoryService;
import com.highesthelp.pdcajob.service.PlanService;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class PlanCheckHistoryAction
extends BaseAction {
    private PlanCheckHistoryService planCheckHistoryService;
    private PlanService planService;

    public ActionForward viewPlanCheckHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Plan parentPlan;
        PlanCheckHistoryForm planCheckHistoryForm = (PlanCheckHistoryForm)form;
        PlanCheckHistory planCheckHistory = this.planCheckHistoryService.getPlanCheckHistory(planCheckHistoryForm.getPk());
        Plan plan = planCheckHistory.getPlan();
        if (plan.getParent() != null && (parentPlan = this.planService.getPlan(plan.getParent())) != null) {
            plan.setParentName(parentPlan.getName());
            plan.setParentCode(parentPlan.getCode());
        }
        request.setAttribute("planPojo", (Object)plan);
        request.setAttribute("planCheckHistoryPojo", (Object)planCheckHistory);
        return mapping.findForward("planCheckHistoryView");
    }

    public ActionForward listPlanCheckHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Page page = this.planCheckHistoryService.getPlanCheckHistoryPage();
        this.addEmptyRows(new PlanCheckHistory(), page, request);
        return mapping.findForward("planCheckHistoryList");
    }

    public ActionForward addPlanCheckHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PlanCheckHistoryForm planCheckHistoryForm = (PlanCheckHistoryForm)form;
        PlanCheckHistory planCheckHistory = new PlanCheckHistory();
        ObjectUtil.objectPopulate(planCheckHistory, (Object)planCheckHistoryForm);
        planCheckHistory.setCreateTime(StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
        planCheckHistory.setOperator(this.getLoginUser());
        if (planCheckHistoryForm.getPlanPk() != null) {
            planCheckHistory.setPlan(this.planService.getPlan(planCheckHistoryForm.getPlanPk()));
        }
        this.planCheckHistoryService.savePlanCheckHistory(planCheckHistory);
        return mapping.findForward("operatorsuccess");
    }

    public ActionForward updatePlanCheckHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PlanCheckHistoryForm planCheckHistoryForm = (PlanCheckHistoryForm)form;
        PlanCheckHistory planCheckHistory = this.planCheckHistoryService.getPlanCheckHistory(planCheckHistoryForm.getPk());
        ObjectUtil.objectPopulate((Object)planCheckHistory, (Object)planCheckHistoryForm, true);
        this.planCheckHistoryService.updatePlanCheckHistory(planCheckHistory);
        return mapping.findForward("operatorsuccess");
    }

    public ActionForward deletePlanCheckHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PlanCheckHistoryForm planCheckHistoryForm = (PlanCheckHistoryForm)form;
        this.planCheckHistoryService.deletePlanCheckHistorys(planCheckHistoryForm.getSelectPks());
        return mapping.findForward("operatorsuccess");
    }

    public ActionForward goAddPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PlanCheckHistoryForm planCheckHistoryForm = (PlanCheckHistoryForm)form;
        if (planCheckHistoryForm.getPlanPk() != null) {
            Plan parentPlan;
            Plan plan = this.planService.getPlan(planCheckHistoryForm.getPlanPk());
            if (plan.getParent() != null && (parentPlan = this.planService.getPlan(plan.getParent())) != null) {
                plan.setParentName(parentPlan.getName());
                plan.setParentCode(parentPlan.getCode());
            }
            request.setAttribute("planPojo", (Object)plan);
        }
        return mapping.findForward("planCheckHistoryAdd");
    }

    public ActionForward goModifyPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Plan parentPlan;
        PlanCheckHistoryForm planCheckHistoryForm = (PlanCheckHistoryForm)form;
        PlanCheckHistory planCheckHistory = null;
        planCheckHistory = planCheckHistoryForm.getPk() != null ? this.planCheckHistoryService.getPlanCheckHistory(planCheckHistoryForm.getPk()) : this.planCheckHistoryService.getPlanCheckHistory(Integer.valueOf(planCheckHistoryForm.getSelectPks()[0]));
        ObjectUtil.objectPopulate((Object)planCheckHistoryForm, planCheckHistory);
        Plan plan = planCheckHistory.getPlan();
        if (plan.getParent() != null && (parentPlan = this.planService.getPlan(plan.getParent())) != null) {
            plan.setParentName(parentPlan.getName());
            plan.setParentCode(parentPlan.getCode());
        }
        request.setAttribute("planPojo", (Object)plan);
        return mapping.findForward("planCheckHistoryModify");
    }

    public PlanCheckHistoryService getPlanCheckHistoryService() {
        return this.planCheckHistoryService;
    }

    public void setPlanCheckHistoryService(PlanCheckHistoryService planCheckHistoryService) {
        this.planCheckHistoryService = planCheckHistoryService;
    }

    public PlanService getPlanService() {
        return this.planService;
    }

    public void setPlanService(PlanService planService) {
        this.planService = planService;
    }
}

