/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.pdcajob.action;

import com.highesthelp.framework.action.BaseAction;
import com.highesthelp.framework.common.Node;
import com.highesthelp.framework.common.Page;
import com.highesthelp.framework.common.Tree;
import com.highesthelp.framework.exception.CommonException;
import com.highesthelp.framework.exception.DelException;
import com.highesthelp.framework.util.ObjectUtil;
import com.highesthelp.framework.util.StringTools;
import com.highesthelp.pdcajob.form.PrivateDirectoryForm;
import com.highesthelp.pdcajob.pojo.PrivateDirectory;
import com.highesthelp.pdcajob.service.PrivateDirectoryService;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class PrivateDirectoryAction
extends BaseAction {
    private PrivateDirectoryService privateDirectoryService;

    public ActionForward viewPrivateDirectory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PrivateDirectoryForm privateDirectoryForm = (PrivateDirectoryForm)form;
        PrivateDirectory privateDirectory = this.privateDirectoryService.getPrivateDirectory(privateDirectoryForm.getPk());
        request.setAttribute("privateDirectoryPojo", (Object)privateDirectory);
        return mapping.findForward("privateDirectoryView");
    }

    public ActionForward listPrivateDirectory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Page page = this.privateDirectoryService.getPrivateDirectoryPage();
        this.addEmptyRows(new PrivateDirectory(), page, request);
        return mapping.findForward("privateDirectoryList");
    }

    public ActionForward addPrivateDirectory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PrivateDirectoryForm privateDirectoryForm = (PrivateDirectoryForm)form;
        PrivateDirectory privateDirectory = new PrivateDirectory();
        privateDirectory.setName(privateDirectoryForm.getName());
        if (privateDirectoryForm.getParent() == null) {
            privateDirectory.setParent(0);
        } else {
            privateDirectory.setParent(privateDirectoryForm.getParent());
        }
        privateDirectory.setCreateTime(StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
        privateDirectory.setOperator(this.getLoginUser());
        this.privateDirectoryService.savePrivateDirectory(privateDirectory);
        return mapping.findForward("operatortreesuccess");
    }

    public ActionForward updatePrivateDirectory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PrivateDirectoryForm privateDirectoryForm = (PrivateDirectoryForm)form;
        PrivateDirectory privateDirectory = this.privateDirectoryService.getPrivateDirectory(privateDirectoryForm.getPk());
        ObjectUtil.objectPopulate((Object)privateDirectory, (Object)privateDirectoryForm, true);
        this.privateDirectoryService.updatePrivateDirectory(privateDirectory);
        return mapping.findForward("operatortreesuccess");
    }

    public ActionForward deletePrivateDirectory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PrivateDirectoryForm privateDirectoryForm = (PrivateDirectoryForm)form;
        String pks = StringTools.Array2String(privateDirectoryForm.getSelectPks());
        int list = this.privateDirectoryService.getHQLCount("select count(*) from PrivateDocument privateDocument where privateDocument.privateDirectory.pk in(" + pks + ")");
        if (list > 0) {
            throw new DelException();
        }
        this.privateDirectoryService.deletePrivateDirectorys(privateDirectoryForm.getSelectPks());
        return mapping.findForward("operatortreesuccess");
    }

    public ActionForward privateDirectoryTreeView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List dList = this.privateDirectoryService.getList("from PrivateDirectory privateDirectory where privateDirectory.operator.pk = " + this.getLoginUser().getPk());
        Tree tree = new Tree();
        int i = 0;
        while (i < dList.size()) {
            PrivateDirectory privateDirectory = (PrivateDirectory)dList.get(i);
            String parentPk = "";
            parentPk = privateDirectory.getParent() == null ? Tree.ROOT_ID : privateDirectory.getParent().toString();
            Node node = new Node(privateDirectory.getPk().toString(), privateDirectory.getName(), parentPk);
            tree.addNode(node);
            ++i;
        }
        Document document = DocumentHelper.parseText((String)tree.toXMLString());
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("utf-8");
        XMLWriter output = new XMLWriter((OutputStream)response.getOutputStream(), format);
        try {
            response.setContentType("text/xml;charset=utf-8");
            response.setHeader("Cache-Control", "no-cache");
            output.write(document);
            output.close();
        }
        catch (Exception e) {
            throw new CommonException();
        }
        return null;
    }

    public ActionForward goAddPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PrivateDirectory privateDirectory;
        String[] sPk;
        PrivateDirectoryForm privateDirectoryForm = (PrivateDirectoryForm)form;
        if (privateDirectoryForm.getSelectPks() != null && StringTools.isNotEmpty(privateDirectoryForm.getSelectPks()[0]) && (sPk = privateDirectoryForm.getSelectPks()[0].split(",")).length > 0 && (privateDirectory = this.privateDirectoryService.getPrivateDirectory(Integer.valueOf(sPk[0]))) != null) {
            privateDirectoryForm.setParent(Integer.valueOf(sPk[0]));
            privateDirectoryForm.setParentName(privateDirectory.getName());
        }
        return mapping.findForward("privateDirectoryAdd");
    }

    public ActionForward goModifyPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PrivateDirectory parentDep;
        PrivateDirectoryForm privateDirectoryForm = (PrivateDirectoryForm)form;
        PrivateDirectory privateDirectory = null;
        privateDirectory = privateDirectoryForm.getPk() != null ? this.privateDirectoryService.getPrivateDirectory(privateDirectoryForm.getPk()) : this.privateDirectoryService.getPrivateDirectory(Integer.valueOf(privateDirectoryForm.getSelectPks()[0]));
        ObjectUtil.objectPopulate((Object)privateDirectoryForm, privateDirectory);
        Integer pdpk = privateDirectory.getParent();
        if (pdpk != null && (parentDep = this.privateDirectoryService.getPrivateDirectory(pdpk)) != null) {
            privateDirectoryForm.setParent(parentDep.getPk());
            privateDirectoryForm.setParentName(parentDep.getName());
        }
        return mapping.findForward("privateDirectoryModify");
    }

    public PrivateDirectoryService getPrivateDirectoryService() {
        return this.privateDirectoryService;
    }

    public void setPrivateDirectoryService(PrivateDirectoryService privateDirectoryService) {
        this.privateDirectoryService = privateDirectoryService;
    }
}

