/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.pdcajob.action;

import com.highesthelp.framework.HighestHelpProduct;
import com.highesthelp.framework.action.BaseAction;
import com.highesthelp.framework.common.Node;
import com.highesthelp.framework.common.Page;
import com.highesthelp.framework.common.Selector;
import com.highesthelp.framework.common.Tree;
import com.highesthelp.framework.exception.UploadFileException;
import com.highesthelp.framework.upload.FileUpload;
import com.highesthelp.framework.util.ObjectUtil;
import com.highesthelp.framework.util.StringTools;
import com.highesthelp.pdcajob.form.PrivateDocumentForm;
import com.highesthelp.pdcajob.pojo.PrivateDirectory;
import com.highesthelp.pdcajob.pojo.PrivateDocument;
import com.highesthelp.pdcajob.service.PrivateDirectoryService;
import com.highesthelp.pdcajob.service.PrivateDocumentService;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class PrivateDocumentAction
extends BaseAction {
    private PrivateDocumentService privateDocumentService;
    private PrivateDirectoryService privateDirectoryService;

    public ActionForward viewPrivateDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PrivateDocumentForm privateDocumentForm = (PrivateDocumentForm)form;
        PrivateDocument privateDocument = this.privateDocumentService.getPrivateDocument(privateDocumentForm.getPk());
        request.setAttribute("privateDocumentPojo", (Object)privateDocument);
        return mapping.findForward("privateDocumentView");
    }

    public ActionForward listPrivateDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Page page = this.privateDocumentService.getPrivateDocumentPage();
        this.addEmptyRows(new PrivateDocument(), page, request);
        return mapping.findForward("privateDocumentList");
    }

    public ActionForward addPrivateDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PrivateDocumentForm privateDocumentForm = (PrivateDocumentForm)form;
        PrivateDocument privateDocument = new PrivateDocument();
        String attrFile = this.saveUploadFile(privateDocumentForm.getAttrFile(), String.valueOf(HighestHelpProduct.getDataPath()) + this.getLoginUser().getPk() + "/");
        if (StringTools.isEmpty(attrFile)) {
            throw new UploadFileException();
        }
        privateDocument.setAttrFile(attrFile);
        FileUpload fileUpload = new FileUpload(privateDocumentForm.getAttrFile());
        privateDocument.setName(fileUpload.getFileName());
        privateDocument.setExt(fileUpload.getFileExtName());
        String size = "";
        long fileSize = fileUpload.getFileSize();
        size = fileSize >= 1000000L ? String.valueOf(String.valueOf(fileSize / 1024L / 1024L)) + "M" : (fileSize >= 10000L && fileSize < 1000000L ? String.valueOf(String.valueOf(fileSize / 1024L)) + "KB" : String.valueOf(String.valueOf(fileSize)) + "B");
        privateDocument.setSize(size);
        if (privateDocumentForm.getPrivateDirectoryPk() != null) {
            privateDocument.setPrivateDirectory(this.privateDirectoryService.getPrivateDirectory(privateDocumentForm.getPrivateDirectoryPk()));
        }
        privateDocument.setCreateTime(StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
        privateDocument.setOperator(this.getLoginUser());
        this.privateDocumentService.savePrivateDocument(privateDocument);
        return mapping.findForward("operatorsuccess");
    }

    public ActionForward updatePrivateDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PrivateDocumentForm privateDocumentForm = (PrivateDocumentForm)form;
        PrivateDocument privateDocument = this.privateDocumentService.getPrivateDocument(privateDocumentForm.getPk());
        ObjectUtil.objectPopulate((Object)privateDocument, (Object)privateDocumentForm, true);
        this.privateDocumentService.updatePrivateDocument(privateDocument);
        return mapping.findForward("operatorsuccess");
    }

    public ActionForward deletePrivateDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PrivateDocumentForm privateDocumentForm = (PrivateDocumentForm)form;
        this.privateDocumentService.deletePrivateDocuments(privateDocumentForm.getSelectPks());
        return mapping.findForward("operatorsuccess");
    }

    public ActionForward goAddPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List dList = this.privateDirectoryService.getList("from PrivateDirectory privateDirectory");
        Tree tree = new Tree();
        int i = 0;
        while (i < dList.size()) {
            PrivateDirectory privateDirectory = (PrivateDirectory)dList.get(i);
            String parentPk = "";
            parentPk = privateDirectory.getParent() == null ? Tree.ROOT_ID : privateDirectory.getParent().toString();
            Node node = new Node(privateDirectory.getPk().toString(), privateDirectory.getName(), parentPk);
            tree.addNode(node);
            ++i;
        }
        List<Selector> sList = tree.toSelected();
        request.setAttribute("privateDirectorys", sList);
        return mapping.findForward("privateDocumentAdd");
    }

    public ActionForward goModifyPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PrivateDocumentForm privateDocumentForm = (PrivateDocumentForm)form;
        PrivateDocument privateDocument = null;
        privateDocument = privateDocumentForm.getPk() != null ? this.privateDocumentService.getPrivateDocument(privateDocumentForm.getPk()) : this.privateDocumentService.getPrivateDocument(Integer.valueOf(privateDocumentForm.getSelectPks()[0]));
        ObjectUtil.objectPopulate((Object)privateDocumentForm, privateDocument);
        return mapping.findForward("privateDocumentModify");
    }

    public PrivateDocumentService getPrivateDocumentService() {
        return this.privateDocumentService;
    }

    public void setPrivateDocumentService(PrivateDocumentService privateDocumentService) {
        this.privateDocumentService = privateDocumentService;
    }

    public PrivateDirectoryService getPrivateDirectoryService() {
        return this.privateDirectoryService;
    }

    public void setPrivateDirectoryService(PrivateDirectoryService privateDirectoryService) {
        this.privateDirectoryService = privateDirectoryService;
    }
}

