/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.pdcajob.action;

import com.highesthelp.framework.action.BaseAction;
import com.highesthelp.framework.common.Node;
import com.highesthelp.framework.common.Page;
import com.highesthelp.framework.common.Tree;
import com.highesthelp.framework.exception.CommonException;
import com.highesthelp.framework.exception.DelException;
import com.highesthelp.framework.util.ObjectUtil;
import com.highesthelp.framework.util.StringTools;
import com.highesthelp.pdcajob.form.PublicDirectoryForm;
import com.highesthelp.pdcajob.pojo.PublicDirectory;
import com.highesthelp.pdcajob.service.PublicDirectoryService;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class PublicDirectoryAction
extends BaseAction {
    private PublicDirectoryService publicDirectoryService;

    public ActionForward viewPublicDirectory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PublicDirectoryForm publicDirectoryForm = (PublicDirectoryForm)form;
        PublicDirectory publicDirectory = this.publicDirectoryService.getPublicDirectory(publicDirectoryForm.getPk());
        request.setAttribute("publicDirectoryPojo", (Object)publicDirectory);
        return mapping.findForward("publicDirectoryView");
    }

    public ActionForward listPublicDirectory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Page page = this.publicDirectoryService.getPublicDirectoryPage();
        this.addEmptyRows(new PublicDirectory(), page, request);
        return mapping.findForward("publicDirectoryList");
    }

    public ActionForward addPublicDirectory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PublicDirectoryForm publicDirectoryForm = (PublicDirectoryForm)form;
        PublicDirectory publicDirectory = new PublicDirectory();
        publicDirectory.setName(publicDirectoryForm.getName());
        if (publicDirectoryForm.getParent() == null) {
            publicDirectory.setParent(0);
        } else {
            publicDirectory.setParent(publicDirectoryForm.getParent());
        }
        publicDirectory.setCreateTime(StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
        publicDirectory.setOperator(this.getLoginUser());
        this.publicDirectoryService.savePublicDirectory(publicDirectory);
        return mapping.findForward("operatortreesuccess");
    }

    public ActionForward updatePublicDirectory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PublicDirectoryForm publicDirectoryForm = (PublicDirectoryForm)form;
        PublicDirectory publicDirectory = this.publicDirectoryService.getPublicDirectory(publicDirectoryForm.getPk());
        ObjectUtil.objectPopulate((Object)publicDirectory, (Object)publicDirectoryForm, true);
        this.publicDirectoryService.updatePublicDirectory(publicDirectory);
        return mapping.findForward("operatortreesuccess");
    }

    public ActionForward deletePublicDirectory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PublicDirectoryForm publicDirectoryForm = (PublicDirectoryForm)form;
        String pks = StringTools.Array2String(publicDirectoryForm.getSelectPks());
        int list = this.publicDirectoryService.getHQLCount("select count(*) from PublicDocument publicDocument where publicDocument.publicDirectory.pk in(" + pks + ")");
        if (list > 0) {
            throw new DelException();
        }
        this.publicDirectoryService.deletePublicDirectorys(publicDirectoryForm.getSelectPks());
        return mapping.findForward("operatortreesuccess");
    }

    public ActionForward publicDirectoryTreeView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List dList = this.publicDirectoryService.getList("from PublicDirectory publicDirectory");
        Tree tree = new Tree();
        int i = 0;
        while (i < dList.size()) {
            PublicDirectory publicDirectory = (PublicDirectory)dList.get(i);
            String parentPk = "";
            parentPk = publicDirectory.getParent() == null ? Tree.ROOT_ID : publicDirectory.getParent().toString();
            Node node = new Node(publicDirectory.getPk().toString(), publicDirectory.getName(), parentPk);
            tree.addNode(node);
            ++i;
        }
        Document document = DocumentHelper.parseText((String)tree.toXMLString());
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("utf-8");
        XMLWriter output = new XMLWriter((OutputStream)response.getOutputStream(), format);
        try {
            response.setContentType("text/xml;charset=utf-8");
            response.setHeader("Cache-Control", "no-cache");
            output.write(document);
            output.close();
        }
        catch (Exception e) {
            throw new CommonException();
        }
        return null;
    }

    public ActionForward goAddPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PublicDirectory publicDirectory;
        String[] sPk;
        PublicDirectoryForm publicDirectoryForm = (PublicDirectoryForm)form;
        if (publicDirectoryForm.getSelectPks() != null && StringTools.isNotEmpty(publicDirectoryForm.getSelectPks()[0]) && (sPk = publicDirectoryForm.getSelectPks()[0].split(",")).length > 0 && (publicDirectory = this.publicDirectoryService.getPublicDirectory(Integer.valueOf(sPk[0]))) != null) {
            publicDirectoryForm.setParent(Integer.valueOf(sPk[0]));
            publicDirectoryForm.setParentName(publicDirectory.getName());
        }
        return mapping.findForward("publicDirectoryAdd");
    }

    public ActionForward goModifyPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PublicDirectory parentDep;
        PublicDirectoryForm publicDirectoryForm = (PublicDirectoryForm)form;
        PublicDirectory publicDirectory = null;
        publicDirectory = publicDirectoryForm.getPk() != null ? this.publicDirectoryService.getPublicDirectory(publicDirectoryForm.getPk()) : this.publicDirectoryService.getPublicDirectory(Integer.valueOf(publicDirectoryForm.getSelectPks()[0]));
        ObjectUtil.objectPopulate((Object)publicDirectoryForm, publicDirectory);
        Integer pdpk = publicDirectory.getParent();
        if (pdpk != null && (parentDep = this.publicDirectoryService.getPublicDirectory(pdpk)) != null) {
            publicDirectoryForm.setParent(parentDep.getPk());
            publicDirectoryForm.setParentName(parentDep.getName());
        }
        return mapping.findForward("publicDirectoryModify");
    }

    public PublicDirectoryService getPublicDirectoryService() {
        return this.publicDirectoryService;
    }

    public void setPublicDirectoryService(PublicDirectoryService publicDirectoryService) {
        this.publicDirectoryService = publicDirectoryService;
    }
}

