/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.pdcajob.action;

import com.highesthelp.framework.HighestHelpProduct;
import com.highesthelp.framework.action.BaseAction;
import com.highesthelp.framework.common.Node;
import com.highesthelp.framework.common.Page;
import com.highesthelp.framework.common.Selector;
import com.highesthelp.framework.common.Tree;
import com.highesthelp.framework.exception.UploadFileException;
import com.highesthelp.framework.upload.FileUpload;
import com.highesthelp.framework.util.ObjectUtil;
import com.highesthelp.framework.util.StringTools;
import com.highesthelp.pdcajob.form.PublicDocumentForm;
import com.highesthelp.pdcajob.pojo.PublicDirectory;
import com.highesthelp.pdcajob.pojo.PublicDocument;
import com.highesthelp.pdcajob.service.PublicDirectoryService;
import com.highesthelp.pdcajob.service.PublicDocumentService;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class PublicDocumentAction
extends BaseAction {
    private PublicDocumentService publicDocumentService;
    private PublicDirectoryService publicDirectoryService;

    public ActionForward viewPublicDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PublicDocumentForm publicDocumentForm = (PublicDocumentForm)form;
        PublicDocument publicDocument = this.publicDocumentService.getPublicDocument(publicDocumentForm.getPk());
        request.setAttribute("publicDocumentPojo", (Object)publicDocument);
        return mapping.findForward("publicDocumentView");
    }

    public ActionForward listPublicDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Page page = this.publicDocumentService.getPublicDocumentPage();
        this.addEmptyRows(new PublicDocument(), page, request);
        return mapping.findForward("publicDocumentList");
    }

    public ActionForward addPublicDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PublicDocumentForm publicDocumentForm = (PublicDocumentForm)form;
        PublicDocument publicDocument = new PublicDocument();
        String attrFile = this.saveUploadFile(publicDocumentForm.getAttrFile(), String.valueOf(HighestHelpProduct.getDataPath()) + this.getLoginUser().getPk() + "/");
        if (StringTools.isEmpty(attrFile)) {
            throw new UploadFileException();
        }
        publicDocument.setAttrFile(attrFile);
        FileUpload fileUpload = new FileUpload(publicDocumentForm.getAttrFile());
        publicDocument.setName(fileUpload.getFileName());
        publicDocument.setExt(fileUpload.getFileExtName());
        String size = "";
        long fileSize = fileUpload.getFileSize();
        size = fileSize >= 1000000L ? String.valueOf(String.valueOf(fileSize / 1024L / 1024L)) + "M" : (fileSize >= 10000L && fileSize < 1000000L ? String.valueOf(String.valueOf(fileSize / 1024L)) + "KB" : String.valueOf(String.valueOf(fileSize)) + "B");
        publicDocument.setSize(size);
        if (publicDocumentForm.getPublicDirectoryPk() != null) {
            publicDocument.setPublicDirectory(this.publicDirectoryService.getPublicDirectory(publicDocumentForm.getPublicDirectoryPk()));
        }
        publicDocument.setCreateTime(StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
        publicDocument.setOperator(this.getLoginUser());
        this.publicDocumentService.savePublicDocument(publicDocument);
        return mapping.findForward("operatorsuccess");
    }

    public ActionForward updatePublicDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PublicDocumentForm publicDocumentForm = (PublicDocumentForm)form;
        PublicDocument publicDocument = this.publicDocumentService.getPublicDocument(publicDocumentForm.getPk());
        ObjectUtil.objectPopulate((Object)publicDocument, (Object)publicDocumentForm, true);
        this.publicDocumentService.updatePublicDocument(publicDocument);
        return mapping.findForward("operatorsuccess");
    }

    public ActionForward deletePublicDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PublicDocumentForm publicDocumentForm = (PublicDocumentForm)form;
        this.publicDocumentService.deletePublicDocuments(publicDocumentForm.getSelectPks());
        return mapping.findForward("operatorsuccess");
    }

    public ActionForward goAddPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List dList = this.publicDirectoryService.getList("from PublicDirectory publicDirectory");
        Tree tree = new Tree();
        int i = 0;
        while (i < dList.size()) {
            PublicDirectory publicDirectory = (PublicDirectory)dList.get(i);
            String parentPk = "";
            parentPk = publicDirectory.getParent() == null ? Tree.ROOT_ID : publicDirectory.getParent().toString();
            Node node = new Node(publicDirectory.getPk().toString(), publicDirectory.getName(), parentPk);
            tree.addNode(node);
            ++i;
        }
        List<Selector> sList = tree.toSelected();
        request.setAttribute("publicDirectorys", sList);
        return mapping.findForward("publicDocumentAdd");
    }

    public ActionForward goModifyPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PublicDocumentForm publicDocumentForm = (PublicDocumentForm)form;
        PublicDocument publicDocument = null;
        publicDocument = publicDocumentForm.getPk() != null ? this.publicDocumentService.getPublicDocument(publicDocumentForm.getPk()) : this.publicDocumentService.getPublicDocument(Integer.valueOf(publicDocumentForm.getSelectPks()[0]));
        ObjectUtil.objectPopulate((Object)publicDocumentForm, publicDocument);
        return mapping.findForward("publicDocumentModify");
    }

    public PublicDocumentService getPublicDocumentService() {
        return this.publicDocumentService;
    }

    public void setPublicDocumentService(PublicDocumentService publicDocumentService) {
        this.publicDocumentService = publicDocumentService;
    }

    public PublicDirectoryService getPublicDirectoryService() {
        return this.publicDirectoryService;
    }

    public void setPublicDirectoryService(PublicDirectoryService publicDirectoryService) {
        this.publicDirectoryService = publicDirectoryService;
    }
}

