/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.pdcajob.action;

import com.highesthelp.framework.action.BaseAction;
import com.highesthelp.framework.common.Page;
import com.highesthelp.framework.util.ObjectUtil;
import com.highesthelp.pdcajob.form.ResourceForm;
import com.highesthelp.pdcajob.pojo.Resource;
import com.highesthelp.pdcajob.service.ResourceService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ResourceAction
extends BaseAction {
    private ResourceService resourceService;

    public ActionForward viewResource(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResourceForm resourceForm = (ResourceForm)form;
        Resource resource = this.resourceService.getResource(resourceForm.getPk());
        request.setAttribute("resourcePojo", (Object)resource);
        return mapping.findForward("resourceView");
    }

    public ActionForward listResource(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Page page = this.resourceService.getResourcePage();
        this.addEmptyRows(new Resource(), page, request);
        return mapping.findForward("resourceList");
    }

    public ActionForward addResource(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResourceForm resourceForm = (ResourceForm)form;
        Resource resource = new Resource();
        ObjectUtil.objectPopulate(resource, (Object)resourceForm);
        this.resourceService.saveResource(resource);
        return mapping.findForward("resourceListAction");
    }

    public ActionForward updateResource(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResourceForm resourceForm = (ResourceForm)form;
        Resource resource = this.resourceService.getResource(resourceForm.getPk());
        ObjectUtil.objectPopulate(resource, (Object)resourceForm);
        this.resourceService.updateResource(resource);
        return mapping.findForward("resourceListAction");
    }

    public ActionForward deleteResource(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResourceForm resourceForm = (ResourceForm)form;
        this.resourceService.deleteResources(resourceForm.getSelectPks());
        return mapping.findForward("resourceListAction");
    }

    public ActionForward goAddPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("resourceAdd");
    }

    public ActionForward goModifyPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResourceForm resourceForm = (ResourceForm)form;
        Resource resource = null;
        resource = resourceForm.getPk() != null ? this.resourceService.getResource(resourceForm.getPk()) : this.resourceService.getResource(Integer.valueOf(resourceForm.getSelectPks()[0]));
        ObjectUtil.objectPopulate((Object)resourceForm, resource);
        return mapping.findForward("resourceModify");
    }

    public ResourceService getResourceService() {
        return this.resourceService;
    }

    public void setResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }
}

