/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.pdcajob.action;

import com.highesthelp.framework.acl.CacheResources;
import com.highesthelp.framework.action.BaseAction;
import com.highesthelp.framework.common.Page;
import com.highesthelp.framework.jdbc.Db;
import com.highesthelp.framework.util.ObjectUtil;
import com.highesthelp.pdcajob.form.RoleForm;
import com.highesthelp.pdcajob.pojo.Resource;
import com.highesthelp.pdcajob.pojo.Role;
import com.highesthelp.pdcajob.service.RoleService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class RoleAction
extends BaseAction {
    private String prefix = "us_";
    private RoleService roleService;

    public ActionForward viewRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RoleForm roleForm = (RoleForm)form;
        Role role = this.roleService.getRole(roleForm.getPk());
        request.setAttribute("rolePojo", (Object)role);
        List list = this.roleService.getList("from ResourceClass rc where rc.innerRes = 0 order by rc.sort asc");
        request.setAttribute("RC", (Object)list);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Db db = new Db();
        Connection conn = Db.getConnection();
        Statement sm = conn.createStatement();
        ResultSet rs = sm.executeQuery("select r.* from role_resources rr left join resource r on rr.resource = r.pk where rr.role = " + role.getPk());
        while (rs.next()) {
            Resource resource = new Resource();
            resource.setDescription(rs.getString("description"));
            resource.setInnerRes(rs.getInt("inner_res"));
            resource.setPk(rs.getInt("pk"));
            resource.setName(rs.getString("name"));
            resources.add(resource);
        }
        CacheResources cache = new CacheResources();
        cache.initResources(resources);
        request.setAttribute("cache", (Object)cache);
        sm.close();
        return mapping.findForward("roleView");
    }

    public ActionForward listRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Page page = this.roleService.getRolePage();
        this.addEmptyRows(new Role(), page, request);
        return mapping.findForward("roleList");
    }

    public ActionForward addRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RoleForm roleForm = (RoleForm)form;
        Role role = new Role();
        ObjectUtil.objectPopulate(role, (Object)roleForm);
        this.roleService.saveRole(role);
        Enumeration pns = request.getParameterNames();
        Db db = new Db();
        Connection conn = Db.getConnection();
        PreparedStatement ps = conn.prepareStatement("insert into role_resources(role,resource) values(?,?)");
        while (pns.hasMoreElements()) {
            String key = (String)pns.nextElement();
            if (!key.startsWith(this.prefix)) continue;
            ps.setInt(1, role.getPk());
            ps.setInt(2, Integer.valueOf(key.replace(this.prefix, "")));
            ps.addBatch();
        }
        ps.executeBatch();
        ps.close();
        conn.close();
        return mapping.findForward("roleListAction");
    }

    public ActionForward updateRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RoleForm roleForm = (RoleForm)form;
        Role role = this.roleService.getRole(roleForm.getPk());
        ObjectUtil.objectPopulate(role, (Object)roleForm);
        this.roleService.updateRole(role);
        Enumeration pns = request.getParameterNames();
        Db db = new Db();
        Connection conn = Db.getConnection();
        Statement sm = conn.createStatement();
        sm.executeUpdate("delete from role_resources where role = " + role.getPk());
        sm.close();
        PreparedStatement ps = conn.prepareStatement("insert into role_resources(role,resource) values(?,?)");
        while (pns.hasMoreElements()) {
            String key = (String)pns.nextElement();
            if (!key.startsWith(this.prefix)) continue;
            ps.setInt(1, role.getPk());
            ps.setInt(2, Integer.valueOf(key.replace(this.prefix, "")));
            ps.addBatch();
        }
        ps.executeBatch();
        ps.close();
        conn.close();
        return mapping.findForward("roleListAction");
    }

    public ActionForward deleteRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RoleForm roleForm = (RoleForm)form;
        Db db = new Db();
        Connection conn = Db.getConnection();
        Statement sm = conn.createStatement();
        String[] pks = roleForm.getSelectPks()[0].split(",");
        int i = 0;
        while (i < pks.length) {
            Role role = this.roleService.getRole(Integer.valueOf(pks[i]));
            ++i;
        }
        sm.close();
        conn.close();
        this.roleService.deleteRoles(roleForm.getSelectPks());
        return mapping.findForward("roleListAction");
    }

    public ActionForward goAddPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List list = this.roleService.getList("from ResourceClass rc where rc.innerRes = 0 order by rc.sort asc");
        request.setAttribute("RC", (Object)list);
        return mapping.findForward("roleAdd");
    }

    public ActionForward goModifyPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RoleForm roleForm = (RoleForm)form;
        Role role = null;
        role = roleForm.getPk() != null ? this.roleService.getRole(roleForm.getPk()) : this.roleService.getRole(Integer.valueOf(roleForm.getSelectPks()[0]));
        ObjectUtil.objectPopulate((Object)roleForm, role);
        List list = this.roleService.getList("from ResourceClass rc where rc.innerRes = 0 order by rc.sort asc");
        request.setAttribute("RC", (Object)list);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Db db = new Db();
        Connection conn = Db.getConnection();
        Statement sm = conn.createStatement();
        ResultSet rs = sm.executeQuery("select r.* from role_resources rr left join resource r on rr.resource = r.pk where rr.role = " + role.getPk());
        while (rs.next()) {
            Resource resource = new Resource();
            resource.setDescription(rs.getString("description"));
            resource.setInnerRes(rs.getInt("inner_res"));
            resource.setPk(rs.getInt("pk"));
            resource.setName(rs.getString("name"));
            resources.add(resource);
        }
        CacheResources cache = new CacheResources();
        cache.initResources(resources);
        request.setAttribute("cache", (Object)cache);
        sm.close();
        conn.close();
        return mapping.findForward("roleModify");
    }

    public RoleService getRoleService() {
        return this.roleService;
    }

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }
}

