/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.pdcajob.action;

import com.highesthelp.framework.HighestHelpProduct;
import com.highesthelp.framework.action.BaseAction;
import com.highesthelp.framework.cache.SelectorCache;
import com.highesthelp.framework.common.Config;
import com.highesthelp.framework.common.Page;
import com.highesthelp.framework.form.BaseForm;
import com.highesthelp.framework.util.ObjectUtil;
import com.highesthelp.framework.util.ResourcesTools;
import com.highesthelp.framework.util.StringTools;
import com.highesthelp.pdcajob.form.TaskForm;
import com.highesthelp.pdcajob.pojo.Experience;
import com.highesthelp.pdcajob.pojo.ListValue;
import com.highesthelp.pdcajob.pojo.MessagesBox;
import com.highesthelp.pdcajob.pojo.Plan;
import com.highesthelp.pdcajob.pojo.Task;
import com.highesthelp.pdcajob.service.ExperienceService;
import com.highesthelp.pdcajob.service.OperatorService;
import com.highesthelp.pdcajob.service.PlanService;
import com.highesthelp.pdcajob.service.TaskControlService;
import com.highesthelp.pdcajob.service.TaskService;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class TaskAction
extends BaseAction {
    private TaskService taskService;
    private OperatorService operatorService;
    private PlanService planService;
    private TaskControlService taskControlService;
    private ExperienceService experienceService;

    public ActionForward viewTask(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<ListValue> priorityTypeSelect = this.selectorCache.getListValuesByListClassType("priorityType");
        request.setAttribute("priorityTypeSelect", priorityTypeSelect);
        List<ListValue> qualityStatusTypeSelect = this.selectorCache.getListValuesByListClassType("qualityStatusType");
        request.setAttribute("qualityStatusTypeSelect", qualityStatusTypeSelect);
        TaskForm taskForm = (TaskForm)form;
        Task task = this.taskService.getTask(taskForm.getPk());
        ObjectUtil.objectPopulate((Object)taskForm, task);
        request.setAttribute("taskPojo", (Object)task);
        if (taskForm.getViewPath() != null && taskForm.getViewPath() == 1) {
            return mapping.findForward("taskAssignView");
        }
        return mapping.findForward("taskView");
    }

    public ActionForward listTask(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TaskForm taskForm = (TaskForm)form;
        Page page = this.taskService.getTaskPage();
        this.addEmptyRows(new Task(), page, request);
        if (taskForm.getViewPath() != null && taskForm.getViewPath() == 1) {
            return mapping.findForward("taskListAssign");
        }
        if (taskForm.getViewPath() != null && taskForm.getViewPath() == 2) {
            return mapping.findForward("plantaskList");
        }
        return mapping.findForward("taskList");
    }

    public ActionForward addTask(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int taskCount = this.taskService.getHQLCount("select count(*) from Task task");
        if (taskCount >= 50) {
            this.checkRegSystem();
        }
        TaskForm taskForm = (TaskForm)form;
        Task task = new Task();
        String attrFile = this.saveUploadFile(taskForm.getAttrFile(), HighestHelpProduct.getDataPath());
        task.setAttrFile(attrFile);
        ObjectUtil.objectPopulate(task, (Object)taskForm);
        if (taskForm.getOperatorPk() != null) {
            task.setOperatorByDoUser(this.operatorService.getOperator(taskForm.getOperatorPk()));
        }
        task.setTaskStatusType(Task.TASK_STATUS_NO_DO);
        task.setCreateTime(StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
        task.setOperator(this.getLoginUser());
        if (taskForm.getPlanPk() != null) {
            task.setPlan(this.planService.getPlan(taskForm.getPlanPk()));
        }
        task.setDelIt(BaseForm.ITEM_DEL_NO);
        this.taskService.saveTask(task);
        boolean auto = ResourcesTools.convertToBoolean(ResourcesTools.getOptionsMessage("option.system.message.send.auto"), false);
        if (auto) {
            String title = ResourcesTools.getOptionsMessage("Task.assign.message.title");
            title = ResourcesTools.replaceMessage(title, "operator", this.getLoginUser().getRealName());
            title = ResourcesTools.replaceMessage(title, "date", StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
            String content = ResourcesTools.getOptionsMessage("Task.assign.message.content");
            content = ResourcesTools.replaceMessage(content, "operator", this.getLoginUser().getRealName());
            content = ResourcesTools.replaceMessage(content, "date", StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
            content = ResourcesTools.replaceMessage(content, "info", task.toString());
            MessagesBox mb = new MessagesBox();
            mb.setTitle(title);
            mb.setCreateTime(StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
            mb.setOperatorByToUser(task.getOperatorByDoUser());
            mb.setViewIt(MessagesBox.MESSAGESBOX_VIEW_IT_NO);
            mb.setContent(content);
            mb.setAttrFile("");
            mb.setMessageType(MessagesBox.MESSAGESBOX_TYPE_SYSTEM);
            this.taskService.saveObject(mb);
            this.taskService.sendNoticEmail(title, content, mb.getOperatorByToUser());
        }
        if (taskForm.getViewPath() != null && taskForm.getViewPath() == 2) {
            return mapping.findForward("operatorsuccess");
        }
        return mapping.findForward("taskListAssignAction");
    }

    public ActionForward updateTask(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String attrFile;
        TaskForm taskForm = (TaskForm)form;
        Task task = this.taskService.getTask(taskForm.getPk());
        String solution = task.getSolution();
        String evaluate = task.getEvaluate();
        Integer quanliryStatus = task.getQualityStatusType();
        Float score = task.getScore();
        ObjectUtil.objectPopulate((Object)task, (Object)taskForm, true);
        task.setSolution(solution);
        task.setEvaluate(evaluate);
        task.setScore(score);
        task.setQualityStatusType(quanliryStatus);
        if (taskForm.getOperatorPk() != null) {
            task.setOperatorByDoUser(this.operatorService.getOperator(taskForm.getOperatorPk()));
        }
        if (StringTools.isNotEmpty(attrFile = this.saveUploadFile(taskForm.getAttrFile(), HighestHelpProduct.getDataPath()))) {
            task.setAttrFile(attrFile);
        }
        this.taskService.updateTask(task);
        if (taskForm.getViewPath() != null && taskForm.getViewPath() == 2) {
            return mapping.findForward("operatorsuccess");
        }
        return mapping.findForward("taskListAssignAction");
    }

    public ActionForward updateTaskStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean auto;
        TaskForm taskForm = (TaskForm)form;
        Task task = this.taskService.getTask(taskForm.getPk());
        task.setTaskStatusType(taskForm.getTaskStatusType());
        task.setSolution(taskForm.getSolution());
        this.taskService.updateTask(task);
        if ("on".equals(taskForm.getShare())) {
            Experience experience = new Experience();
            experience.setTitle(task.getName());
            experience.setExperienceType(SelectorCache.getValueByAliasCode("experience_common").getPk());
            experience.setContent(task.getContent());
            experience.setSolution(task.getSolution());
            experience.setCreateTime(StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
            experience.setCreateUser(task.getOperator().getRealName());
            this.experienceService.saveExperience(experience);
        }
        if (auto = ResourcesTools.convertToBoolean(ResourcesTools.getOptionsMessage("option.system.message.send.auto"), false)) {
            String title = ResourcesTools.getOptionsMessage("Task.status.change.message.title");
            title = ResourcesTools.replaceMessage(title, "operator", this.getLoginUser().getRealName());
            title = ResourcesTools.replaceMessage(title, "date", StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
            String content = ResourcesTools.getOptionsMessage("Task.status.change.message.content");
            content = ResourcesTools.replaceMessage(content, "operator", this.getLoginUser().getRealName());
            content = ResourcesTools.replaceMessage(content, "date", StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
            content = ResourcesTools.replaceMessage(content, "info", task.toString());
            MessagesBox mb = new MessagesBox();
            mb.setTitle(title);
            mb.setCreateTime(StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
            mb.setOperatorByToUser(task.getOperator());
            mb.setViewIt(MessagesBox.MESSAGESBOX_VIEW_IT_NO);
            mb.setContent(content);
            mb.setAttrFile("");
            mb.setMessageType(MessagesBox.MESSAGESBOX_TYPE_SYSTEM);
            this.taskService.saveObject(mb);
            this.taskService.sendNoticEmail(title, content, mb.getOperatorByToUser());
        }
        if (taskForm.getViewPath() != null && taskForm.getViewPath() == 2) {
            return mapping.findForward("operatorsuccess");
        }
        return mapping.findForward("taskListAction");
    }

    public ActionForward updateTaskQualityStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TaskForm taskForm = (TaskForm)form;
        Task task = this.taskService.getTask(taskForm.getPk());
        task.setQualityStatusType(taskForm.getQualityStatusType());
        task.setScore(taskForm.getScore());
        task.setEvaluate(taskForm.getEvaluate());
        this.taskService.updateTask(task);
        boolean auto = ResourcesTools.convertToBoolean(ResourcesTools.getOptionsMessage("option.system.message.send.auto"), false);
        if (auto) {
            String title = ResourcesTools.getOptionsMessage("Task.qualitystatus.change.message.title");
            title = ResourcesTools.replaceMessage(title, "operator", this.getLoginUser().getRealName());
            title = ResourcesTools.replaceMessage(title, "date", StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
            String content = ResourcesTools.getOptionsMessage("Task.qualitystatus.change.message.content");
            content = ResourcesTools.replaceMessage(content, "operator", this.getLoginUser().getRealName());
            content = ResourcesTools.replaceMessage(content, "date", StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
            content = ResourcesTools.replaceMessage(content, "info", task.toString());
            MessagesBox mb = new MessagesBox();
            mb.setTitle(title);
            mb.setCreateTime(StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
            mb.setOperatorByToUser(task.getOperatorByDoUser());
            mb.setViewIt(MessagesBox.MESSAGESBOX_VIEW_IT_NO);
            mb.setContent(content);
            mb.setAttrFile("");
            mb.setMessageType(MessagesBox.MESSAGESBOX_TYPE_SYSTEM);
            this.taskService.saveObject(mb);
            this.taskService.sendNoticEmail(title, content, mb.getOperatorByToUser());
        }
        if (taskForm.getViewPath() != null && taskForm.getViewPath() == 2) {
            return mapping.findForward("operatorsuccess");
        }
        return mapping.findForward("taskListAssignAction");
    }

    public ActionForward defeasanceTask(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TaskForm taskForm = (TaskForm)form;
        Task task = this.taskService.getTask(taskForm.getPk());
        task.setTaskStatusType(Task.TASK_STATUS_STOP);
        this.taskService.updateTask(task);
        return mapping.findForward("taskListAssignAction");
    }

    public ActionForward deleteTask(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TaskForm taskForm = (TaskForm)form;
        String pks = StringTools.Array2String(taskForm.getSelectPks());
        if (StringTools.isNotEmpty(pks)) {
            this.taskService.executeHQL("update Task task set task.delIt = " + BaseForm.ITEM_DEL_YES + " where task.pk in(" + pks + ")");
        }
        if (taskForm.getViewPath() != null && taskForm.getViewPath() == 2) {
            return mapping.findForward("operatorsuccess");
        }
        return mapping.findForward("taskListAssignAction");
    }

    public ActionForward moveTask(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TaskForm taskForm = (TaskForm)form;
        Task task = this.taskService.getTask(taskForm.getPk());
        task.setOperatorByDoUser(this.operatorService.getOperator(taskForm.getOperatorPk()));
        this.taskService.updateTask(task);
        boolean auto = ResourcesTools.convertToBoolean(ResourcesTools.getOptionsMessage("option.system.message.send.auto"), false);
        if (auto) {
            String title = ResourcesTools.getOptionsMessage("Task.move.message.title");
            title = ResourcesTools.replaceMessage(title, "operator", this.getLoginUser().getRealName());
            title = ResourcesTools.replaceMessage(title, "date", StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
            String content = ResourcesTools.getOptionsMessage("Task.move.message.content");
            content = ResourcesTools.replaceMessage(content, "operator", this.getLoginUser().getRealName());
            content = ResourcesTools.replaceMessage(content, "date", StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
            content = ResourcesTools.replaceMessage(content, "info", task.toString());
            MessagesBox mb = new MessagesBox();
            mb.setTitle(title);
            mb.setCreateTime(StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
            mb.setOperatorByToUser(task.getOperatorByDoUser());
            mb.setViewIt(MessagesBox.MESSAGESBOX_VIEW_IT_NO);
            mb.setContent(content);
            mb.setAttrFile("");
            mb.setMessageType(MessagesBox.MESSAGESBOX_TYPE_SYSTEM);
            this.taskService.saveObject(mb);
            this.taskService.sendNoticEmail(title, content, mb.getOperatorByToUser());
        }
        return mapping.findForward("taskListAction");
    }

    public ActionForward goAddPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Plan plan;
        List<ListValue> priorityTypeSelect = this.selectorCache.getListValuesByListClassType("priorityType");
        request.setAttribute("priorityTypeSelect", priorityTypeSelect);
        List<ListValue> qualityStatusTypeSelect = this.selectorCache.getListValuesByListClassType("qualityStatusType");
        request.setAttribute("qualityStatusTypeSelect", qualityStatusTypeSelect);
        TaskForm taskForm = (TaskForm)form;
        taskForm.setCode(Config.getUniquePk("T"));
        if (taskForm.getPlanPk() != null && (plan = this.planService.getPlan(taskForm.getPlanPk())) != null) {
            taskForm.setPlanPk(plan.getPk());
            taskForm.setPlanCode(plan.getCode());
            taskForm.setPlanName(plan.getName());
        }
        return mapping.findForward("taskAdd");
    }

    public ActionForward goMovePage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TaskForm taskForm = (TaskForm)form;
        Task task = this.taskService.getTask(taskForm.getPk());
        request.setAttribute("taskPojo", (Object)task);
        List dList = this.operatorService.getList("from Department department");
        this.setDepartmentTreeInRequest(request, dList, "departments");
        return mapping.findForward("taskMove");
    }

    public ActionForward goModifyPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<ListValue> priorityTypeSelect = this.selectorCache.getListValuesByListClassType("priorityType");
        request.setAttribute("priorityTypeSelect", priorityTypeSelect);
        List<ListValue> qualityStatusTypeSelect = this.selectorCache.getListValuesByListClassType("qualityStatusType");
        request.setAttribute("qualityStatusTypeSelect", qualityStatusTypeSelect);
        TaskForm taskForm = (TaskForm)form;
        Task task = null;
        task = taskForm.getPk() != null ? this.taskService.getTask(taskForm.getPk()) : this.taskService.getTask(Integer.valueOf(taskForm.getSelectPks()[0]));
        ObjectUtil.objectPopulate((Object)taskForm, task);
        taskForm.setOperatorPk(task.getOperatorByDoUser().getPk());
        taskForm.setOperatorRealName(task.getOperatorByDoUser().getRealName());
        Plan plan = task.getPlan();
        if (plan != null) {
            taskForm.setPlanPk(plan.getPk());
            taskForm.setPlanCode(plan.getCode());
            taskForm.setPlanName(plan.getName());
        }
        return mapping.findForward("taskModify");
    }

    public TaskService getTaskService() {
        return this.taskService;
    }

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    public OperatorService getOperatorService() {
        return this.operatorService;
    }

    public void setOperatorService(OperatorService operatorService) {
        this.operatorService = operatorService;
    }

    public PlanService getPlanService() {
        return this.planService;
    }

    public void setPlanService(PlanService planService) {
        this.planService = planService;
    }

    public TaskControlService getTaskControlService() {
        return this.taskControlService;
    }

    public void setTaskControlService(TaskControlService taskControlService) {
        this.taskControlService = taskControlService;
    }

    public ExperienceService getExperienceService() {
        return this.experienceService;
    }

    public void setExperienceService(ExperienceService experienceService) {
        this.experienceService = experienceService;
    }
}

