/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.pdcajob.action;

import com.highesthelp.framework.action.BaseAction;
import com.highesthelp.framework.common.Page;
import com.highesthelp.framework.util.ObjectUtil;
import com.highesthelp.framework.util.ResourcesTools;
import com.highesthelp.framework.util.StringTools;
import com.highesthelp.pdcajob.form.TaskControlForm;
import com.highesthelp.pdcajob.pojo.MessagesBox;
import com.highesthelp.pdcajob.pojo.Task;
import com.highesthelp.pdcajob.pojo.TaskControl;
import com.highesthelp.pdcajob.service.TaskControlService;
import com.highesthelp.pdcajob.service.TaskService;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class TaskControlAction
extends BaseAction {
    private TaskControlService taskControlService;
    private TaskService taskService;

    public ActionForward viewTaskControl(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TaskControlForm taskControlForm = (TaskControlForm)form;
        TaskControl taskControl = this.taskControlService.getTaskControl(taskControlForm.getPk());
        request.setAttribute("taskControlPojo", (Object)taskControl);
        return mapping.findForward("taskControlView");
    }

    public ActionForward listTaskControl(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Page page = this.taskControlService.getTaskControlPage();
        this.addEmptyRows(new TaskControl(), page, request, false);
        return mapping.findForward("taskControlList");
    }

    public ActionForward addTaskControl(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TaskControlForm taskControlForm = (TaskControlForm)form;
        TaskControl taskControl = new TaskControl();
        ObjectUtil.objectPopulate(taskControl, (Object)taskControlForm);
        taskControl.setCreateTime(StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
        Task task = this.taskService.getTask(taskControlForm.getTaskPk());
        taskControl.setTask(task);
        taskControl.setOperator(this.getLoginUser());
        this.taskControlService.saveTaskControl(taskControl);
        boolean auto = ResourcesTools.convertToBoolean(ResourcesTools.getOptionsMessage("option.system.message.send.auto"), false);
        if (auto) {
            String title = ResourcesTools.getOptionsMessage("Task.assign.control.title");
            title = ResourcesTools.replaceMessage(title, "operator", this.getLoginUser().getRealName());
            title = ResourcesTools.replaceMessage(title, "date", StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
            String content = ResourcesTools.getOptionsMessage("Task.assign.control.content");
            content = ResourcesTools.replaceMessage(content, "operator", this.getLoginUser().getRealName());
            content = ResourcesTools.replaceMessage(content, "date", StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
            content = ResourcesTools.replaceMessage(content, "code", task.getCode());
            MessagesBox mb = new MessagesBox();
            mb.setTitle(title);
            mb.setCreateTime(StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
            mb.setOperatorByToUser(task.getOperatorByDoUser());
            mb.setViewIt(MessagesBox.MESSAGESBOX_VIEW_IT_NO);
            mb.setContent(content);
            mb.setAttrFile("");
            mb.setMessageType(MessagesBox.MESSAGESBOX_TYPE_SYSTEM);
            this.taskControlService.saveObject(mb);
            this.taskControlService.sendNoticEmail(title, content, mb.getOperatorByToUser());
        }
        return mapping.findForward("operatorsuccess");
    }

    public ActionForward updateTaskControl(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TaskControlForm taskControlForm = (TaskControlForm)form;
        TaskControl taskControl = this.taskControlService.getTaskControl(taskControlForm.getPk());
        ObjectUtil.objectPopulate((Object)taskControl, (Object)taskControlForm, true);
        this.taskControlService.updateTaskControl(taskControl);
        return mapping.findForward("operatorsuccess");
    }

    public ActionForward deleteTaskControl(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TaskControlForm taskControlForm = (TaskControlForm)form;
        this.taskControlService.deleteTaskControls(taskControlForm.getSelectPks());
        return mapping.findForward("operatorsuccess");
    }

    public ActionForward goAddPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("taskControlAdd");
    }

    public ActionForward goModifyPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TaskControlForm taskControlForm = (TaskControlForm)form;
        TaskControl taskControl = null;
        taskControl = taskControlForm.getPk() != null ? this.taskControlService.getTaskControl(taskControlForm.getPk()) : this.taskControlService.getTaskControl(Integer.valueOf(taskControlForm.getSelectPks()[0]));
        ObjectUtil.objectPopulate((Object)taskControlForm, taskControl);
        return mapping.findForward("taskControlModify");
    }

    public TaskControlService getTaskControlService() {
        return this.taskControlService;
    }

    public void setTaskControlService(TaskControlService taskControlService) {
        this.taskControlService = taskControlService;
    }

    public TaskService getTaskService() {
        return this.taskService;
    }

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }
}

