/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.pdcajob.action;

import com.highesthelp.framework.HighestHelpProduct;
import com.highesthelp.framework.action.BaseAction;
import com.highesthelp.framework.common.Page;
import com.highesthelp.framework.util.ObjectUtil;
import com.highesthelp.framework.util.ResourcesTools;
import com.highesthelp.framework.util.StringTools;
import com.highesthelp.pdcajob.form.WorkStatementForm;
import com.highesthelp.pdcajob.pojo.MessagesBox;
import com.highesthelp.pdcajob.pojo.WorkStatement;
import com.highesthelp.pdcajob.service.OperatorService;
import com.highesthelp.pdcajob.service.WorkStatementService;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class WorkStatementAction
extends BaseAction {
    private WorkStatementService workStatementService;
    private OperatorService operatorService;

    public ActionForward viewWorkStatement(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WorkStatementForm workStatementForm = (WorkStatementForm)form;
        WorkStatement workStatement = this.workStatementService.getWorkStatement(workStatementForm.getPk());
        ObjectUtil.objectPopulate((Object)workStatementForm, workStatement);
        request.setAttribute("workStatementPojo", (Object)workStatement);
        if (workStatementForm.getViewPath() != null && workStatementForm.getViewPath() == 1) {
            return mapping.findForward("workStatementUnderLineView");
        }
        return mapping.findForward("workStatementView");
    }

    public ActionForward listWorkStatement(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WorkStatementForm workStatementForm = (WorkStatementForm)form;
        Page page = this.workStatementService.getWorkStatementPage();
        this.addEmptyRows(new WorkStatement(), page, request);
        if (workStatementForm.getViewPath() != null && workStatementForm.getViewPath() == 1) {
            return mapping.findForward("workStatementUnderLineList");
        }
        return mapping.findForward("workStatementList");
    }

    public ActionForward addWorkStatement(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WorkStatementForm workStatementForm = (WorkStatementForm)form;
        WorkStatement workStatement = new WorkStatement();
        String attrFile = this.saveUploadFile(workStatementForm.getAttrFile(), HighestHelpProduct.getDataPath());
        workStatement.setAttrFile(attrFile);
        ObjectUtil.objectPopulate(workStatement, (Object)workStatementForm);
        workStatement.setCreateTime(StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
        workStatement.setOperatorByCreateUser(this.getLoginUser());
        if (workStatementForm.getOperatorPk() != null) {
            workStatement.setOperatorByAcceptUser(this.operatorService.getOperator(workStatementForm.getOperatorPk()));
        }
        workStatement.setAcceptDel(WorkStatement.WORKSTATEMENT_DEL_NO);
        workStatement.setCreateDel(WorkStatement.WORKSTATEMENT_DEL_NO);
        this.workStatementService.saveWorkStatement(workStatement);
        boolean auto = ResourcesTools.convertToBoolean(ResourcesTools.getOptionsMessage("option.system.message.send.auto"), false);
        if (auto) {
            String title = ResourcesTools.getOptionsMessage("WorkStatement.send.message.title");
            title = ResourcesTools.replaceMessage(title, "operator", this.getLoginUser().getRealName());
            title = ResourcesTools.replaceMessage(title, "date", StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
            String content = ResourcesTools.getOptionsMessage("WorkStatement.send.message.content");
            content = ResourcesTools.replaceMessage(content, "operator", this.getLoginUser().getRealName());
            content = ResourcesTools.replaceMessage(content, "date", StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
            content = ResourcesTools.replaceMessage(content, "title", workStatementForm.getTitle());
            MessagesBox mb = new MessagesBox();
            mb.setTitle(title);
            mb.setCreateTime(StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
            if (workStatementForm.getOperatorPk() != null) {
                mb.setOperatorByToUser(this.operatorService.getOperator(workStatementForm.getOperatorPk()));
            }
            mb.setViewIt(MessagesBox.MESSAGESBOX_VIEW_IT_NO);
            mb.setContent(content);
            mb.setAttrFile("");
            mb.setMessageType(MessagesBox.MESSAGESBOX_TYPE_SYSTEM);
            this.workStatementService.saveObject(mb);
            this.workStatementService.sendNoticEmail(title, content, mb.getOperatorByToUser());
        }
        return mapping.findForward("workStatementListAction");
    }

    public ActionForward updateWorkStatement(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WorkStatementForm workStatementForm = (WorkStatementForm)form;
        WorkStatement workStatement = this.workStatementService.getWorkStatement(workStatementForm.getPk());
        workStatement.setSummary(workStatementForm.getSummary());
        this.workStatementService.updateWorkStatement(workStatement);
        boolean auto = ResourcesTools.convertToBoolean(ResourcesTools.getOptionsMessage("option.system.message.send.auto"), false);
        if (auto) {
            String title = ResourcesTools.getOptionsMessage("WorkStatement.summary.message.title");
            title = ResourcesTools.replaceMessage(title, "operator", this.getLoginUser().getRealName());
            title = ResourcesTools.replaceMessage(title, "date", StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
            String content = ResourcesTools.getOptionsMessage("WorkStatement.summary.message.content");
            content = ResourcesTools.replaceMessage(content, "operator", this.getLoginUser().getRealName());
            content = ResourcesTools.replaceMessage(content, "date", StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
            content = ResourcesTools.replaceMessage(content, "title", workStatement.getTitle());
            MessagesBox mb = new MessagesBox();
            mb.setTitle(title);
            mb.setCreateTime(StringTools.Date2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
            mb.setOperatorByToUser(workStatement.getOperatorByCreateUser());
            mb.setViewIt(MessagesBox.MESSAGESBOX_VIEW_IT_NO);
            mb.setContent(content);
            mb.setAttrFile("");
            mb.setMessageType(MessagesBox.MESSAGESBOX_TYPE_SYSTEM);
            this.workStatementService.saveObject(mb);
            this.workStatementService.sendNoticEmail(title, content, mb.getOperatorByToUser());
        }
        if (workStatementForm.getViewPath() != null && workStatementForm.getViewPath() == 1) {
            return mapping.findForward("workStatementListUnderAction");
        }
        return mapping.findForward("workStatementListAction");
    }

    public ActionForward deleteWorkStatement(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WorkStatementForm workStatementForm = (WorkStatementForm)form;
        String pks = StringTools.Array2String(workStatementForm.getSelectPks());
        if (StringTools.isNotEmpty(pks)) {
            List list = this.workStatementService.getList("from WorkStatement workStatement where workStatement.pk in(" + pks + ")");
            int i = 0;
            while (i < list.size()) {
                WorkStatement workStatement = (WorkStatement)list.get(i);
                if (workStatement != null) {
                    if (workStatementForm.getViewPath() != null && workStatementForm.getViewPath() == 1) {
                        workStatement.setAcceptDel(WorkStatement.WORKSTATEMENT_DEL_YES);
                    } else {
                        workStatement.setCreateDel(WorkStatement.WORKSTATEMENT_DEL_YES);
                    }
                    this.workStatementService.updateWorkStatement(workStatement);
                }
                ++i;
            }
        }
        if (workStatementForm.getViewPath() != null && workStatementForm.getViewPath() == 1) {
            return mapping.findForward("workStatementListUnderAction");
        }
        return mapping.findForward("workStatementListAction");
    }

    public ActionForward goAddPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("workStatementAdd");
    }

    public ActionForward goModifyPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WorkStatementForm workStatementForm = (WorkStatementForm)form;
        WorkStatement workStatement = null;
        workStatement = workStatementForm.getPk() != null ? this.workStatementService.getWorkStatement(workStatementForm.getPk()) : this.workStatementService.getWorkStatement(Integer.valueOf(workStatementForm.getSelectPks()[0]));
        ObjectUtil.objectPopulate((Object)workStatementForm, workStatement);
        return mapping.findForward("workStatementModify");
    }

    public WorkStatementService getWorkStatementService() {
        return this.workStatementService;
    }

    public void setWorkStatementService(WorkStatementService workStatementService) {
        this.workStatementService = workStatementService;
    }

    public OperatorService getOperatorService() {
        return this.operatorService;
    }

    public void setOperatorService(OperatorService operatorService) {
        this.operatorService = operatorService;
    }
}

