/*
 * Decompiled with CFR 0.152.
 */
package com.highesthelp.pdcajob.service;

import com.highesthelp.framework.common.Page;
import com.highesthelp.framework.common.WebContext;
import com.highesthelp.framework.exception.DataAccessException;
import com.highesthelp.framework.form.BaseForm;
import com.highesthelp.framework.service.BaseServiceImpl;
import com.highesthelp.framework.util.StringTools;
import com.highesthelp.pdcajob.pojo.Plan;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class PlanService
extends BaseServiceImpl {
    public Plan getPlan(Integer pk) throws DataAccessException {
        return (Plan)this.getObject(new Plan(), pk);
    }

    public Plan getPlanByCode(String code) throws DataAccessException {
        List list = this.getList("from Plan plan where plan.code = ?", new Object[]{code});
        if (list.size() > 1) {
            throw new DataAccessException("two same code plan in the db code = " + code);
        }
        if (list.size() == 1) {
            return (Plan)list.get(0);
        }
        return null;
    }

    public Page getPlanPage() throws Exception, DataAccessException {
        String hql = this.getSearchHQL();
        return this.getPage(hql);
    }

    public Plan savePlan(Plan plan) throws DataAccessException {
        return (Plan)this.saveObject(plan);
    }

    public Plan updatePlan(Plan plan) throws DataAccessException {
        return (Plan)this.updateObject(plan);
    }

    public boolean deletePlan(Plan plan) throws DataAccessException {
        plan = this.getPlan(plan.getPk());
        return this.deleteObject(plan);
    }

    public boolean deletePlans(String[] pks) throws DataAccessException {
        String hql = "delete from Plan where pk in(" + StringTools.Array2String(pks) + ")";
        this.executeHQL(hql);
        return true;
    }

    public String getSearchHQL() throws Exception {
        HttpServletRequest request = WebContext.getWebContext().getRequest();
        String hql = "from Plan as plan";
        String where = " where plan.operator.pk = " + this.getLoginUser().getPk() + " and plan.delIt = " + BaseForm.ITEM_DEL_NO;
        if (StringTools.isNotEmpty(request.getParameter("name"))) {
            where = String.valueOf(where) + " and plan.name like '%" + request.getParameter("name").trim() + "%'";
        }
        if (StringTools.isNotEmpty(request.getParameter("planType"))) {
            where = String.valueOf(where) + " and plan.planType = " + request.getParameter("planType");
        }
        if (StringTools.isNotEmpty(request.getParameter("qualityStatusType"))) {
            where = String.valueOf(where) + " and plan.qualityStatusType = " + request.getParameter("qualityStatusType");
        }
        if (StringTools.isNotEmpty(request.getParameter("startTime"))) {
            where = String.valueOf(where) + " and plan.startTime >= '" + request.getParameter("startTime") + "'";
        }
        if (StringTools.isNotEmpty(request.getParameter("endTime"))) {
            where = String.valueOf(where) + " and plan.endTime <= '" + request.getParameter("endTime") + "'";
        }
        hql = String.valueOf(hql) + where;
        String orderString = this.getOrderString("plan");
        hql = !StringTools.isEmpty(orderString) ? String.valueOf(hql) + orderString : String.valueOf(hql) + " order by plan.pk desc";
        return hql;
    }
}

