/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.view;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.extremecomponents.table.bean.Column;
import org.extremecomponents.table.calc.CalcResult;
import org.extremecomponents.table.calc.CalcUtils;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.view.ExportViewUtils;
import org.extremecomponents.table.view.View;
import org.extremecomponents.util.ExtremeUtils;

public class XlsView
implements View {
    private static Log logger = LogFactory.getLog((Class)(class$org$extremecomponents$table$view$XlsView == null ? (class$org$extremecomponents$table$view$XlsView = XlsView.class$("org.extremecomponents.table.view.XlsView")) : class$org$extremecomponents$table$view$XlsView));
    public static final int WIDTH_MULT = 240;
    public static final int MIN_CHARS = 8;
    public static final short DEFAULT_FONT_HEIGHT = 8;
    public static final double NON_NUMERIC = -0.99999;
    public static final String DEFAULT_MONEY_FORMAT = "$###,###,##0.00";
    public static final String DEFAULT_PERCENT_FORMAT = "##0.0%";
    public static final String NBSP = "&nbsp;";
    private HSSFWorkbook wb;
    private HSSFSheet sheet;
    private HSSFPrintSetup ps;
    private Map styles;
    private short rownum;
    private short cellnum;
    private HSSFRow hssfRow;
    private String moneyFormat;
    private String percentFormat;
    private String encoding;
    static /* synthetic */ Class class$org$extremecomponents$table$view$XlsView;

    public void beforeBody(TableModel model) {
        logger.debug((Object)"XlsView.init()");
        this.moneyFormat = model.getPreferences().getPreference("table.exportableformat.money");
        if (StringUtils.isEmpty((String)this.moneyFormat)) {
            this.moneyFormat = DEFAULT_MONEY_FORMAT;
        }
        this.percentFormat = model.getPreferences().getPreference("table.exportableformat.percent");
        if (StringUtils.isEmpty((String)this.percentFormat)) {
            this.percentFormat = DEFAULT_PERCENT_FORMAT;
        }
        this.encoding = model.getExportHandler().getCurrentExport().getEncoding();
        this.wb = new HSSFWorkbook();
        this.sheet = this.wb.createSheet();
        if (this.encoding.equalsIgnoreCase("UTF")) {
            this.wb.setSheetName(0, "Export Workbook", (short)1);
        } else if (this.encoding.equalsIgnoreCase("UNICODE")) {
            this.wb.setSheetName(0, "Export Workbook", (short)0);
        }
        this.styles = this.initStyles(this.wb);
        this.ps = this.sheet.getPrintSetup();
        this.sheet.setAutobreaks(true);
        this.ps.setFitHeight((short)1);
        this.ps.setFitWidth((short)1);
        this.createHeader(model);
    }

    public void body(TableModel model, Column column) {
        if (column.isFirstColumn()) {
            this.rownum = (short)(this.rownum + 1);
            this.cellnum = 0;
            this.hssfRow = this.sheet.createRow((int)this.rownum);
        }
        String value = ExportViewUtils.parseXLS(column.getCellDisplay());
        HSSFCell hssfCell = this.hssfRow.createCell(this.cellnum);
        this.setCellEncoding(hssfCell);
        if (column.isEscapeAutoFormat()) {
            this.writeToCellAsText(hssfCell, value, "");
        } else {
            this.writeToCellFormatted(hssfCell, value, "");
        }
        this.cellnum = (short)(this.cellnum + 1);
    }

    public Object afterBody(TableModel model) {
        if (model.getLimit().getTotalRows() != 0) {
            this.totals(model);
        }
        return this.wb;
    }

    private void createHeader(TableModel model) {
        this.rownum = 0;
        this.cellnum = 0;
        HSSFRow row = this.sheet.createRow((int)this.rownum);
        List columns = model.getColumnHandler().getHeaderColumns();
        Iterator iter = columns.iterator();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            String title = column.getCellDisplay();
            HSSFCell hssfCell = row.createCell(this.cellnum);
            this.setCellEncoding(hssfCell);
            hssfCell.setCellStyle((HSSFCellStyle)this.styles.get("titleStyle"));
            hssfCell.setCellType(1);
            hssfCell.setCellValue(title);
            int valWidth = (title + "").length() * 240;
            this.sheet.setColumnWidth(hssfCell.getCellNum(), (short)valWidth);
            this.cellnum = (short)(this.cellnum + 1);
        }
    }

    private void writeToCellAsText(HSSFCell cell, String value, String styleModifier) {
        if (value.trim().equals(NBSP)) {
            value = "";
        }
        cell.setCellStyle((HSSFCellStyle)this.styles.get("textStyle" + styleModifier));
        this.fixWidthAndPopulate(cell, -0.99999, value);
    }

    private void writeToCellFormatted(HSSFCell cell, String value, String styleModifier) {
        double numeric = -0.99999;
        try {
            numeric = Double.parseDouble(value);
        }
        catch (Exception e) {
            numeric = -0.99999;
        }
        if (value.startsWith("$") || value.endsWith("%") || value.startsWith("($")) {
            boolean moneyFlag = value.startsWith("$") || value.startsWith("($");
            boolean percentFlag = value.endsWith("%");
            value = StringUtils.replace((String)value, (String)"$", (String)"");
            value = StringUtils.replace((String)value, (String)"%", (String)"");
            value = StringUtils.replace((String)value, (String)",", (String)"");
            value = StringUtils.replace((String)value, (String)"(", (String)"-");
            value = StringUtils.replace((String)value, (String)")", (String)"");
            try {
                numeric = Double.parseDouble(value);
            }
            catch (Exception e) {
                numeric = -0.99999;
            }
            cell.setCellType(0);
            if (moneyFlag) {
                cell.setCellStyle((HSSFCellStyle)this.styles.get("moneyStyle" + styleModifier));
            } else if (percentFlag) {
                numeric /= 100.0;
                cell.setCellStyle((HSSFCellStyle)this.styles.get("percentStyle" + styleModifier));
            }
        } else if (numeric != -0.99999) {
            cell.setCellStyle((HSSFCellStyle)this.styles.get("numericStyle" + styleModifier));
        } else {
            if (value.trim().equals(NBSP)) {
                value = "";
            }
            cell.setCellStyle((HSSFCellStyle)this.styles.get("textStyle" + styleModifier));
        }
        this.fixWidthAndPopulate(cell, numeric, value);
    }

    private void fixWidthAndPopulate(HSSFCell cell, double numeric, String value) {
        int valWidth = 0;
        if (numeric != -0.99999) {
            cell.setCellValue(numeric);
            valWidth = (cell.getNumericCellValue() + "$,.").length() * 240;
        } else {
            cell.setCellValue(value);
            valWidth = (cell.getStringCellValue() + "").length() * 240;
            if (valWidth < 1920) {
                valWidth = 1920;
            }
        }
        if (valWidth > this.sheet.getColumnWidth(cell.getCellNum())) {
            this.sheet.setColumnWidth(cell.getCellNum(), (short)valWidth);
        }
    }

    private Map initStyles(HSSFWorkbook wb) {
        return this.initStyles(wb, (short)8);
    }

    private Map initStyles(HSSFWorkbook wb, short fontHeight) {
        HashMap<String, HSSFCellStyle> result = new HashMap<String, HSSFCellStyle>();
        HSSFCellStyle titleStyle = wb.createCellStyle();
        HSSFCellStyle textStyle = wb.createCellStyle();
        HSSFCellStyle boldStyle = wb.createCellStyle();
        HSSFCellStyle numericStyle = wb.createCellStyle();
        HSSFCellStyle numericStyleBold = wb.createCellStyle();
        HSSFCellStyle moneyStyle = wb.createCellStyle();
        HSSFCellStyle moneyStyleBold = wb.createCellStyle();
        HSSFCellStyle percentStyle = wb.createCellStyle();
        HSSFCellStyle percentStyleBold = wb.createCellStyle();
        HSSFCellStyle moneyStyle_Totals = wb.createCellStyle();
        HSSFCellStyle naStyle_Totals = wb.createCellStyle();
        HSSFCellStyle numericStyle_Totals = wb.createCellStyle();
        HSSFCellStyle percentStyle_Totals = wb.createCellStyle();
        HSSFCellStyle textStyle_Totals = wb.createCellStyle();
        result.put("titleStyle", titleStyle);
        result.put("textStyle", textStyle);
        result.put("boldStyle", boldStyle);
        result.put("numericStyle", numericStyle);
        result.put("numericStyleBold", numericStyleBold);
        result.put("moneyStyle", moneyStyle);
        result.put("moneyStyleBold", moneyStyleBold);
        result.put("percentStyle", percentStyle);
        result.put("percentStyleBold", percentStyleBold);
        result.put("moneyStyle_Totals", moneyStyle_Totals);
        result.put("naStyle_Totals", naStyle_Totals);
        result.put("numericStyle_Totals", numericStyle_Totals);
        result.put("percentStyle_Totals", percentStyle_Totals);
        result.put("textStyle_Totals", textStyle_Totals);
        HSSFDataFormat format = wb.createDataFormat();
        HSSFFont font = wb.createFont();
        font.setBoldweight((short)400);
        font.setColor((short)8);
        font.setFontName("Arial");
        font.setFontHeightInPoints(fontHeight);
        HSSFFont fontBold = wb.createFont();
        fontBold.setBoldweight((short)700);
        fontBold.setColor((short)8);
        fontBold.setFontName("Arial");
        fontBold.setFontHeightInPoints(fontHeight);
        moneyStyle.setFont(font);
        moneyStyle.setAlignment((short)3);
        moneyStyle.setDataFormat(format.getFormat(this.moneyFormat));
        moneyStyleBold.setFont(fontBold);
        moneyStyleBold.setAlignment((short)3);
        moneyStyleBold.setDataFormat(format.getFormat(this.moneyFormat));
        percentStyle.setFont(font);
        percentStyle.setAlignment((short)3);
        percentStyle.setDataFormat(format.getFormat(this.percentFormat));
        percentStyleBold.setFont(fontBold);
        percentStyleBold.setAlignment((short)3);
        percentStyleBold.setDataFormat(format.getFormat(this.percentFormat));
        numericStyle.setFont(font);
        numericStyle.setAlignment((short)3);
        numericStyleBold.setFont(fontBold);
        numericStyleBold.setAlignment((short)3);
        titleStyle.setFont(font);
        titleStyle.setFillForegroundColor((short)22);
        titleStyle.setFillPattern((short)1);
        titleStyle.setBorderBottom((short)1);
        titleStyle.setBottomBorderColor((short)8);
        titleStyle.setBorderLeft((short)1);
        titleStyle.setLeftBorderColor((short)8);
        titleStyle.setBorderRight((short)1);
        titleStyle.setRightBorderColor((short)8);
        titleStyle.setBorderTop((short)1);
        titleStyle.setTopBorderColor((short)8);
        titleStyle.setAlignment((short)2);
        titleStyle.setVerticalAlignment((short)1);
        textStyle.setFont(font);
        textStyle.setWrapText(true);
        boldStyle.setFont(fontBold);
        boldStyle.setWrapText(true);
        moneyStyle_Totals.setFont(fontBold);
        moneyStyle_Totals.setFillForegroundColor((short)22);
        moneyStyle_Totals.setFillPattern((short)1);
        moneyStyle_Totals.setBorderBottom((short)1);
        moneyStyle_Totals.setBottomBorderColor((short)8);
        moneyStyle_Totals.setBorderTop((short)1);
        moneyStyle_Totals.setTopBorderColor((short)8);
        moneyStyle_Totals.setAlignment((short)3);
        moneyStyle_Totals.setVerticalAlignment((short)1);
        moneyStyle_Totals.setDataFormat(format.getFormat(this.moneyFormat));
        naStyle_Totals.setFont(fontBold);
        naStyle_Totals.setFillForegroundColor((short)22);
        naStyle_Totals.setFillPattern((short)1);
        naStyle_Totals.setBorderBottom((short)1);
        naStyle_Totals.setBottomBorderColor((short)8);
        naStyle_Totals.setBorderTop((short)1);
        naStyle_Totals.setTopBorderColor((short)8);
        naStyle_Totals.setAlignment((short)3);
        naStyle_Totals.setVerticalAlignment((short)1);
        numericStyle_Totals.setFont(fontBold);
        numericStyle_Totals.setFillForegroundColor((short)22);
        numericStyle_Totals.setFillPattern((short)1);
        numericStyle_Totals.setBorderBottom((short)1);
        numericStyle_Totals.setBottomBorderColor((short)8);
        numericStyle_Totals.setBorderTop((short)1);
        numericStyle_Totals.setTopBorderColor((short)8);
        numericStyle_Totals.setAlignment((short)3);
        numericStyle_Totals.setVerticalAlignment((short)1);
        percentStyle_Totals.setFont(fontBold);
        percentStyle_Totals.setFillForegroundColor((short)22);
        percentStyle_Totals.setFillPattern((short)1);
        percentStyle_Totals.setBorderBottom((short)1);
        percentStyle_Totals.setBottomBorderColor((short)8);
        percentStyle_Totals.setBorderTop((short)1);
        percentStyle_Totals.setTopBorderColor((short)8);
        percentStyle_Totals.setAlignment((short)3);
        percentStyle_Totals.setVerticalAlignment((short)1);
        percentStyle_Totals.setDataFormat(format.getFormat(this.percentFormat));
        textStyle_Totals.setFont(fontBold);
        textStyle_Totals.setFillForegroundColor((short)22);
        textStyle_Totals.setFillPattern((short)1);
        textStyle_Totals.setBorderBottom((short)1);
        textStyle_Totals.setBottomBorderColor((short)8);
        textStyle_Totals.setBorderTop((short)1);
        textStyle_Totals.setTopBorderColor((short)8);
        textStyle_Totals.setAlignment((short)1);
        textStyle_Totals.setVerticalAlignment((short)1);
        return result;
    }

    public void totals(TableModel model) {
        Column firstCalcColumn = model.getColumnHandler().getFirstCalcColumn();
        if (firstCalcColumn != null) {
            int rows = firstCalcColumn.getCalc().length;
            for (int i = 0; i < rows; ++i) {
                this.rownum = (short)(this.rownum + 1);
                HSSFRow row = this.sheet.createRow((int)this.rownum);
                this.cellnum = 0;
                Iterator iter = model.getColumnHandler().getColumns().iterator();
                while (iter.hasNext()) {
                    Column column = (Column)iter.next();
                    if (column.isFirstColumn()) {
                        String calcTitle = CalcUtils.getFirstCalcColumnTitleByPosition(model, i);
                        HSSFCell cell = row.createCell(this.cellnum);
                        this.setCellEncoding(cell);
                        if (column.isEscapeAutoFormat()) {
                            this.writeToCellAsText(cell, calcTitle, "_Totals");
                        } else {
                            this.writeToCellFormatted(cell, calcTitle, "_Totals");
                        }
                        this.cellnum = (short)(this.cellnum + 1);
                        continue;
                    }
                    if (column.isCalculated()) {
                        CalcResult calcResult = CalcUtils.getCalcResultsByPosition(model, column, i);
                        Number value = calcResult.getValue();
                        HSSFCell cell = row.createCell(this.cellnum);
                        this.setCellEncoding(cell);
                        if (value != null) {
                            if (column.isEscapeAutoFormat()) {
                                this.writeToCellAsText(cell, value.toString(), "_Totals");
                            } else {
                                this.writeToCellFormatted(cell, ExtremeUtils.formatNumber(column.getFormat(), value, model.getLocale()), "_Totals");
                            }
                        } else {
                            cell.setCellStyle((HSSFCellStyle)this.styles.get("naStyle_Totals"));
                            cell.setCellValue("n/a");
                        }
                        this.cellnum = (short)(this.cellnum + 1);
                        continue;
                    }
                    HSSFCell cell = row.createCell(this.cellnum);
                    this.setCellEncoding(cell);
                    this.writeToCellFormatted(cell, "", "_Totals");
                    this.cellnum = (short)(this.cellnum + 1);
                }
            }
        }
    }

    private void setCellEncoding(HSSFCell cell) {
        if (this.encoding.equalsIgnoreCase("UTF")) {
            cell.setEncoding((short)1);
        } else if (this.encoding.equalsIgnoreCase("UNICODE")) {
            cell.setEncoding((short)0);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

