/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.view.html;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.extremecomponents.table.bean.Column;
import org.extremecomponents.table.bean.Table;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.view.html.BuilderUtils;
import org.extremecomponents.util.HtmlBuilder;

public class TableBuilder {
    private HtmlBuilder html;
    private TableModel model;
    private Table table;

    public TableBuilder(TableModel model) {
        this(new HtmlBuilder(), model);
    }

    public TableBuilder(HtmlBuilder html, TableModel model) {
        this.html = html;
        this.model = model;
        this.table = model.getTableHandler().getTable();
    }

    public HtmlBuilder getHtmlBuilder() {
        return this.html;
    }

    protected TableModel getTableModel() {
        return this.model;
    }

    protected Table getTable() {
        return this.table;
    }

    public void tableStart() {
        this.html.table(0);
        this.id();
        this.border();
        this.cellSpacing();
        this.cellPadding();
        this.styleClass();
        this.style();
        this.width();
        this.html.close();
    }

    public void tableEnd() {
        this.html.tableEnd(0);
    }

    public void id() {
        this.html.id(this.model.getTableHandler().prefixWithTableId() + "table");
    }

    public void border() {
        String border = this.table.getBorder();
        this.html.border(border);
    }

    public void cellSpacing() {
        String cellSpacing = this.table.getCellspacing();
        this.html.cellSpacing(cellSpacing);
    }

    public void cellPadding() {
        String cellPadding = this.table.getCellpadding();
        this.html.cellPadding(cellPadding);
    }

    public void styleClass() {
        String styleClass = this.table.getStyleClass();
        this.html.styleClass(styleClass);
    }

    public void style() {
        String style = this.table.getStyle();
        this.html.style(style);
    }

    public void width() {
        String width = this.table.getWidth();
        this.html.width(width);
    }

    public void title() {
        String title;
        boolean showTitle = BuilderUtils.showTitle(this.model);
        if (showTitle && StringUtils.isNotBlank((String)(title = this.model.getTableHandler().getTable().getTitle()))) {
            this.html.span().styleClass("title").close().append(title).spanEnd();
        }
    }

    public void titleRowSpanColumns() {
        String title;
        boolean showTitle = BuilderUtils.showTitle(this.model);
        if (showTitle && StringUtils.isNotBlank((String)(title = this.model.getTableHandler().getTable().getTitle()))) {
            int columnCount = this.model.getColumnHandler().columnCount();
            this.html.tr(1).styleClass("titleRow").close();
            this.html.td(2).colSpan("" + columnCount).close();
            this.html.span().close().append(title).spanEnd();
            this.html.tdEnd();
            this.html.trEnd(1);
        }
    }

    public void headerRow() {
        this.html.tr(1).close();
        List columns = this.model.getColumnHandler().getHeaderColumns();
        Iterator iter = columns.iterator();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            this.html.append(column.getCellDisplay());
        }
        this.html.trEnd(1);
    }

    public void filterRow() {
        if (!this.model.getTableHandler().getTable().isFilterable()) {
            return;
        }
        this.html.tr(1).styleClass("filter").close();
        List columns = this.model.getColumnHandler().getFilterColumns();
        Iterator iter = columns.iterator();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            this.html.append(column.getCellDisplay());
        }
        this.html.trEnd(1);
    }

    public void theadStart() {
        this.html.thead(1).close();
    }

    public void theadEnd() {
        this.html.theadEnd(1);
    }

    public void tbodyStart() {
        this.html.tbody(1).styleClass("tableBody").close();
    }

    public void tbodyEnd() {
        this.html.tbodyEnd(1);
    }

    public void themeStart() {
        this.html.newline();
        String theme = this.model.getTableHandler().getTable().getTheme();
        this.html.div().styleClass(theme);
        this.html.close();
    }

    public void themeEnd() {
        this.html.newline();
        this.html.divEnd();
    }

    public String toString() {
        return this.html.toString();
    }
}

